/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.c14n;

import com.sun.mail.util.CRLFOutputStream;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.c14n.Canonicalizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.xml.crypto.dsig.TransformException;

public class TextPlainCanonicalizer
extends Canonicalizer {
    public TextPlainCanonicalizer() {
    }

    public TextPlainCanonicalizer(String charset) {
        super(charset);
    }

    public InputStream canonicalize(InputStream input, OutputStream outputStream) throws TransformException {
        int len = 0;
        byte[] data = null;
        try {
            data = new byte[128];
            len = input.read(data);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "WSS1002.error.canonicalizing.textplain", new Object[]{e.getMessage()});
            throw new TransformException(e);
        }
        CRLFOutputStream crlfOutStream = null;
        ByteArrayOutputStream bout = null;
        if (outputStream == null) {
            bout = new ByteArrayOutputStream();
            crlfOutStream = new CRLFOutputStream((OutputStream)bout);
        } else {
            crlfOutStream = new CRLFOutputStream(outputStream);
        }
        while (len > 0) {
            try {
                crlfOutStream.write(data, 0, len);
                len = input.read(data);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "WSS1002.error.canonicalizing.textplain", new Object[]{e.getMessage()});
                throw new TransformException(e);
            }
        }
        if (outputStream == null) {
            byte[] inputData = bout.toByteArray();
            return new ByteArrayInputStream(inputData);
        }
        return null;
    }

    public byte[] canonicalize(byte[] inputBytes) throws XWSSecurityException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CRLFOutputStream crlfOutStream = new CRLFOutputStream((OutputStream)bout);
        try {
            crlfOutStream.write(inputBytes);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "WSS1002.error.canonicalizing.textplain", new Object[]{e.getMessage()});
            throw new XWSSecurityException(e);
        }
        return bout.toByteArray();
    }
}

