/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.util.Enumeration;

public class PKCS12Import {
    private static File pkcs12File;
    private static char[] pkcs12Password;
    private static String keyStoreAlias;
    private static File keyStoreFile;
    private static char[] keyStorePassword;
    private static char[] keyPassword;
    private static String keyStoreType;
    private static final String PKCS12_FILE_OPTION = "-file";
    private static final String PKCS12_PASSWORD_OPTION = "-pass";
    private static final String KEYSTORE_FILE_OPTION = "-keystore";
    private static final String KEYSTORE_PASSWORD_OPTION = "-storepass";
    private static final String KEY_PASSWORD_OPTION = "-keypass";
    private static final String KEYSTORE_TYPE_OPTION = "-storetype";
    private static final String ALIAS_OPTION = "-alias";

    private static void printUsage() {
        System.out.println("Options:\n        -file <pkcs12-file>           # pkcs12 file to be imported\n      [ -alias <alias> ]              # alias to use\n                                      # defaults to pkcs12 alias      [ -help]\n      [ -keypass <key-password> ]     # user is prompted if omitted and may\n                                      # hit return to use store-password\n      [ -keystore <keystore-file> ]   # defaults to {user-home}/.keystore\n      [ -pass <pkcs12-password> ]     # user is prompted if omitted\n      [ -storepass <store-password> ] # user is prompted if omitted\n      [ -storetype <store-type> ]     # defaults to default keystore type\n");
    }

    private static void adoptOptionInfo(String option, String value) {
        if (PKCS12_FILE_OPTION.equals(option)) {
            pkcs12File = new File(value);
            if (!pkcs12File.exists()) {
                System.out.println("PKCS12 file at location " + value + " does not exist");
                System.exit(0);
            }
        } else if (PKCS12_PASSWORD_OPTION.equals(option)) {
            pkcs12Password = value.toCharArray();
        } else if (KEYSTORE_FILE_OPTION.equals(option)) {
            keyStoreFile = new File(value);
            if (!keyStoreFile.exists()) {
                System.out.println("Keystore file at location " + value + " does not exist");
                System.exit(0);
            }
        } else if (KEYSTORE_PASSWORD_OPTION.equals(option)) {
            keyStorePassword = value.toCharArray();
        } else if (KEYSTORE_TYPE_OPTION.equals(option)) {
            keyStoreType = value;
        } else if (KEY_PASSWORD_OPTION.equals(option)) {
            keyPassword = value.toCharArray();
        } else if (ALIAS_OPTION.equals(option)) {
            keyStoreAlias = value;
        } else {
            System.out.println("Invalid option: " + option);
            PKCS12Import.printUsage();
            System.exit(0);
        }
    }

    private static void understand(String[] args) {
        if (args.length % 2 != 0) {
            PKCS12Import.printUsage();
            System.exit(0);
        }
        for (int i = 0; i < args.length; i += 2) {
            PKCS12Import.adoptOptionInfo(args[i], args[i + 1]);
        }
    }

    private static void pkcs12import() {
        try {
            String defaultLocation;
            if (pkcs12File == null) {
                System.out.println("Location of pkcs12-file to import is mandatory");
                PKCS12Import.printUsage();
                System.exit(0);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            if (pkcs12Password == null) {
                System.out.print("pkcs12-password: ");
                pkcs12Password = reader.readLine().toCharArray();
            }
            KeyStore source = KeyStore.getInstance("PKCS12");
            source.load(new FileInputStream(pkcs12File), pkcs12Password);
            int numAliases = 0;
            String pkcs12Alias = null;
            Enumeration<String> enum1 = source.aliases();
            while (enum1.hasMoreElements()) {
                pkcs12Alias = enum1.nextElement();
                ++numAliases;
            }
            if (numAliases == 0) {
                System.out.println("PKCS12 file is empty!");
                System.exit(0);
            }
            if (numAliases > 1) {
                System.out.println("PKCS12 file has more then one entries!");
                System.exit(0);
            }
            if (!source.isKeyEntry(pkcs12Alias)) {
                System.out.println("PKCS12 file doesn't have a key!");
                System.exit(0);
            }
            if (keyStoreFile == null && !(keyStoreFile = new File(defaultLocation = System.getProperty("user.home") + File.separator + ".keystore")).exists()) {
                System.out.println("Default keystore ({user-home}/.keystore) does not exist.\nPlease specify the keystore location using '-keystore' option");
                System.exit(0);
            }
            if (keyStorePassword == null) {
                System.out.print("keystore-password: ");
                keyStorePassword = reader.readLine().toCharArray();
            }
            if (keyStoreType == null) {
                keyStoreType = KeyStore.getDefaultType();
            }
            KeyStore dest = KeyStore.getInstance(keyStoreType);
            dest.load(new FileInputStream(keyStoreFile), keyStorePassword);
            if (keyPassword == null) {
                System.out.print("key-password: ");
                keyPassword = reader.readLine().toCharArray();
                if (keyPassword.length == 0) {
                    keyPassword = keyStorePassword;
                }
            }
            if (keyStoreAlias == null) {
                keyStoreAlias = pkcs12Alias;
            }
            if (dest.containsAlias(keyStoreAlias)) {
                System.out.println("The alias " + keyStoreAlias + " is already present in keystore!");
                System.exit(0);
            }
            dest.setKeyEntry(keyStoreAlias, source.getKey(pkcs12Alias, pkcs12Password), keyPassword, source.getCertificateChain(pkcs12Alias));
            dest.store(new FileOutputStream(keyStoreFile), keyStorePassword);
            reader.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        PKCS12Import.understand(args);
        PKCS12Import.pkcs12import();
    }
}

