/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class MetricCounters
implements Cloneable,
Serializable {
    private transient Object inLock = new Object();
    private transient Object outLock = new Object();
    public long messagesIn = 0L;
    public long messagesOut = 0L;
    public long messageBytesIn = 0L;
    public long messageBytesOut = 0L;
    public long packetsIn = 0L;
    public long packetsOut = 0L;
    public long packetBytesIn = 0L;
    public long packetBytesOut = 0L;
    public long totalMemory = 0L;
    public long freeMemory = 0L;
    public int threadsActive = 0;
    public int threadsHighWater = 0;
    public int threadsLowWater = 0;
    public long timeStamp = 0L;
    public int nConnections = 1;

    public MetricCounters() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.inLock;
        synchronized (object) {
            this.messageBytesIn = 0L;
            this.messagesIn = 0L;
            this.packetBytesIn = 0L;
            this.packetsIn = 0L;
        }
        object = this.outLock;
        synchronized (object) {
            this.messageBytesOut = 0L;
            this.messagesOut = 0L;
            this.packetBytesOut = 0L;
            this.packetsOut = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateIn(long l, long l2, long l3, long l4) {
        Object object = this.inLock;
        synchronized (object) {
            this.messagesIn += l;
            this.messageBytesIn += l2;
            this.packetsIn += l3;
            this.packetBytesIn += l4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateOut(long l, long l2, long l3, long l4) {
        Object object = this.outLock;
        synchronized (object) {
            this.messagesOut += l;
            this.messageBytesOut += l2;
            this.packetsOut += l3;
            this.packetBytesOut += l4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(MetricCounters metricCounters) {
        Object object = this.inLock;
        synchronized (object) {
            this.messagesIn += metricCounters.messagesIn;
            this.messageBytesIn += metricCounters.messageBytesIn;
            this.packetsIn += metricCounters.packetsIn;
            this.packetBytesIn += metricCounters.packetBytesIn;
        }
        object = this.outLock;
        synchronized (object) {
            this.messagesOut += metricCounters.messagesOut;
            this.messageBytesOut += metricCounters.messageBytesOut;
            this.packetsOut += metricCounters.packetsOut;
            this.packetBytesOut += metricCounters.packetBytesOut;
            this.threadsActive = metricCounters.threadsActive;
            this.threadsHighWater = metricCounters.threadsHighWater;
            this.threadsLowWater = metricCounters.threadsLowWater;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.outLock;
        synchronized (object) {
            Object object2 = this.inLock;
            synchronized (object2) {
                return " In: " + this.messagesIn + " messages(" + this.messageBytesIn + " bytes)\t" + this.packetsIn + " packets(" + this.packetBytesIn + " bytes)\n" + "Out: " + this.messagesOut + " messages(" + this.messageBytesOut + " bytes)\t" + this.packetsOut + " packets(" + this.packetBytesOut + " bytes)\n";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        MetricCounters metricCounters = new MetricCounters();
        Object object = this.inLock;
        synchronized (object) {
            metricCounters.messagesIn = this.messagesIn;
            metricCounters.messageBytesIn = this.messageBytesIn;
            metricCounters.packetsIn = this.packetsIn;
            metricCounters.packetBytesIn = this.packetBytesIn;
        }
        object = this.outLock;
        synchronized (object) {
            metricCounters.messagesOut = this.messagesOut;
            metricCounters.messageBytesOut = this.messageBytesOut;
            metricCounters.packetsOut = this.packetsOut;
            metricCounters.packetBytesOut = this.packetBytesOut;
        }
        return metricCounters;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.inLock = new Object();
        this.outLock = new Object();
    }
}

