/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.Queue;
import com.sun.messaging.Topic;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jms.notification.Event;
import com.sun.messaging.jms.notification.EventListener;
import com.sun.messaging.jms.ra.ActivationSpec;
import com.sun.messaging.jms.ra.MessageListener;
import com.sun.messaging.jms.ra.ResourceAdapter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.XASession;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpointFactory;

public class EndpointConsumer
implements ExceptionListener,
EventListener {
    protected ResourceAdapter ra = null;
    private XAConnectionFactory xacf = null;
    private int cID = 0;
    private int fID = 0;
    private int destinationType = 0;
    private boolean isDurable = false;
    private boolean transactedDelivery = false;
    protected boolean deactivated = false;
    protected XAConnectionImpl xac = null;
    protected XASession xas = null;
    protected MessageListener msgListener = null;
    protected MessageConsumer msgConsumer = null;
    protected MessageConsumer msgConsumer2 = null;
    protected Destination destination = null;
    private javax.resource.spi.ActivationSpec aSpec = null;
    private MessageEndpointFactory mepFactory = null;
    private boolean stopping = false;
    private int reconnectAttempts = 6;
    private int reconnectInterval = 30000;
    private int addressListIterations = 3;
    private boolean logRCFailures = true;
    private int maxLoopDelay = 120000;
    private static final transient String _className = "com.sun.messaging.jms.ra.EndpointConsumer";
    protected static transient Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_EC";
    protected static final transient String _lgrMID_EET = "MQJMSRA_EC1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_EC1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_EC2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_EC3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_EC4001: ";

    public EndpointConsumer(ResourceAdapter resourceAdapter) {
        _loggerIM.entering(_className, "constructor()", resourceAdapter);
        this.ra = resourceAdapter;
        this.xacf = resourceAdapter._getXACF();
        if (!resourceAdapter.getInAppClientContainer()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setProperty("imq.DaemonThreads", "true");
                    return null;
                }
            });
        }
        this.reconnectAttempts = resourceAdapter.getReconnectAttempts();
        this.reconnectInterval = resourceAdapter.getReconnectInterval();
        this.addressListIterations = resourceAdapter.getAddressListIterations();
        try {
            this.xacf.setProperty("imqReconnectEnabled", Boolean.toString(false));
            this.xacf.setProperty("imqReconnectAttempts", Integer.toString(this.reconnectAttempts));
            this.xacf.setProperty("imqReconnectInterval", Integer.toString(this.reconnectInterval));
            this.xacf.setProperty("imqAddressListIterations", Integer.toString(1));
        }
        catch (JMSException jMSException) {
            System.err.println("MQRA:EC:constr:Exception setting cf reconnect params-" + jMSException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException jMSException) {
        _loggerIM.severe("MQJMSRA_EC4001: onException:" + jMSException.getMessage());
        this.logRCFailures = true;
        if (this.msgListener != null) {
            this.msgListener.invalidateOnMessageRunners();
        }
        int n = this.reconnectInterval;
        int n2 = 0;
        while (!this.stopping) {
            try {
                Thread.sleep(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ++n2;
                if (this.logRCFailures) {
                    _loggerIM.severe("MQJMSRA_EC4001: onException:" + this.aSpec.toString());
                }
                _loggerIM.severe("MQJMSRA_EC4001: onException:reconnect attempt loop# " + n2 + " :Delayed " + n + " milliseconds.");
                EndpointConsumer endpointConsumer = this;
                synchronized (endpointConsumer) {
                    if (!this.stopping) {
                        this.createMessageConsumer(this.mepFactory, this.aSpec);
                        _loggerIM.severe("MQJMSRA_EC4001: onException:reconnect success on loop# " + n2 + " for " + this.aSpec.toString());
                    }
                    break;
                }
            }
            catch (Exception exception) {
                if (this.logRCFailures) {
                    _loggerIM.severe("MQJMSRA_EC4001: onException:Unable to re-establish connection for " + this.aSpec.toString() + "\nin " + this.ra.toString());
                } else {
                    this.logRCFailures = false;
                }
                if (n >= this.maxLoopDelay || (n *= 3) <= this.maxLoopDelay) continue;
                n = this.maxLoopDelay;
            }
        }
    }

    public void onEvent(Event event) {
        _loggerIM.entering(_className, "onEvent()", event);
        _loggerIM.info("MQJMSRA_EC1101: onEvent:Connection Event:" + event.toString());
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public int getConsumerID() {
        return this.cID;
    }

    public int getFactoryID() {
        return this.fID;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        MessageEndpointFactory messageEndpointFactory = this.ra._getMessageFactory(this.fID);
        return messageEndpointFactory;
    }

    public XASession getXASession() {
        return this.xas;
    }

    public void setDeactivated() {
        this.deactivated = true;
    }

    public void createMessageConsumer(MessageEndpointFactory messageEndpointFactory, javax.resource.spi.ActivationSpec activationSpec) throws NotSupportedException {
        if (!(activationSpec instanceof ActivationSpec)) {
            throw new NotSupportedException("MQRA:EC:createMsgConsumer:Cannot use non-MQ ActivationSpec -" + activationSpec.getClass());
        }
        this.aSpec = activationSpec;
        this.mepFactory = messageEndpointFactory;
        try {
            if (this.ra != null) {
                this.transactedDelivery = messageEndpointFactory.isDeliveryTransacted(this.ra._getOnMessageMethod());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        ActivationSpec activationSpec2 = (ActivationSpec)activationSpec;
        try {
            this.xacf.setProperty("imqDefaultUsername", activationSpec2.getUserName());
            this.xacf.setProperty("imqDefaultPassword", activationSpec2.getPassword());
        }
        catch (JMSException jMSException) {
            System.err.println("MQRA:EC:createMsgConsumer:Exception setting cf username/password-" + jMSException.getMessage());
        }
        this.setDestinationType(activationSpec2);
        if (this.destinationType == 2) {
            this.setIsDurable(activationSpec2);
        }
        if (this.isDurable) {
            this.createDurableMessageConsumer(activationSpec2, messageEndpointFactory);
        } else {
            this.createNonDurableMessageConsumer(activationSpec2, messageEndpointFactory);
        }
    }

    public void stopMessageConsumer(javax.resource.spi.ActivationSpec activationSpec) throws Exception {
        this.stopMessageConsumer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMessageConsumer() throws Exception {
        this.stopping = true;
        EndpointConsumer endpointConsumer = this;
        synchronized (endpointConsumer) {
            if (this.msgConsumer != null) {
                try {
                    if (this.msgListener != null) {
                        SessionImpl sessionImpl = (SessionImpl)this.xas;
                        sessionImpl._stopFromRA();
                        this.msgListener.waitForAllOnMessageRunners();
                        this.msgListener.releaseOnMessageRunners();
                        this.xas.close();
                    }
                }
                catch (JMSException jMSException) {
                    ResourceException resourceException = new ResourceException("MQRA:EC:Error on closing MessageConsumer");
                    resourceException.initCause((Throwable)jMSException);
                    throw resourceException;
                }
            }
            if (this.xac != null) {
                try {
                    this.xac.close();
                }
                catch (JMSException jMSException) {
                    ResourceException resourceException = new ResourceException("MQRA:EC:Error closing JMS Connection");
                    resourceException.initCause((Throwable)jMSException);
                    throw resourceException;
                }
            }
        }
    }

    private void updateFactoryConsumerTables(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        this.cID = this.ra.addEndpointConsumer(this);
        this.fID = this.ra.addMessageFactory(messageEndpointFactory);
        this.ra.addFactorytoConsumerLink(this.fID, this.cID);
    }

    private void setDestinationType(ActivationSpec activationSpec) throws NotSupportedException {
        String string = activationSpec.getDestination();
        try {
            if (activationSpec._isDestTypeQueueSet()) {
                this.destination = new Queue(string);
                this.destinationType = 1;
            } else if (activationSpec._isDestTypeTopicSet()) {
                this.destination = new Topic(string);
                this.destinationType = 2;
            }
        }
        catch (JMSException jMSException) {
            NotSupportedException notSupportedException = new NotSupportedException("MQRA:EC:Invalid Destination-" + string);
            notSupportedException.initCause((Throwable)jMSException);
            throw notSupportedException;
        }
    }

    private void setIsDurable(ActivationSpec activationSpec) throws NotSupportedException {
        if (activationSpec._isDurableSet()) {
            String string = activationSpec.getSubscriptionName();
            if (string == null || string != null && string.length() <= 0) {
                throw new NotSupportedException("MQRA:EC:Need Valid SubscriptionName-" + string);
            }
            String string2 = activationSpec.getClientId();
            if (string2 == null || string2 != null && string2.length() <= 0) {
                throw new NotSupportedException("MQRA:EC:Need Valid ClientID-" + string2);
            }
            this.isDurable = true;
        }
    }

    private void createDurableMessageConsumer(ActivationSpec activationSpec, MessageEndpointFactory messageEndpointFactory) throws NotSupportedException {
        String string;
        boolean bl = false;
        try {
            this.xacf.setProperty("imqAddressList", activationSpec._AddressList());
            this.xacf.setProperty("imqReconnectEnabled", Boolean.toString(false));
        }
        catch (JMSException jMSException) {
            System.err.println("MQRA:EC:Exception setting cf properties:addressList=" + activationSpec._AddressList());
        }
        for (int i = 1; i <= this.addressListIterations; ++i) {
            try {
                this.xac = (XAConnectionImpl)this.xacf.createXAConnection();
                if (activationSpec._isInClusteredContainerSet()) {
                    this.xac.setRANamespaceUID(activationSpec._getRAUID());
                }
                if ((string = activationSpec.getClientId()) != null && !"".equals(string)) {
                    this.xac.setClientID(string);
                } else if (activationSpec._isInClusteredContainerSet()) {
                    if (activationSpec._getGroupName() != null) {
                        this.xac.setClientID(activationSpec._getGroupName() + "{m:" + activationSpec.getMdbName() + "}");
                    } else {
                        this.xac.setClientID("{m:" + activationSpec.getMdbName() + "}");
                    }
                }
                this.xac.setExceptionListener(this);
                this.xac.setEventListener(this);
                break;
            }
            catch (JMSException jMSException) {
                System.err.println("MQRA:EC:cDMC():createConnection failed on addressListIteration # " + i + " of " + this.addressListIterations + ":Exception=" + jMSException.getMessage());
                if (this.xac != null) {
                    try {
                        this.xac.close();
                    }
                    catch (JMSException jMSException2) {
                        // empty catch block
                    }
                    this.xac = null;
                }
                if (i >= this.addressListIterations || this.stopping) {
                    System.err.println("MQRA:EC:cDMC():createConnction failed:aborting after " + this.addressListIterations + " addressListIterations");
                    if (this.logRCFailures) {
                        jMSException.printStackTrace();
                    }
                    NotSupportedException notSupportedException = new NotSupportedException("MQRA:EC:Error:createDurableConsumer:createConnection failed:aborting due to:" + jMSException.getMessage());
                    notSupportedException.initCause((Throwable)jMSException);
                    throw notSupportedException;
                }
                try {
                    Thread.sleep(this.reconnectInterval);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        try {
            this.xas = (XASession)this.xac.createSession(bl, 2);
            ((SessionImpl)this.xas)._setRAEndpointSession();
            this.msgConsumer = this.xas.createDurableSubscriber((javax.jms.Topic)this.destination, activationSpec.getSubscriptionName(), activationSpec.getMessageSelector(), false);
            this.msgListener = new MessageListener(this, messageEndpointFactory, activationSpec);
            this.msgConsumer.setMessageListener((javax.jms.MessageListener)this.msgListener);
            this.xac.start();
            this.updateFactoryConsumerTables(messageEndpointFactory, activationSpec);
        }
        catch (JMSException jMSException) {
            if (this.xac != null) {
                try {
                    this.xac.close();
                }
                catch (JMSException jMSException3) {
                    // empty catch block
                }
                this.xac = null;
            }
            string = new NotSupportedException("MQRA:EC:Error creating Durable Message Consumer:\n" + jMSException.getMessage());
            string.initCause((Throwable)jMSException);
            throw string;
        }
    }

    private void createNonDurableMessageConsumer(ActivationSpec activationSpec, MessageEndpointFactory messageEndpointFactory) throws NotSupportedException {
        boolean bl = false;
        boolean bl2 = false;
        String string = activationSpec.getClientId();
        String string2 = activationSpec.getMdbName();
        if (activationSpec._isInClusteredContainerSet() && (string == null || "".equals(string)) && (string2 == null || "".equals(string2))) {
            throw new NotSupportedException("MQRA:EC:Error:Clustered Non-Durable Message Consumer requires non-null clientID OR mdbName:clientID=" + string + ":mdbName=" + string2);
        }
        try {
            this.xacf.setProperty("imqAddressList", activationSpec._AddressList());
            this.xacf.setProperty("imqReconnectEnabled", Boolean.toString(false));
        }
        catch (JMSException jMSException) {
            System.err.println("MQRA:EC:Exception setting cf properties:addressList=" + activationSpec._AddressList());
        }
        for (int i = 1; i <= this.addressListIterations; ++i) {
            try {
                this.xac = (XAConnectionImpl)this.xacf.createXAConnection();
                if (activationSpec._isInClusteredContainerSet()) {
                    this.xac.setRANamespaceUID(activationSpec._getRAUID());
                }
                if (string != null && !"".equals(string)) {
                    this.xac.setClientID(string);
                } else if (activationSpec._isInClusteredContainerSet()) {
                    if (activationSpec._getGroupName() != null) {
                        this.xac.setClientID(activationSpec._getGroupName() + "{m:" + activationSpec.getMdbName() + "}");
                    } else {
                        this.xac.setClientID("{m:" + activationSpec.getMdbName() + "}");
                    }
                }
                this.xac.setExceptionListener(this);
                this.xac.setEventListener(this);
                break;
            }
            catch (JMSException jMSException) {
                System.err.println("MQRA:EC:cNDMC():createConnection failed on addressListIteration # " + i + " of " + this.addressListIterations + ":Exception=" + jMSException.getMessage());
                if (this.xac != null) {
                    try {
                        this.xac.close();
                    }
                    catch (JMSException jMSException2) {
                        // empty catch block
                    }
                    this.xac = null;
                }
                if (i >= this.addressListIterations || this.stopping) {
                    System.err.println("MQRA:EC:cNDMC():createConnction failed:aborting after " + this.addressListIterations + " addressListIterations");
                    if (this.logRCFailures) {
                        jMSException.printStackTrace();
                    }
                    NotSupportedException notSupportedException = new NotSupportedException("MQRA:EC:Error:createNonDurableConsumer:createConnection failed:aborting due to:" + jMSException.getMessage());
                    notSupportedException.initCause((Throwable)jMSException);
                    throw notSupportedException;
                }
                try {
                    Thread.sleep(this.reconnectInterval);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        try {
            if (activationSpec._isNoAckDeliverySet() && this.destination instanceof Topic && !this.transactedDelivery) {
                bl2 = true;
            }
            this.xas = bl2 ? (XASession)this.xac.createSession(32768) : (XASession)this.xac.createSession(bl, 2);
            ((SessionImpl)this.xas)._setRAEndpointSession();
            this.msgConsumer = this.xas.createConsumer(this.destination, activationSpec.getMessageSelector());
            if (this.destination instanceof javax.jms.Queue && activationSpec._isInClusteredContainerSet()) {
                try {
                    this.msgConsumer2 = this.xas.createConsumer(this.destination, activationSpec.getMessageSelector());
                    this.msgConsumer2.close();
                    this.msgConsumer2 = null;
                }
                catch (JMSException jMSException) {
                    if (this.xac != null) {
                        try {
                            this.xac.close();
                        }
                        catch (JMSException jMSException3) {
                            // empty catch block
                        }
                        this.xac = null;
                    }
                    NotSupportedException notSupportedException = new NotSupportedException("MQRA:EC:Error clustering multiple consumers on Queue:\n" + jMSException.getMessage());
                    notSupportedException.initCause((Throwable)jMSException);
                    throw notSupportedException;
                }
            }
            this.msgListener = new MessageListener(this, messageEndpointFactory, activationSpec, bl2);
            this.msgConsumer.setMessageListener((javax.jms.MessageListener)this.msgListener);
            this.xac.start();
            this.updateFactoryConsumerTables(messageEndpointFactory, activationSpec);
        }
        catch (JMSException jMSException) {
            if (this.xac != null) {
                try {
                    this.xac.close();
                }
                catch (JMSException jMSException4) {
                    // empty catch block
                }
                this.xac = null;
            }
            NotSupportedException notSupportedException = new NotSupportedException("MQRA:EC:Error creating Non-Durable Message Consumer:\n" + jMSException.getMessage());
            notSupportedException.initCause((Throwable)jMSException);
            throw notSupportedException;
        }
    }
}

