/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common.arguments;

import com.sun.enterprise.tools.upgrade.common.PasswordVerifier;
import com.sun.enterprise.tools.upgrade.common.arguments.CertificateArgumentHandler;
import com.sun.enterprise.tools.upgrade.common.arguments.ParsedArgument;

public class ARG_nsspwdfile
extends CertificateArgumentHandler {
    String nssPwdFile;

    public ARG_nsspwdfile(ParsedArgument pa) {
        super(pa);
        if (this.parameters.isEmpty()) {
            this.helpUsage(this.sm.getString("enterprise.tools.upgrade.cli.argument_missing, --nsspwdfile/-n"));
            System.exit(1);
        }
        this.nssPwdFile = (String)this.parameters.firstElement();
        this.processCertificatePasswords(this.nssPwdFile);
    }

    protected void setCertificatePassword(String password) {
        if (password == null) {
            this._logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_error", (Object)this.nssPwdFile));
            System.exit(1);
        }
        this.commonInfo.setCertDbPassword(password);
        this.commonInfo.setNSSPwdFile(this.nssPwdFile);
        if (!this.interactiveMap.containsKey("source")) {
            return;
        }
        boolean validpwd = PasswordVerifier.verifySourceNSSPassword(this.commonInfo);
        if (!validpwd) {
            this.commonInfo.recover();
            this._logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_nss_password"));
            System.exit(1);
        }
        this.interactiveMap.put("nsspwd-" + this.commonInfo.getCurrentDomain(), password);
    }
}

