/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.gui;

import com.sun.enterprise.tools.upgrade.gui.util.DialogEvent;
import com.sun.enterprise.tools.upgrade.gui.util.DialogListener;
import com.sun.enterprise.tools.upgrade.gui.util.Utils;
import com.sun.enterprise.util.i18n.StringManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class DomainPathSelectionDialog
extends JDialog {
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.gui");
    private DomainPathTableModel domainPathTableModel = null;
    private JTable domainPathTable = null;
    private JScrollPane domainPathTableScrollPane = null;
    private JPanel domainPathsPanel = null;
    private JPanel addRemoveButtonsPanel = null;
    private JButton addDomainPathButton = null;
    private JButton removeDomainPathButton = null;
    private JFileChooser fileChooser = null;
    public static final int OK_ACTION = 2;
    public static final int CANCEL_ACTION = 1;
    public static final int HELP_ACTION = 3;
    public int USER_ACTION = 1;
    private Vector dialogListeners = new Vector();

    public DomainPathSelectionDialog() {
        this.setTitle(this.stringManager.getString("upgrade.gui.domainPanel.dialogTitle"));
        this.initComponents();
        super.setModal(true);
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        JSeparator separatorPanel = new JSeparator();
        this.addComponetWithConstraints(this.getDomainPathsPanel(), this.getContentPane(), 0, 0, 1, 1, 1, new Insets(10, 0, 0, 5), 1.0, 1.0);
        this.addComponetWithConstraints(separatorPanel, this.getContentPane(), 0, 1, 1, 1, 2, new Insets(5, 5, 0, 5), 1.0, 0.0);
        this.addComponetWithConstraints(this.getButtonsPanel(), this.getContentPane(), 0, 2, 1, 1, 2, new Insets(5, 0, 0, 0), 1.0, 0.0);
        this.getDomainPathTableScrollPane().setViewportView(this.getDomainPathTable());
        this.getDomainPathTable().setModel(this.getDomainPathTableModel());
        this.getDomainPathTable().createDefaultColumnsFromModel();
        this.setSize(500, 350);
    }

    private JPanel getDomainPathsPanel() {
        if (this.domainPathsPanel == null) {
            this.domainPathsPanel = new JPanel();
            this.domainPathsPanel.setName("domainPathsPanel");
            this.domainPathsPanel.setLayout(new GridBagLayout());
            JLabel tableTitleLabel = new JLabel();
            tableTitleLabel.setText(this.stringManager.getString("upgrade.gui.domainPanel.tableTitleName"));
            this.addComponetWithConstraints(tableTitleLabel, this.domainPathsPanel, 0, 0, 3, 1, 0, new Insets(10, 10, 5, 0), 0.0, 0.0);
            this.addComponetWithConstraints(this.getDomainPathTableScrollPane(), this.domainPathsPanel, 0, 1, 2, 1, 1, new Insets(5, 10, 5, 0), 1.0, 1.0);
            this.addComponetWithConstraints(this.getaddRemoveButtonsPanel(), this.domainPathsPanel, 2, 1, 1, 1, 3, new Insets(5, 0, 5, 0), 0.0, 1.0);
        }
        return this.domainPathsPanel;
    }

    private JTable getDomainPathTable() {
        if (this.domainPathTable == null) {
            this.domainPathTable = new JTable();
            this.domainPathTable.setName("domainPathTable");
            this.getDomainPathTableScrollPane().setColumnHeaderView(this.domainPathTable.getTableHeader());
            this.getDomainPathTableScrollPane().getViewport().setScrollMode(2);
            this.domainPathTable.setAutoResizeMode(2);
            this.domainPathTable.setAutoCreateColumnsFromModel(true);
            this.domainPathTable.setAutoResizeMode(2);
            this.domainPathTable.setAutoCreateColumnsFromModel(true);
            ListSelectionModel rowSM = this.domainPathTable.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    DomainPathSelectionDialog.this.enableDisableRemoveButton(DomainPathSelectionDialog.this.domainPathTable, DomainPathSelectionDialog.this.getremoveDomainPathButton());
                }
            });
            final DefaultCellEditor editor = (DefaultCellEditor)this.domainPathTable.getDefaultEditor(String.class);
            editor.getComponent().addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent ke) {
                    try {
                        DomainPathSelectionDialog.this.getDomainPathTableModel().setValueAt(((JTextField)editor.getComponent()).getText().trim(), DomainPathSelectionDialog.this.domainPathTable.getEditingRow(), 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.domainPathTable;
    }

    private JScrollPane getDomainPathTableScrollPane() {
        if (this.domainPathTableScrollPane == null) {
            this.domainPathTableScrollPane = new JScrollPane();
            this.domainPathTableScrollPane.setName("getDomainPathTable");
            this.domainPathTableScrollPane.setVerticalScrollBarPolicy(22);
            this.domainPathTableScrollPane.setHorizontalScrollBarPolicy(32);
            this.domainPathTableScrollPane.setMaximumSize(new Dimension(21, 20));
            this.domainPathTableScrollPane.setPreferredSize(new Dimension(21, 20));
            this.domainPathTableScrollPane.setMinimumSize(new Dimension(21, 20));
            this.domainPathTableScrollPane.setViewportView(this.getDomainPathTable());
        }
        return this.domainPathTableScrollPane;
    }

    private JPanel getaddRemoveButtonsPanel() {
        if (this.addRemoveButtonsPanel == null) {
            this.addRemoveButtonsPanel = new JPanel();
            this.addRemoveButtonsPanel.setName("addRemoveButtonsPanel");
            this.addRemoveButtonsPanel.setLayout(new GridBagLayout());
            this.addComponetWithConstraints(this.getaddDomainPathButton(), this.addRemoveButtonsPanel, 0, 0, 1, 1, 0, new Insets(10, 5, 5, 5), 0.0, 0.0);
            this.addComponetWithConstraints(this.getremoveDomainPathButton(), this.addRemoveButtonsPanel, 0, 1, 1, 1, 0, new Insets(5, 5, 5, 5), 0.0, 0.0);
        }
        return this.addRemoveButtonsPanel;
    }

    private JButton getaddDomainPathButton() {
        if (this.addDomainPathButton == null) {
            this.addDomainPathButton = new JButton();
            this.addDomainPathButton.setName("addDomainPathButton");
            this.addDomainPathButton.setText(this.stringManager.getString("upgrade.gui.domainPanel.addButtonText"));
            this.addDomainPathButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DomainPathSelectionDialog.this.addDomainPathAction();
                }
            });
        }
        return this.addDomainPathButton;
    }

    private JButton getremoveDomainPathButton() {
        if (this.removeDomainPathButton == null) {
            this.removeDomainPathButton = new JButton();
            this.removeDomainPathButton.setName("removeDomainPathButton");
            this.removeDomainPathButton.setText(this.stringManager.getString("upgrade.gui.domainPanel.deleteButtonText"));
            this.removeDomainPathButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DomainPathSelectionDialog.this.removeDomainPathAction();
                }
            });
        }
        return this.removeDomainPathButton;
    }

    private JPanel getButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        JButton helpButton = new JButton();
        buttonsPanel.setLayout(new GridBagLayout());
        okButton.setText(this.stringManager.getString("upgrade.gui.adddomainpanel.okButtonText"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DomainPathSelectionDialog.this.okButtonActionPerformed();
            }
        });
        this.addComponetWithConstraints(okButton, buttonsPanel, 1, 0, 1, 1, 0, new Insets(5, 5, 10, 10), 0.0, 0.0);
        cancelButton.setText(this.stringManager.getString("upgrade.gui.adddomainpanel.cancelButtonText"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DomainPathSelectionDialog.this.cancelButtonActionPerformed();
            }
        });
        this.addComponetWithConstraints(cancelButton, buttonsPanel, 2, 0, 1, 1, 0, new Insets(5, 5, 10, 10), 0.0, 0.0);
        helpButton.setText(this.stringManager.getString("upgrade.gui.adddomainpanel.helpButtonText"));
        helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DomainPathSelectionDialog.this.helpButtonActionPerformed();
            }
        });
        this.addComponetWithConstraints(helpButton, buttonsPanel, 3, 0, 1, 1, 0, new Insets(5, 5, 10, 10), 0.0, 0.0);
        this.addComponetWithConstraints(new JPanel(), buttonsPanel, 0, 0, 1, 1, 2, new Insets(5, 5, 10, 10), 1.0, 0.0);
        if (Utils.getHelpBroker() != null) {
            Utils.getHelpBroker().enableHelpOnButton((Component)helpButton, "ADD_DOMAIN_DIALOG", null);
        }
        return buttonsPanel;
    }

    private void addComponetWithConstraints(JComponent compo, Container parent, int gx, int gy, int gw, int gh, int fill, Insets in, double wx, double wy) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gx;
        gridBagConstraints.gridy = gy;
        gridBagConstraints.gridwidth = gw;
        gridBagConstraints.gridheight = gh;
        gridBagConstraints.fill = fill;
        gridBagConstraints.insets = in;
        gridBagConstraints.weightx = wx;
        gridBagConstraints.weighty = wy;
        parent.add((Component)compo, gridBagConstraints);
    }

    private void helpButtonActionPerformed() {
        this.USER_ACTION = 3;
    }

    private void cancelButtonActionPerformed() {
        this.USER_ACTION = 1;
        this.dispose();
    }

    private void okButtonActionPerformed() {
        this.USER_ACTION = 2;
        this.dispose();
    }

    public DomainPathTableModel getDomainPathTableModel() {
        if (this.domainPathTableModel == null) {
            this.domainPathTableModel = new DomainPathTableModel(this);
        }
        return this.domainPathTableModel;
    }

    public void addDomainPathAction() {
        int returnedValue = this.getfileChooser().showOpenDialog(this);
        if (returnedValue == 0) {
            this.getDomainPathTableModel().addDomainPath(String.valueOf(this.getfileChooser().getSelectedFile()));
        }
    }

    private JFileChooser getfileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setName("fileChooser");
            this.fileChooser.setBounds(668, 49, 500, 300);
            this.fileChooser.setDialogTitle(this.stringManager.getString("upgrade.gui.certpanel.chooseFile"));
            this.fileChooser.setFileSelectionMode(1);
        }
        return this.fileChooser;
    }

    public void removeDomainPathAction() {
        int i;
        int[] rows = this.getDomainPathTable().getSelectedRows();
        String[] rowPropNames = new String[rows.length];
        int option = JOptionPane.showConfirmDialog(this, this.stringManager.getString("upgrade.gui.domainPanel.removeConfirmMsg"), this.stringManager.getString("upgrade.gui.domainPanel.removeConfirmTitle"), 0, 3);
        if (option == 1) {
            return;
        }
        for (i = 0; i < rows.length; ++i) {
            rowPropNames[i] = this.getDomainPathTableModel().getDomainPath(rows[i]);
        }
        for (i = 0; i < rows.length; ++i) {
            this.getDomainPathTableModel().removeDomainPath(rowPropNames[i]);
        }
        this.getDomainPathTable().clearSelection();
        this.enableDisableRemoveButton(this.getDomainPathTable(), this.getremoveDomainPathButton());
    }

    public void enableDisableRemoveButton(JTable table, JButton removeButton) {
        if (table.getSelectionModel().isSelectionEmpty()) {
            removeButton.setEnabled(false);
        } else if (table.getSelectedRowCount() <= 1) {
            removeButton.setEnabled(true);
        }
    }

    public void addDialogListener(DialogListener listener) {
        this.dialogListeners.addElement(listener);
    }

    public void removeDialogListener(DialogListener listener) {
        this.dialogListeners.removeElement(listener);
    }

    private void processDialogEvent() {
        DialogEvent de = new DialogEvent(this, 7);
        for (int i = 0; i < this.dialogListeners.size(); ++i) {
            ((DialogListener)this.dialogListeners.elementAt(i)).dialogProcessed(de);
        }
    }

    class DomainPathTableModel
    extends AbstractTableModel {
        private Vector domainPaths = new Vector(0);
        private String[] columnNames = null;
        private DomainPathSelectionDialog domainPathSelectionDialog;
        private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.gui");

        public DomainPathTableModel(DomainPathSelectionDialog cdp) {
            this.domainPathSelectionDialog = cdp;
            this.columnNames = new String[]{this.stringManager.getString("upgrade.gui.domainPanel.tableColumnName")};
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getRowCount() {
            return this.domainPaths.size();
        }

        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        public void setValueAt(Object value, int row, int col) {
            if (value instanceof String && row < this.domainPaths.size()) {
                this.domainPaths.setElementAt(value, row);
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object getValueAt(int row, int col) {
            String rowEle = (String)this.domainPaths.elementAt(row);
            String ret = "";
            switch (col) {
                case 0: {
                    ret = rowEle;
                }
            }
            return ret;
        }

        public Vector getDomainPaths() {
            return this.domainPaths;
        }

        public void setDomainPaths(Vector v) {
            this.domainPaths = v;
        }

        public void addDomainPath(String ele) {
            if (ele != null && this.getDomainPath(ele) == null) {
                this.domainPaths.addElement(ele);
            }
            this.fireTableDataChanged();
            this.domainPathSelectionDialog.processDialogEvent();
        }

        public void removeDomainPath(String ele) {
            if (ele != null) {
                this.domainPaths.removeElement(ele);
            }
            this.fireTableDataChanged();
            this.domainPathSelectionDialog.processDialogEvent();
        }

        public String getDomainPath(int rowNo) {
            if (rowNo < this.domainPaths.size()) {
                return (String)this.domainPaths.elementAt(rowNo);
            }
            return null;
        }

        public String getDomainPath(String propName) {
            String ele1 = null;
            boolean found = false;
            if (propName != null) {
                for (int i = 0; i < this.domainPaths.size(); ++i) {
                    ele1 = (String)this.domainPaths.elementAt(i);
                    if (!propName.equals(ele1)) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                return ele1;
            }
            return null;
        }
    }
}

