/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.transform.elements.GenericResource;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JMSResource
extends GenericResource {
    public void transform(Element element, Element parentSource, Element parentResult) {
        Element resultResource = null;
        String resourceType = element.getAttribute("res-type");
        resultResource = resourceType.equals("javax.jms.Topic") || resourceType.equals("javax.jms.Queue") ? this.transformToAdminObjectResource(element, parentSource, parentResult) : this.transformToConnectorResource(element, parentSource, parentResult);
        super.updateResourceRef(resultResource, parentResult);
        super.transform(element, parentSource, resultResource);
    }

    private Element transformToAdminObjectResource(Element element, Element parentSource, Element parentResult) {
        NodeList resultResources = parentResult.getElementsByTagName("admin-object-resource");
        Element resultResource = null;
        for (int lh = 0; lh < resultResources.getLength(); ++lh) {
            if (!element.getAttribute("jndi-name").equals(((Element)resultResources.item(lh)).getAttribute("jndi-name"))) continue;
            resultResource = (Element)resultResources.item(lh);
            resultResource.setAttribute("res-type", element.getAttribute("res-type"));
            resultResource.setAttribute("enabled", element.getAttribute("enabled"));
            resultResource.setAttribute("res-adapter", "jmsra");
            break;
        }
        if (resultResource == null) {
            resultResource = parentResult.getOwnerDocument().createElement("admin-object-resource");
            resultResource.setAttribute("jndi-name", element.getAttribute("jndi-name"));
            resultResource.setAttribute("res-type", element.getAttribute("res-type"));
            resultResource.setAttribute("enabled", element.getAttribute("enabled"));
            resultResource.setAttribute("res-adapter", "jmsra");
            this.appendElementToParent(parentResult, resultResource);
        }
        return resultResource;
    }

    private Element transformToConnectorResource(Element element, Element parentSource, Element parentResult) {
        NodeList resultResources = parentResult.getElementsByTagName("connector-resource");
        Element resultResource = null;
        for (int lh = 0; lh < resultResources.getLength(); ++lh) {
            if (!element.getAttribute("jndi-name").equals(((Element)resultResources.item(lh)).getAttribute("jndi-name"))) continue;
            resultResource = (Element)resultResources.item(lh);
            resultResource.setAttribute("enabled", element.getAttribute("enabled"));
            break;
        }
        if (resultResource == null) {
            resultResource = parentResult.getOwnerDocument().createElement("connector-resource");
            resultResource.setAttribute("jndi-name", element.getAttribute("jndi-name"));
            resultResource.setAttribute("enabled", element.getAttribute("enabled"));
            resultResource.setAttribute("pool-name", element.getAttribute("jndi-name"));
            this.appendElementToParent(parentResult, resultResource);
            this.transformConnectorPool(element, parentSource, parentResult);
        }
        return resultResource;
    }

    private void transformConnectorPool(Element element, Element parentSource, Element parentResult) {
        NodeList connectorPools = parentResult.getElementsByTagName("connector-connection-pool");
        Element connectorPool = null;
        for (int lh = 0; lh < connectorPools.getLength(); ++lh) {
            if (!element.getAttribute("jndi-name").equals(((Element)connectorPools.item(lh)).getAttribute("name"))) continue;
            connectorPool = (Element)connectorPools.item(lh);
            connectorPool.setAttribute("connection-definition-name", element.getAttribute("res-type"));
            connectorPool.setAttribute("resource-adapter-name", "jmsra");
            break;
        }
        if (connectorPool == null) {
            connectorPool = parentResult.getOwnerDocument().createElement("connector-connection-pool");
            connectorPool.setAttribute("name", element.getAttribute("jndi-name"));
            connectorPool.setAttribute("connection-definition-name", element.getAttribute("res-type"));
            connectorPool.setAttribute("resource-adapter-name", "jmsra");
            this.appendElementToParent(parentResult, connectorPool);
        }
    }
}

