/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitUtils {
    private static final String RENDER_KIT_IMPL_REQ = "com.sun.faces.renderKitImplForRequest";
    private static final String XHTML_ATTR_PREFIX = "xml:";
    private static final String[] EMPTY_EXCLUDES = new String[0];
    private static final String[] BOOLEAN_ATTRIBUTES = new String[]{"disabled", "ismap", "readonly"};
    private static final String[] PASSTHROUGH_ATTRIBUTES = new String[]{"accept", "accesskey", "alt", "bgcolor", "border", "cellpadding", "cellspacing", "charset", "cols", "coords", "dir", "enctype", "frame", "height", "hreflang", "lang", "longdesc", "maxlength", "onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onselect", "onsubmit", "onunload", "rel", "rows", "rev", "rules", "shape", "size", "style", "summary", "tabindex", "target", "title", "usemap", "width"};
    private static final String[] XHTML_PREFIX_ATTRIBUTES;
    private static final int MAX_CONTENT_TYPES = 50;
    private static final int MAX_CONTENT_TYPE_PARTS = 4;
    private static final String CONTENT_TYPE_DELIMITER = ",";
    private static final String CONTENT_TYPE_SUBTYPE_DELIMITER = "/";
    private static final String SUN_JSF_JS = "com.sun.faces.sunJsfJs";
    protected static final Logger LOGGER;

    private RenderKitUtils() {
    }

    public static RenderKit getCurrentRenderKit(FacesContext context) {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        return renderKitFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
    }

    public static ResponseStateManager getResponseStateManager(FacesContext context, String renderKitId) throws FacesException {
        assert (null != renderKitId);
        assert (null != context);
        RenderKit renderKit = context.getRenderKit();
        if (renderKit == null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            RenderKitFactory factory = (RenderKitFactory)requestMap.get(RENDER_KIT_IMPL_REQ);
            if (factory != null) {
                renderKit = factory.getRenderKit(context, renderKitId);
            } else {
                factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
                if (factory == null) {
                    throw new IllegalStateException();
                }
                requestMap.put(RENDER_KIT_IMPL_REQ, factory);
                renderKit = factory.getRenderKit(context, renderKitId);
            }
        }
        return renderKit.getResponseStateManager();
    }

    public static Iterator<SelectItem> getSelectItems(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        for (UIComponent kid : component.getChildren()) {
            if (kid instanceof UISelectItem) {
                UISelectItem item = (UISelectItem)kid;
                Object value = item.getValue();
                if (value == null) {
                    list.add(new SelectItem(item.getItemValue(), item.getItemLabel(), item.getItemDescription(), item.isItemDisabled(), item.isItemEscaped()));
                    continue;
                }
                if (value instanceof SelectItem) {
                    list.add((SelectItem)value);
                    continue;
                }
                throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.OPTION_NOT_SELECT_ITEM", component.getId(), value.getClass().getName()));
            }
            if (!(kid instanceof UISelectItems)) continue;
            Object value = ((UISelectItems)kid).getValue();
            if (value instanceof SelectItem) {
                list.add((SelectItem)value);
                continue;
            }
            if (value instanceof SelectItem[]) {
                SelectItem[] items;
                for (SelectItem item : items = (SelectItem[])value) {
                    list.add(item);
                }
                continue;
            }
            if (value instanceof Collection) {
                for (Object element : (Collection)value) {
                    if (SelectItem.class.isInstance(element)) {
                        list.add((SelectItem)element);
                        continue;
                    }
                    throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.OPTION_NOT_SELECT_ITEM", component.getId(), value.getClass().getName()));
                }
                continue;
            }
            if (value instanceof Map) {
                Map optionMap = (Map)value;
                Iterator i$ = optionMap.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (key == null || val == null) continue;
                    list.add(new SelectItem(val, key.toString()));
                }
                continue;
            }
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.CHILD_NOT_OF_EXPECTED_TYPE", "UISelectItem/UISelectItems", component.getFamily(), component.getId(), value != null ? value.getClass().getName() : "null"));
        }
        return list.iterator();
    }

    public static boolean hasPassThruAttributes(UIComponent component) {
        Map attrMap = component.getAttributes();
        boolean attrFound = false;
        for (String attr : PASSTHROUGH_ATTRIBUTES) {
            Object value = attrMap.get(attr);
            boolean bl = attrFound = value != null;
            if (attrFound) break;
        }
        return attrFound;
    }

    public static void renderPassThruAttributes(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        RenderKitUtils.renderPassThruAttributes(context, writer, component, EMPTY_EXCLUDES);
    }

    public static void renderPassThruAttributes(FacesContext context, ResponseWriter writer, UIComponent component, String[] excludes) throws IOException {
        assert (null != writer);
        assert (null != component);
        if (excludes == null) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "excludes"));
        }
        Map attrMap = component.getAttributes();
        if (excludes.length > 0) {
            Arrays.sort(excludes);
        }
        boolean isXhtml = writer.getContentType().equals("application/xhtml+xml");
        for (String attrName : PASSTHROUGH_ATTRIBUTES) {
            Object value;
            if (excludes.length > 0 && Arrays.binarySearch(excludes, attrName) > -1 || (value = attrMap.get(attrName)) == null || !RenderKitUtils.shouldRenderAttribute(value)) continue;
            if (context == null) {
                context = FacesContext.getCurrentInstance();
            }
            writer.writeAttribute(RenderKitUtils.prefixAttribute(attrName, isXhtml), value, attrName);
        }
    }

    public static String prefixAttribute(String attrName, ResponseWriter writer) {
        return RenderKitUtils.prefixAttribute(attrName, "application/xhtml+xml".equals(writer.getContentType()));
    }

    public static String prefixAttribute(String attrName, boolean isXhtml) {
        if (isXhtml) {
            if (Arrays.binarySearch(XHTML_PREFIX_ATTRIBUTES, attrName) > -1) {
                return XHTML_ATTR_PREFIX + attrName;
            }
            return attrName;
        }
        return attrName;
    }

    public static void renderXHTMLStyleBooleanAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component, EMPTY_EXCLUDES);
    }

    public static void renderXHTMLStyleBooleanAttributes(ResponseWriter writer, UIComponent component, String[] excludes) throws IOException {
        assert (writer != null);
        assert (component != null);
        if (excludes == null) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "excludes"));
        }
        if (excludes.length > 0) {
            Arrays.sort(excludes);
        }
        Map attrMap = component.getAttributes();
        for (String attrName : BOOLEAN_ATTRIBUTES) {
            Boolean bool;
            Object val = attrMap.get(attrName);
            if (val == null || excludes.length > 0 && Arrays.binarySearch(excludes, attrName) > -1 || !(bool = !(val instanceof Boolean) ? Boolean.valueOf(val.toString()) : (Boolean)val).booleanValue()) continue;
            writer.writeAttribute(attrName, (Object)true, attrName);
        }
    }

    public static String determineContentType(String accept, String serverSupportedTypes, String preferredType) {
        String[][] preferredContentType;
        String[][] serverContentTypes;
        String contentType = null;
        if (null == accept || null == serverSupportedTypes) {
            return contentType;
        }
        String[][] clientContentTypes = RenderKitUtils.buildTypeArrayFromString(accept);
        String[][] matchedInfo = RenderKitUtils.findMatch(clientContentTypes, serverContentTypes = RenderKitUtils.buildTypeArrayFromString(serverSupportedTypes), preferredContentType = RenderKitUtils.buildTypeArrayFromString(preferredType));
        if (matchedInfo[0][1] != null && !matchedInfo[0][2].equals("*")) {
            contentType = matchedInfo[0][1] + CONTENT_TYPE_SUBTYPE_DELIMITER + matchedInfo[0][2];
        }
        return contentType;
    }

    public static boolean isXml(String contentType) {
        return "application/xhtml+xml".equals(contentType) || "application/xml".equals(contentType) || "text/xml".equals(contentType);
    }

    private static boolean shouldRenderAttribute(Object attributeVal) {
        if (attributeVal instanceof Boolean && Boolean.FALSE.equals(attributeVal)) {
            return false;
        }
        if (attributeVal instanceof Integer && (Integer)attributeVal == Integer.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Double && (Double)attributeVal == Double.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Character && ((Character)attributeVal).charValue() == '\u0000') {
            return false;
        }
        if (attributeVal instanceof Float && ((Float)attributeVal).floatValue() == Float.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Short && (Short)attributeVal == Short.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Byte && (Byte)attributeVal == -128) {
            return false;
        }
        return !(attributeVal instanceof Long) || (Long)attributeVal != Long.MIN_VALUE;
    }

    private static String[][] buildTypeArrayFromString(String accept) {
        String[][] arrayAccept = new String[50][4];
        if (accept == null || accept.length() == 0) {
            return arrayAccept;
        }
        String token = null;
        StringBuilder typeSubType = null;
        String type = null;
        String subtype = null;
        String level = null;
        String quality = null;
        String[] types = Util.split(accept, CONTENT_TYPE_DELIMITER);
        int index = -1;
        for (int i = 0; i < types.length; ++i) {
            token = types[i].trim();
            ++index;
            if (token.contains(";")) {
                String[] typeParts = Util.split(token, ";");
                typeSubType = new StringBuilder(typeParts[0].trim());
                for (int j = 1; j < typeParts.length; ++j) {
                    quality = "not set";
                    token = typeParts[j].trim();
                    if (token.contains("level")) {
                        typeSubType.append(';').append(token);
                        String[] levelParts = Util.split(token, "=");
                        level = levelParts[0].trim();
                        if (!level.equalsIgnoreCase("level")) continue;
                        level = levelParts[1].trim();
                        continue;
                    }
                    quality = token;
                    String[] qualityParts = Util.split(quality, "=");
                    if ((quality = qualityParts[0].trim()).equalsIgnoreCase("q")) {
                        quality = qualityParts[1].trim();
                        break;
                    }
                    quality = "not set";
                }
            } else {
                typeSubType = new StringBuilder(token);
                quality = "not set";
            }
            if (typeSubType.indexOf(CONTENT_TYPE_SUBTYPE_DELIMITER) >= 0) {
                String[] typeSubTypeParts = Util.split(typeSubType.toString(), CONTENT_TYPE_SUBTYPE_DELIMITER);
                type = typeSubTypeParts[0].trim();
                subtype = typeSubTypeParts[1].trim();
            } else {
                type = typeSubType.toString();
                subtype = "";
            }
            if (quality.equals("not set")) {
                quality = type.equals("*") && subtype.equals("*") ? "0.01" : (!type.equals("*") && subtype.equals("*") ? "0.02" : (type.equals("*") && subtype.length() == 0 ? "0.01" : "1"));
            }
            arrayAccept[index][0] = quality;
            arrayAccept[index][1] = type;
            arrayAccept[index][2] = subtype;
            arrayAccept[index][3] = level;
        }
        return arrayAccept;
    }

    private static String[][] findMatch(String[][] clientContentTypes, String[][] serverSupportedContentTypes, String[][] preferredContentType) {
        int cidx = 0;
        int sidx = 0;
        String browserType = "";
        String serverType = "";
        String[][] results = new String[50][4];
        int resultidx = -1;
        double highestQFactor = 0.0;
        int idx = 0;
        for (sidx = 0; sidx < 50; ++sidx) {
            serverType = serverSupportedContentTypes[sidx][1];
            if (serverType == null) continue;
            for (cidx = 0; cidx < 50; ++cidx) {
                browserType = clientContentTypes[cidx][1];
                if (browserType == null || !browserType.equalsIgnoreCase(serverType) && !browserType.equals("*") || !clientContentTypes[cidx][2].equalsIgnoreCase(serverSupportedContentTypes[sidx][2]) && !clientContentTypes[cidx][2].equals("*")) continue;
                double cLevel = 0.0;
                double sLevel = 0.0;
                if (clientContentTypes[cidx][3] != null) {
                    cLevel = Double.parseDouble(clientContentTypes[cidx][3]) * 0.1;
                }
                if (serverSupportedContentTypes[sidx][3] != null) {
                    sLevel = Double.parseDouble(serverSupportedContentTypes[sidx][3]) * 0.1;
                }
                double cQfactor = Double.parseDouble(clientContentTypes[cidx][0]) + cLevel;
                double sQfactor = Double.parseDouble(serverSupportedContentTypes[sidx][0]) + sLevel;
                double resultQuality = cQfactor * sQfactor;
                results[++resultidx][0] = String.valueOf(resultQuality);
                if (clientContentTypes[cidx][2].equals("*")) {
                    results[resultidx][1] = clientContentTypes[cidx][1];
                    results[resultidx][2] = clientContentTypes[cidx][2];
                } else {
                    results[resultidx][1] = serverSupportedContentTypes[sidx][1];
                    results[resultidx][2] = serverSupportedContentTypes[sidx][2];
                    results[resultidx][3] = serverSupportedContentTypes[sidx][3];
                }
                if (!(resultQuality > highestQFactor)) continue;
                idx = resultidx;
                highestQFactor = resultQuality;
            }
        }
        String[][] match = new String[1][3];
        if (preferredContentType[0][0] != null) {
            for (int i = 0; i <= resultidx; ++i) {
                if (Double.parseDouble(results[i][0]) != highestQFactor || !results[i][1].equals(preferredContentType[0][1]) || !results[i][2].equals(preferredContentType[0][2])) continue;
                match[0][0] = results[i][0];
                match[0][1] = results[i][1];
                match[0][2] = results[i][2];
                return match;
            }
        }
        match[0][0] = results[idx][0];
        match[0][1] = results[idx][1];
        match[0][2] = results[idx][2];
        return match;
    }

    public static String createValidECMAIdentifier(String origIdentifier) {
        return origIdentifier.replace("-", "$_");
    }

    public static void renderFormInitScript(ResponseWriter writer, FacesContext context) throws IOException {
        WebConfiguration webConfig = WebConfiguration.getInstance(context.getExternalContext());
        if (webConfig.getBooleanContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.ExternalizeJavaScript)) {
            String mapping = Util.getFacesMapping(context);
            String uri = null;
            uri = mapping != null && Util.isPrefixMapped(mapping) ? mapping + '/' + "com_sun_faces_sunjsf.js" : "/com_sun_faces_sunjsf.js" + mapping;
            writer.write(10);
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("src", (Object)(context.getExternalContext().getRequestContextPath() + uri), null);
            writer.endElement("script");
            writer.write("\n");
        } else {
            writer.write(10);
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("language", (Object)"Javascript", null);
            RenderKitUtils.writeSunJS(context, (Writer)writer);
            writer.endElement("script");
            writer.write("\n");
        }
    }

    public static String getCommandLinkOnClickScript(String formClientId, String commandClientId, String target, HtmlBasicRenderer.Param[] params) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("if(typeof jsfcljs == 'function'){jsfcljs(document.forms['");
        sb.append(formClientId);
        sb.append("'],'");
        sb.append(commandClientId).append(',').append(commandClientId);
        for (HtmlBasicRenderer.Param param : params) {
            sb.append(',');
            sb.append(param.name);
            sb.append(',');
            sb.append(param.value);
        }
        sb.append("','");
        sb.append(target);
        sb.append("');}return false");
        return sb.toString();
    }

    public static char[] compressJS(String JSString) {
        BufferedReader reader = new BufferedReader(new StringReader(JSString));
        StringWriter writer = new StringWriter(1024);
        try {
            String line = reader.readLine();
            while (line != null) {
                line = line.trim();
                writer.write(line);
                line = reader.readLine();
            }
            return writer.toString().toCharArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void writeSunJS(FacesContext context, Writer writer) throws IOException {
        writer.write((char[])context.getExternalContext().getApplicationMap().get(SUN_JSF_JS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadSunJsfJs(ExternalContext extContext) {
        Map appMap = extContext.getApplicationMap();
        BufferedReader reader = null;
        try {
            URL url = Util.getCurrentLoader(appMap).getResource("com/sun/faces/sunjsf.js");
            if (url == null) {
                LOGGER.severe("jsf.renderkit.util.cannot_load_js");
                return;
            }
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            InputStream input = conn.getInputStream();
            reader = new BufferedReader(new InputStreamReader(input));
            StringBuilder builder = new StringBuilder(128);
            String line = reader.readLine();
            while (line != null) {
                String temp = line.trim();
                if (!(temp.length() == 0 || temp.startsWith("/*") || temp.startsWith("*") || temp.startsWith("*/") || temp.startsWith("//"))) {
                    builder.append(line).append('\n');
                }
                line = reader.readLine();
            }
            builder.deleteCharAt(builder.length() - 1);
            char[] sunJsfJs = WebConfiguration.getInstance(extContext).getBooleanContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.CompressJavaScript) ? RenderKitUtils.compressJS(builder.toString()) : builder.toString().toCharArray();
            appMap.put(SUN_JSF_JS, sunJsfJs);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "jsf.renderkit.util.cannot_load_js", ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    static {
        Arrays.sort(PASSTHROUGH_ATTRIBUTES);
        XHTML_PREFIX_ATTRIBUTES = new String[]{"lang"};
        LOGGER = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.renderkit");
    }
}

