/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class ButtonRenderer
extends HtmlBasicRenderer {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin decoding component " + component.getId());
        }
        if (Util.componentIsDisabledOrReadonly(component)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No decoding necessary since the component " + component.getId() + " is disabled");
            }
            return;
        }
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestParameterMap.get(clientId);
        if (value == null && requestParameterMap.get(clientId + ".x") == null && requestParameterMap.get(clientId + ".y") == null) {
            return;
        }
        String type = (String)component.getAttributes().get("type");
        if ("reset".equals(type)) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(component);
        component.queueEvent((FacesEvent)actionEvent);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("This command resulted in form submission  ActionEvent queued " + actionEvent);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End decoding component " + component.getId());
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding component " + component.getId());
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since rendered attribute is set to false ");
            }
            return;
        }
        String type = (String)component.getAttributes().get("type");
        if (type == null) {
            type = "submit";
            component.getAttributes().put("type", type);
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String label = "";
        Object value = ((UICommand)component).getValue();
        if (value != null) {
            label = value.toString();
        }
        String imageSrc = (String)component.getAttributes().get("image");
        writer.startElement("input", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        String clientId = component.getClientId(context);
        if (imageSrc != null) {
            writer.writeAttribute("type", (Object)"image", "type");
            writer.writeURIAttribute("src", (Object)this.src(context, imageSrc), "image");
            writer.writeAttribute("name", (Object)clientId, "clientId");
        } else {
            writer.writeAttribute("type", (Object)type.toLowerCase(), "type");
            writer.writeAttribute("name", (Object)clientId, "clientId");
            writer.writeAttribute("value", (Object)label, "value");
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.endElement("input");
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component.getId());
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
    }

    private String src(FacesContext context, String value) {
        if (value == null) {
            return "";
        }
        value = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(value);
    }
}

