/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.spi;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.util.Util;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionProviderFactory {
    private static final InjectionProvider NOOP_PROVIDER = new NoopInjectionProvider();
    private static final String INJECTION_PROVIDER_PROPERTY = "com.sun.faces.InjectionProvider";
    private static final Logger LOGGER = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.application");

    public static InjectionProvider createInstance(ExternalContext extContext) {
        String providerClass = InjectionProviderFactory.findProviderClass(extContext);
        InjectionProvider provider = InjectionProviderFactory.getProviderInstance(providerClass);
        if (provider.getClass() != NoopInjectionProvider.class) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "jsf.spi.injection.provider_configured", new Object[]{provider.getClass().getName()});
            }
        } else if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "jsf.spi.injection.no_injection");
        }
        return provider;
    }

    private static InjectionProvider getProviderInstance(String className) {
        InjectionProvider provider;
        block10: {
            provider = NOOP_PROVIDER;
            if (className != null) {
                try {
                    Class clazz = Util.loadClass(className, InjectionProviderFactory.class);
                    if (InjectionProviderFactory.implementsInjectionProvider(clazz)) {
                        provider = (InjectionProvider)clazz.newInstance();
                    } else if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_not_implemented", new Object[]{className});
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_not_found", new Object[]{className});
                    }
                }
                catch (InstantiationException ie) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_cannot_instantiate", new Object[]{className});
                        LOGGER.log(Level.SEVERE, "", ie);
                    }
                }
                catch (IllegalAccessException iae) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block10;
                    LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_cannot_instantiate", new Object[]{className});
                    LOGGER.log(Level.SEVERE, "", iae);
                }
            }
        }
        return provider;
    }

    private static boolean implementsInjectionProvider(Class<?> clazz) {
        return InjectionProvider.class.isAssignableFrom(clazz);
    }

    private static String findProviderClass(ExternalContext extContext) {
        WebConfiguration webConfig = WebConfiguration.getInstance(extContext);
        String provider = webConfig.getContextInitParameter(WebConfiguration.WebContextInitParameter.InjectionProviderClass);
        if (provider != null) {
            return provider;
        }
        return System.getProperty(INJECTION_PROVIDER_PROPERTY);
    }

    private static final class NoopInjectionProvider
    implements InjectionProvider {
        private NoopInjectionProvider() {
        }

        public void inject(Object managedBean) {
        }

        public void invokePreDestroy(Object managedBean) {
        }

        public void invokePostConstruct(Object managedBean) throws InjectionProviderException {
        }
    }
}

