/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato;

import com.iplanet.jato.RequestContext;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class RequestManager {
    private static InheritableThreadLocal requestContexts = new InheritableThreadLocal();

    private RequestManager() {
    }

    public static RequestContext getRequestContext() {
        return (RequestContext)requestContexts.get();
    }

    protected static void setRequestContext(RequestContext context) {
        requestContexts.set(context);
    }

    public static HttpServletRequest getRequest() {
        HttpServletRequest result = null;
        RequestContext context = RequestManager.getRequestContext();
        if (context != null) {
            result = context.getRequest();
        }
        return result;
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse result = null;
        RequestContext context = RequestManager.getRequestContext();
        if (context != null) {
            result = context.getResponse();
        }
        return result;
    }

    public static HttpSession getSession() {
        HttpSession result = null;
        RequestContext context = RequestManager.getRequestContext();
        if (context != null) {
            result = context.getRequest().getSession();
        }
        return result;
    }

    public static Servlet getHandlingServlet() {
        Servlet result = null;
        RequestContext context = RequestManager.getRequestContext();
        if (context != null) {
            result = (Servlet)context.getRequest().getAttribute("jato.handlingServlet");
        }
        return result;
    }
}

