/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.component;

import com.iplanet.jato.component.ComponentDescriptor;
import com.iplanet.jato.component.ComponentInfo;
import com.iplanet.jato.component.ComponentMethodDescriptor;
import com.iplanet.jato.component.ConfigPropertyDescriptor;
import com.iplanet.jato.component.EventHandlerDescriptor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class SimpleComponentInfo
implements ComponentInfo {
    private static Map iconColor16Cache = new HashMap();
    private static Map iconColor32Cache = new HashMap();
    private Image iconColor16;
    private Image iconColor32;

    protected synchronized Image getIconColor16(String resource) {
        if (this.iconColor16 == null) {
            Image result = (Image)iconColor16Cache.get(this.getClass().getName());
            if (result == null) {
                this.iconColor16 = this.loadImage(resource);
                if (this.iconColor16 != null) {
                    iconColor16Cache.put(this.getClass().getName(), this.iconColor16);
                }
            } else {
                this.iconColor16 = result;
            }
        }
        return this.iconColor16;
    }

    protected synchronized Image getIconColor32(String resource) {
        if (this.iconColor32 == null) {
            Image result = (Image)iconColor32Cache.get(this.getClass().getName());
            if (result == null) {
                this.iconColor32 = this.loadImage(resource);
                if (this.iconColor32 != null) {
                    iconColor32Cache.put(this.getClass().getName(), this.iconColor32);
                }
            } else {
                this.iconColor32 = result;
            }
        }
        return this.iconColor32;
    }

    public ComponentDescriptor getComponentDescriptor() {
        return null;
    }

    public ComponentInfo getAsType(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isInstance(this)) {
            return this;
        }
        return null;
    }

    public ConfigPropertyDescriptor[] getConfigPropertyDescriptors() {
        return new ConfigPropertyDescriptor[0];
    }

    public Image getIcon(int iconKind) {
        switch (iconKind) {
            case 1: {
                return this.iconColor16;
            }
            case 2: {
                return this.iconColor32;
            }
        }
        return null;
    }

    public EventHandlerDescriptor[] getEventHandlerDescriptors() {
        return new EventHandlerDescriptor[0];
    }

    public ComponentMethodDescriptor[] getComponentMethodDescriptors() {
        return new ComponentMethodDescriptor[0];
    }

    public Image loadImage(String resourceName) {
        return SimpleComponentInfo.loadImage(this.getClass(), resourceName);
    }

    public static Image loadImage(final Class clazz, final String resourceName) {
        try {
            ImageProducer ip = (ImageProducer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL url = clazz.getResource(resourceName);
                    if (url == null) {
                        return null;
                    }
                    try {
                        return url.getContent();
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                }
            });
            if (ip == null) {
                return null;
            }
            Toolkit tk = Toolkit.getDefaultToolkit();
            return new ImageIcon(tk.createImage(ip)).getImage();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getResourceString(Class sourceClass, String name, String defaultString) {
        if (sourceClass == null || name == null) {
            return null;
        }
        String packageName = sourceClass.getName();
        int index = packageName.lastIndexOf(46);
        if (index != -1) {
            packageName = packageName.substring(0, index);
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(packageName + ".Bundle", Locale.getDefault(), sourceClass.getClassLoader());
            return bundle.getString(name);
        }
        catch (MissingResourceException e) {
            return defaultString;
        }
    }
}

