/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.HttpSessionAttributeDescriptor;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelFieldDescriptor;
import com.iplanet.jato.model.ModelFieldGroup;
import com.iplanet.jato.util.TypeConverter;
import java.io.Serializable;
import javax.servlet.http.HttpSession;

public class SessionModel
implements Model,
RequestParticipant {
    private String name;
    private transient HttpSession session;
    private ModelFieldGroup fieldGroup;
    private boolean allowSettingEquivalentValue = false;

    public SessionModel() {
        RequestContext requestContext = RequestManager.getRequestContext();
        if (requestContext != null) {
            this.session = requestContext.getRequest().getSession();
        }
    }

    public SessionModel(HttpSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Parameter \"session\" cannot be null");
        }
        this.session = session;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setRequestContext(RequestContext value) {
        if (this.session == null) {
            this.session = value.getRequest().getSession(true);
        }
    }

    public Object[] getValues(String name) {
        Object result = this.getValue(name);
        if (result != null) {
            return new Object[]{result};
        }
        return new Object[0];
    }

    public void setValues(String name, Object[] value) {
        if (value != null && value.length > 0) {
            this.setValue(name, value[0]);
        } else {
            this.setValue(name, null);
        }
    }

    public Object getValue(String name) {
        HttpSessionAttributeDescriptor attribute = this.getAttributeDescriptor(name);
        name = this.validateName(name);
        Object result = this.session.getAttribute(name);
        if (null != attribute && attribute.isTransientAttribute() && result instanceof TransientAttributeWrapper) {
            result = ((TransientAttributeWrapper)result).getContainedAttribute();
        }
        return result;
    }

    public void setValue(String name, Object value) {
        Object existing;
        HttpSessionAttributeDescriptor attribute = this.getAttributeDescriptor(name);
        name = this.validateName(name);
        if (!this.isAllowSettingEquivalentValue() && (existing = this.getValue(name)) != null && existing.equals(value)) {
            return;
        }
        if (null != attribute && null != value && attribute.getAttributeClass() != null && !attribute.getAttributeClass().isAssignableFrom(value.getClass())) {
            value = TypeConverter.asType(attribute.getAttributeClass(), value);
        }
        if (null != attribute && attribute.isTransientAttribute()) {
            value = new TransientAttributeWrapper(value);
        }
        if (value != null) {
            this.session.setAttribute(name, value);
        } else {
            this.session.removeAttribute(name);
        }
    }

    protected HttpSessionAttributeDescriptor getAttributeDescriptor(String name) {
        return null != this.getFieldGroup() ? (HttpSessionAttributeDescriptor)this.getFieldGroup().getFieldDescriptor(name) : null;
    }

    protected String validateName(String name) {
        HttpSessionAttributeDescriptor field;
        if (null == name || name.trim().length() == 0) {
            throw new IllegalArgumentException("The 'name' parameter cannot be null or blank");
        }
        HttpSessionAttributeDescriptor httpSessionAttributeDescriptor = field = null != this.getFieldGroup() ? (HttpSessionAttributeDescriptor)this.getFieldGroup().getFieldDescriptor(name) : null;
        if (null == field || null == field.getAttributeName() || field.getAttributeName().trim().length() == 0) {
            return name;
        }
        return field.getAttributeName();
    }

    public void ensureInitialValues() {
        if (null == this.getFieldGroup()) {
            return;
        }
        ModelFieldDescriptor[] attributes = this.getFieldGroup().getFieldDescriptors();
        int i = 0;
        while (i < attributes.length) {
            HttpSessionAttributeDescriptor attributeDescriptor = (HttpSessionAttributeDescriptor)attributes[i];
            String name = attributeDescriptor.getName();
            if (null == this.getValue(attributeDescriptor.getName()) && null != attributeDescriptor.getInitialValue()) {
                this.setValue(attributeDescriptor.getName(), attributeDescriptor.getInitialValue());
            }
            ++i;
        }
    }

    public void setFieldGroup(ModelFieldGroup group) {
        this.fieldGroup = group;
    }

    protected ModelFieldGroup recoverFieldGroup() {
        return null;
    }

    public ModelFieldGroup getFieldGroup() {
        if (null == this.fieldGroup) {
            this.fieldGroup = this.recoverFieldGroup();
        }
        return this.fieldGroup;
    }

    public boolean isAllowSettingEquivalentValue() {
        return this.allowSettingEquivalentValue;
    }

    public void setAllowSettingEquivalentValue(boolean value) {
        this.allowSettingEquivalentValue = value;
    }

    public static class TransientAttributeWrapper
    implements Serializable {
        private transient Object containedAttribute = null;

        public TransientAttributeWrapper() {
        }

        public TransientAttributeWrapper(Object attr) {
            this.setContainedAttribute(attr);
        }

        public Object getContainedAttribute() {
            return this.containedAttribute;
        }

        public void setContainedAttribute(Object attr) {
            this.containedAttribute = attr;
        }
    }
}

