/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model.sql;

import com.iplanet.jato.Log;
import com.iplanet.jato.RequestCompletionListener;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DatasetModelExecutionContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.sql.DeleteQueryModel;
import com.iplanet.jato.model.sql.InsertQueryModel;
import com.iplanet.jato.model.sql.QueryFieldDescriptor;
import com.iplanet.jato.model.sql.QueryModel;
import com.iplanet.jato.model.sql.ResultSetModelBase;
import com.iplanet.jato.model.sql.SQLModelExecutionContext;
import com.iplanet.jato.model.sql.SelectQueryModel;
import com.iplanet.jato.model.sql.UpdateQueryModel;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.util.ProfileTimer;
import com.iplanet.jato.util.StringTokenizer2;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class QueryModelBase
extends ResultSetModelBase
implements QueryModel,
RequestParticipant,
RequestCompletionListener,
Serializable,
SelectQueryModel,
DeleteQueryModel,
InsertQueryModel,
UpdateQueryModel {
    public static final int QUERY_TYPE_SELECT = 1;
    public static final int QUERY_TYPE_INSERT = 2;
    public static final int QUERY_TYPE_UPDATE = 3;
    public static final int QUERY_TYPE_DELETE = 4;
    protected static final boolean OPTION_OPTIMAL_DRIVER_USAGE = false;
    protected static final boolean OPTION_CHECK_FOR_EXISTING_USER_WHERE_CRITERIA = false;
    private String dataSourceName;
    private boolean traceSQL = true;
    private String whereClauseOverride = null;
    private String staticWhereCriteria;
    private String modifyingTableName = "";
    private Map fieldValueCriteria = null;
    private transient Map internalCriteria = null;
    private List userWhereCriteria = null;
    private transient RequestContext requestContext;
    private transient int numAffectedRows = -1;
    private String defaultUser = null;
    private String defaultPassword = null;
    private String selectSQLTemplate;
    private String selectSQLTemplateWhereToken = "__WHERE__";
    private String selectSQL;
    private String insertSQL;
    private String updateSQL;
    private String deleteSQL;
    static /* synthetic */ Class class$com$iplanet$jato$model$DatasetModelExecutionContext;
    static /* synthetic */ Class class$java$lang$String;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String value) {
        this.dataSourceName = value;
    }

    public boolean getTraceSQL() {
        return this.traceSQL;
    }

    public void setTraceSQL(boolean value) {
        this.traceSQL = value;
    }

    public String getSQL(int type) {
        String result = null;
        switch (type) {
            case 1: {
                result = this.getSelectSQL();
                break;
            }
            case 2: {
                result = this.getInsertSQL();
                break;
            }
            case 3: {
                result = this.getUpdateSQL();
                break;
            }
            case 4: {
                result = this.getDeleteSQL();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid SQL type code \"" + type + "\"");
            }
        }
        if (this.getTraceSQL()) {
            Log.log(8, "SQL [modelName = " + this.getName() + "]: " + result);
        }
        return result;
    }

    public String getSelectSQLTemplate() {
        return this.selectSQLTemplate;
    }

    public void setSelectSQLTemplate(String value) {
        this.selectSQLTemplate = value;
    }

    public String getSelectSQLTemplateWhereToken() {
        return this.selectSQLTemplateWhereToken;
    }

    public void setSelectSQLTemplateWhereToken(String value) {
        this.selectSQLTemplateWhereToken = value;
    }

    public String getSelectSQL() {
        if (this.selectSQL != null) {
            return this.selectSQL;
        }
        return this.constructSelectSQL();
    }

    public void setSelectSQL(String value) {
        this.selectSQL = value;
    }

    public String getInsertSQL() {
        if (this.insertSQL != null) {
            return this.insertSQL;
        }
        return this.constructInsertSQL();
    }

    public void setInsertSQL(String value) {
        this.insertSQL = value;
    }

    public String getUpdateSQL() {
        if (this.updateSQL != null) {
            return this.updateSQL;
        }
        return this.constructUpdateSQL();
    }

    public void setUpdateSQL(String value) {
        this.updateSQL = value;
    }

    public String getDeleteSQL() {
        if (this.deleteSQL != null) {
            return this.deleteSQL;
        }
        return this.constructDeleteSQL();
    }

    public void setDeleteSQL(String value) {
        this.deleteSQL = value;
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        if (context == null) {
            throw new IllegalArgumentException("Context passed to the execute() method cannot be null because it requires specification of an operation name");
        }
        if (context.getOperationName() == null) {
            throw new IllegalArgumentException("Context operation name cannot be null");
        }
        Object result = null;
        if (context.getOperationName().equals("retrieve")) {
            result = this.retrieve(context);
        } else if (context.getOperationName().equals("insert")) {
            result = this.insert(context);
        } else if (context.getOperationName().equals("update")) {
            result = this.update(context);
        } else if (context.getOperationName().equals("delete")) {
            result = this.delete(context);
        } else {
            throw new IllegalArgumentException("Unknown context operation name \"" + context.getOperationName() + "\"");
        }
        return result;
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        if (context != null && !(context instanceof DatasetModelExecutionContext)) {
            throw new IllegalArgumentException("Context must be a valid instance of type " + (class$com$iplanet$jato$model$DatasetModelExecutionContext == null ? (class$com$iplanet$jato$model$DatasetModelExecutionContext = QueryModelBase.class$("com.iplanet.jato.model.DatasetModelExecutionContext")) : class$com$iplanet$jato$model$DatasetModelExecutionContext).getName() + " (context = " + context + ")");
        }
        try {
            this.executeSelect((DatasetModelExecutionContext)context);
            return this.getResultSet();
        }
        catch (SQLException e) {
            throw new ModelControlException(e);
        }
    }

    public Object insert(ModelExecutionContext context) throws ModelControlException {
        try {
            return new Integer(this.executeInsert(context));
        }
        catch (SQLException e) {
            throw new ModelControlException(e);
        }
    }

    public Object update(ModelExecutionContext context) throws ModelControlException {
        try {
            return new Integer(this.executeUpdate(context));
        }
        catch (SQLException e) {
            throw new ModelControlException(e);
        }
    }

    public Object delete(ModelExecutionContext context) throws ModelControlException {
        try {
            return new Integer(this.executeDelete(context));
        }
        catch (SQLException e) {
            throw new ModelControlException(e);
        }
    }

    public String getDelimitedTableNames() {
        return this.getModifyingQueryTableName();
    }

    public void setDelimitedTableNames(String value) {
        this.setModifyingQueryTableName(value);
    }

    public String getModifyingQueryTableName() {
        return this.modifyingTableName;
    }

    public void setModifyingQueryTableName(String value) {
        this.modifyingTableName = value;
    }

    protected boolean shouldQuoteType(Class columnClass) {
        return columnClass == (class$java$lang$String == null ? (class$java$lang$String = QueryModelBase.class$("java.lang.String")) : class$java$lang$String);
    }

    protected boolean shouldQuoteValue(Class columnClass) {
        return this.shouldQuoteType(columnClass);
    }

    protected String constructSelectSQL() {
        String template = this.getSelectSQLTemplate();
        return StringTokenizer2.replace(template, this.getSelectSQLTemplateWhereToken(), this.getWhereClause());
    }

    protected String constructInsertSQL() {
        NonSyncStringBuffer fieldsBuffer = new NonSyncStringBuffer(256);
        NonSyncStringBuffer valuesBuffer = new NonSyncStringBuffer(256);
        fieldsBuffer.append("INSERT INTO ");
        fieldsBuffer.append(this.getModifyingQueryTableName());
        fieldsBuffer.append(" (");
        boolean previousValueExists = false;
        boolean previousFieldExists = false;
        QueryFieldDescriptor[] fieldDescriptors = this.getFieldSchema().getFieldDescriptors();
        int i = 0;
        while (i < fieldDescriptors.length) {
            QueryFieldDescriptor fd = fieldDescriptors[i];
            if (fd.isQueryTypeEnabled(2)) {
                String fieldName = fd.getName();
                String queryFieldName = fd.getColumnName();
                boolean addedValue = false;
                if (fd.getInsertValueSource() == 1) {
                    if (fd.isComputedField() || this.hasValue(fieldName)) {
                        Object value = this.getInsertQueryValue(fieldName);
                        if (previousValueExists) {
                            valuesBuffer.append(",");
                        }
                        if (this.shouldQuoteType(fd.getFieldClass()) && !fd.isComputedField()) {
                            valuesBuffer.append("'" + this.escapeSingleQuotes(value.toString()) + "'");
                        } else {
                            valuesBuffer.append(value.toString());
                        }
                        addedValue = true;
                        previousValueExists = true;
                    }
                } else if (fd.getInsertValueSource() == 3) {
                    if (previousValueExists) {
                        valuesBuffer.append(",");
                    }
                    valuesBuffer.append(fd.getInsertFormula());
                    addedValue = true;
                    previousValueExists = true;
                } else if (!this.hasValue(fieldName) && fd.getOnEmptyValuePolicy() != 1) {
                    if (previousValueExists) {
                        valuesBuffer.append(",");
                    }
                    valuesBuffer.append(fd.getEmptyValue());
                    addedValue = true;
                    previousValueExists = true;
                }
                if (addedValue) {
                    if (previousFieldExists) {
                        fieldsBuffer.append(",");
                    }
                    fieldsBuffer.append(queryFieldName);
                    previousFieldExists = true;
                }
            }
            ++i;
        }
        fieldsBuffer.append(") VALUES (");
        fieldsBuffer.append(valuesBuffer);
        fieldsBuffer.append(")");
        return fieldsBuffer.toString();
    }

    protected Object getInsertQueryValue(String fieldName) {
        return this.getValue(fieldName);
    }

    protected String constructUpdateSQL() {
        boolean databaseDependent = true;
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(256);
        buffer.append("UPDATE ");
        buffer.append(this.getModifyingQueryTableName());
        buffer.append(" SET ");
        boolean setCriterion = false;
        boolean previousFieldExists = false;
        QueryFieldDescriptor[] fieldDescriptors = this.getFieldSchema().getFieldDescriptors();
        int i = 0;
        while (i < fieldDescriptors.length) {
            QueryFieldDescriptor fd = fieldDescriptors[i];
            if (fd.isQueryTypeEnabled(4)) {
                String fieldName = fd.getName();
                String queryFieldName = fd.getColumnName();
                if (fd.isKey()) {
                    if (this.hasValue(fieldName)) {
                        this.setInternalWhereCriterion(fieldName, "=");
                        setCriterion = true;
                    }
                } else if (this.hasValue(fieldName) || fd.isComputedField()) {
                    if (previousFieldExists) {
                        buffer.append(", ");
                    }
                    buffer.append(queryFieldName);
                    buffer.append(" = ");
                    Object value = this.getUpdateQueryValue(fieldName);
                    if (this.shouldQuoteType(fd.getFieldClass()) && !fd.isComputedField()) {
                        buffer.append("'" + this.escapeSingleQuotes(value.toString()) + "'");
                    } else {
                        buffer.append(value.toString());
                    }
                    previousFieldExists = true;
                } else if (!this.hasValue(fieldName) && fd.getOnEmptyValuePolicy() != 1) {
                    if (previousFieldExists) {
                        buffer.append(", ");
                    }
                    buffer.append(queryFieldName);
                    buffer.append(" = ");
                    switch (fd.getOnEmptyValuePolicy()) {
                        case 2: {
                            buffer.append("NULL");
                            break;
                        }
                        case 3: {
                            buffer.append(fd.getEmptyFormula());
                        }
                    }
                    previousFieldExists = true;
                }
            }
            ++i;
        }
        String whereClause = this.getWhereClause();
        if (!setCriterion && whereClause != null && whereClause.length() > 0) {
            setCriterion = true;
        }
        buffer.append(" ");
        buffer.append(whereClause);
        this.clearInternalWhereCriteria();
        if (!setCriterion) {
            throw new Error("No update criteria specified - entire table would have been updated; SQL = [" + buffer + "]");
        }
        return buffer.toString();
    }

    protected Object getUpdateQueryValue(String fieldName) {
        return this.getValue(fieldName);
    }

    protected String constructDeleteSQL() {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(256);
        buffer.append("DELETE FROM ");
        buffer.append(this.getModifyingQueryTableName());
        boolean setCriterion = false;
        QueryFieldDescriptor[] fieldDescriptors = this.getFieldSchema().getFieldDescriptors();
        int i = 0;
        while (i < fieldDescriptors.length) {
            String fieldName;
            QueryFieldDescriptor fd = fieldDescriptors[i];
            if (fd.isQueryTypeEnabled(8) && this.hasValue(fieldName = fd.getName())) {
                this.setInternalWhereCriterion(fieldName, "=");
                setCriterion = true;
            }
            ++i;
        }
        String whereClause = this.getWhereClause();
        if (!setCriterion && whereClause != null && whereClause.length() > 0) {
            setCriterion = true;
        }
        buffer.append(" ");
        buffer.append(whereClause);
        this.clearInternalWhereCriteria();
        if (!setCriterion) {
            throw new Error("No delete criteria specified - entire table would have been deleted; SQL = [" + buffer + "]");
        }
        return buffer.toString();
    }

    protected String escapeSingleQuotes(String value) {
        return StringTokenizer2.replace(value, "'", "''");
    }

    public String getStaticWhereCriteriaString() {
        return this.staticWhereCriteria;
    }

    public void setStaticWhereCriteriaString(String value) {
        this.staticWhereCriteria = value;
    }

    public String getWhereClause() {
        boolean hasUserCriteria;
        if (this.getWhereClauseOverride() != null) {
            return this.getWhereClauseOverride();
        }
        String staticCriteria = this.getStaticWhereCriteriaString();
        boolean hasStaticCriteria = staticCriteria != null && staticCriteria.trim().length() != 0;
        String fieldValueCriteria = this.getFieldValueWhereCriteriaString();
        boolean hasFieldValueCriteria = fieldValueCriteria != null && fieldValueCriteria.trim().length() != 0;
        String internalCriteria = this.getInternalWhereCriteriaString();
        boolean hasInternalCriteria = internalCriteria != null && internalCriteria.trim().length() != 0;
        String userCriteria = this.getUserWhereCriteriaString();
        boolean bl = hasUserCriteria = userCriteria != null && userCriteria.trim().length() != 0;
        if (!(hasStaticCriteria || hasFieldValueCriteria || hasUserCriteria || hasInternalCriteria)) {
            return "";
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer("WHERE ", 256);
        boolean appendedCriteria = false;
        if (hasStaticCriteria) {
            buffer.append(staticCriteria);
            appendedCriteria = true;
        }
        if (hasFieldValueCriteria) {
            if (appendedCriteria) {
                buffer.append(" AND ");
            }
            buffer.append(fieldValueCriteria);
            appendedCriteria = true;
        }
        if (hasInternalCriteria) {
            if (appendedCriteria) {
                buffer.append(" AND ");
            }
            buffer.append(internalCriteria);
            appendedCriteria = true;
        }
        if (hasUserCriteria) {
            if (appendedCriteria) {
                buffer.append(" AND ");
            }
            buffer.append(userCriteria);
            appendedCriteria = true;
        }
        return buffer.toString();
    }

    public String getWhereClauseOverride() {
        return this.whereClauseOverride;
    }

    public void setWhereClauseOverride(String value) {
        this.whereClauseOverride = value;
    }

    public String getFieldValueWhereCriteriaString() {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(256);
        Map fieldValueCriteria = this.getFieldValueWhereCriteria(false);
        if (fieldValueCriteria == null) {
            return null;
        }
        Iterator i = fieldValueCriteria.keySet().iterator();
        while (i.hasNext()) {
            String fieldName = (String)i.next();
            String operator = (String)fieldValueCriteria.get(fieldName);
            Object value = this.getValue(fieldName);
            if (value == null) continue;
            QueryFieldDescriptor fd = this.getFieldSchema().getFieldDescriptor(fieldName);
            if (fd != null) {
                fieldName = fd.getQualifiedColumnName();
            }
            String fieldValue = null;
            fieldValue = fd != null ? (this.shouldQuoteType(fd.getFieldClass()) ? "'" + this.escapeSingleQuotes(value.toString()) + "'" : value.toString()) : (this.shouldQuoteType(value.getClass()) ? "'" + this.escapeSingleQuotes(value.toString()) + "'" : value.toString());
            if (buffer.length() > 0) {
                buffer.append(" AND ");
            }
            buffer.append(fieldName);
            buffer.append(" = ");
            buffer.append(fieldValue);
        }
        return buffer.toString();
    }

    protected Map getFieldValueWhereCriteria(boolean createIfNeeded) {
        if (this.fieldValueCriteria == null && createIfNeeded) {
            this.fieldValueCriteria = new HashMap();
        }
        return this.fieldValueCriteria;
    }

    public void setFieldValueWhereCriterion(String logicalFieldName) {
        this.setFieldValueWhereCriterion(logicalFieldName, null);
    }

    public void setFieldValueWhereCriterion(String logicalFieldName, String operator) {
        if (operator == null) {
            operator = "=";
        }
        this.getFieldValueWhereCriteria(true).put(logicalFieldName, operator);
    }

    public void removeFieldValueWhereCriterion(String logicalFieldName) {
        Map criteria = this.getFieldValueWhereCriteria(false);
        if (criteria != null) {
            criteria.remove(logicalFieldName);
        }
    }

    public void clearFieldValueWhereCriteria() {
        Map criteria = this.getFieldValueWhereCriteria(false);
        if (criteria != null) {
            criteria.clear();
        }
    }

    private String getInternalWhereCriteriaString() {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(256);
        Map criteria = this.getInternalWhereCriteria(false);
        if (criteria == null) {
            return null;
        }
        Iterator i = criteria.keySet().iterator();
        while (i.hasNext()) {
            String fieldName = (String)i.next();
            String operator = (String)criteria.get(fieldName);
            Object value = this.getValue(fieldName);
            if (value == null) continue;
            QueryFieldDescriptor fd = this.getFieldSchema().getFieldDescriptor(fieldName);
            if (fd != null) {
                fieldName = fd.getQualifiedColumnName();
            }
            String fieldValue = null;
            fieldValue = fd != null ? (this.shouldQuoteType(fd.getFieldClass()) ? "'" + this.escapeSingleQuotes(value.toString()) + "'" : value.toString()) : (this.shouldQuoteType(value.getClass()) ? "'" + this.escapeSingleQuotes(value.toString()) + "'" : value.toString());
            if (buffer.length() > 0) {
                buffer.append(" AND ");
            }
            buffer.append(fieldName);
            buffer.append(" = ");
            buffer.append(fieldValue);
        }
        return buffer.toString();
    }

    private Map getInternalWhereCriteria(boolean createIfNeeded) {
        if (this.internalCriteria == null && createIfNeeded) {
            this.internalCriteria = new HashMap();
        }
        return this.internalCriteria;
    }

    private void setInternalWhereCriterion(String logicalFieldName, String operator) {
        if (operator == null) {
            operator = "=";
        }
        this.getInternalWhereCriteria(true).put(logicalFieldName, operator);
    }

    private void clearInternalWhereCriteria() {
        Map criteria = this.getInternalWhereCriteria(false);
        if (criteria != null) {
            criteria.clear();
        }
    }

    public String getUserWhereCriteriaString() {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(256);
        List criteria = this.getUserWhereCriteria(false);
        if (criteria == null) {
            return null;
        }
        Iterator i = criteria.iterator();
        while (i.hasNext()) {
            WhereCriterion criterion = (WhereCriterion)i.next();
            if (criterion.fieldDescriptor == null) {
                criterion.fieldDescriptor = this.getFieldSchema().getFieldDescriptor(criterion.logicalFieldName);
            }
            if (criterion.fieldDescriptor == null) {
                throw new IllegalArgumentException("The field \"" + criterion.logicalFieldName + "\" does not have a field descriptor");
            }
            if (criterion.value == null) continue;
            String fieldValue = null;
            fieldValue = this.shouldQuoteType(criterion.fieldDescriptor.getFieldClass()) ? "'" + this.escapeSingleQuotes(criterion.value.toString()) + "'" : criterion.value.toString();
            if (buffer.length() > 0) {
                buffer.append(" AND ");
            }
            buffer.append(criterion.fieldDescriptor.getQualifiedColumnName());
            buffer.append(" ");
            buffer.append(criterion.operator);
            buffer.append(" ");
            buffer.append(fieldValue);
        }
        return buffer.toString();
    }

    protected List getUserWhereCriteria(boolean createIfNeeded) {
        if (this.userWhereCriteria == null && createIfNeeded) {
            this.userWhereCriteria = new ArrayList();
        }
        return this.userWhereCriteria;
    }

    public void addUserWhereCriterion(String logicalFieldName, Object value) {
        this.addUserWhereCriterion(logicalFieldName, "=", value);
    }

    public void addUserWhereCriterion(String logicalFieldName, String operator, Object value) {
        WhereCriterion criterion = this.createUserWhereCriterion(logicalFieldName, operator, value);
        this.getUserWhereCriteria(true).add(criterion);
    }

    private WhereCriterion createUserWhereCriterion(String logicalFieldName, String operator, Object value) {
        QueryFieldDescriptor fd;
        if (logicalFieldName == null) {
            throw new IllegalArgumentException("Parameter \"logicalFieldName\" cannot be null");
        }
        if (operator == null) {
            operator = "=";
        }
        if (value == null) {
            // empty if block
        }
        if ((fd = this.getFieldSchema().getFieldDescriptor(logicalFieldName)) == null) {
            throw new IllegalArgumentException("The field \"" + logicalFieldName + "\" does not have a field descriptor");
        }
        WhereCriterion criterion = new WhereCriterion(fd, logicalFieldName, operator, value);
        return criterion;
    }

    public boolean hasUserWhereCriterion(String logicalFieldName, String operator, Object value) {
        WhereCriterion criterion = this.createUserWhereCriterion(logicalFieldName, operator, value);
        return this.hasUserWhereCriterion(criterion);
    }

    private boolean hasUserWhereCriterion(WhereCriterion criterion) {
        List criteria = this.getUserWhereCriteria(false);
        if (criteria == null) {
            return false;
        }
        int i = 0;
        while (i < criteria.size()) {
            WhereCriterion otherCriterion = (WhereCriterion)criteria.get(i);
            if (otherCriterion.equals(criterion)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeUserWhereCriteria(String logicalFieldName) {
        List criteria = this.getUserWhereCriteria(false);
        if (criteria != null) {
            Iterator i = criteria.iterator();
            while (i.hasNext()) {
                WhereCriterion criterion = (WhereCriterion)i.next();
                if (!criterion.logicalFieldName.equals(logicalFieldName)) continue;
                i.remove();
            }
        }
    }

    public void clearUserWhereCriteria() {
        List criteria = this.getUserWhereCriteria(false);
        if (criteria != null) {
            criteria.clear();
        }
    }

    protected String getUserWhereCriteriaSessionKey() {
        return "jato.model." + this.getName() + ".userWhereCriteria";
    }

    protected void storeSessionedUserWhereCriteria(RequestContext requestContext) {
        HttpSession session = requestContext.getRequest().getSession();
        if (session == null) {
            return;
        }
        List criteria = this.getUserWhereCriteria(false);
        if (criteria == null || criteria.size() == 0) {
            session.removeAttribute(this.getUserWhereCriteriaSessionKey());
        } else {
            session.setAttribute(this.getUserWhereCriteriaSessionKey(), (Object)criteria);
        }
    }

    protected void restoreSessionedUserWhereCriteria(RequestContext requestContext) {
        HttpSession session = requestContext.getRequest().getSession();
        if (session == null) {
            return;
        }
        this.userWhereCriteria = (List)session.getAttribute(this.getUserWhereCriteriaSessionKey());
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext value) {
        this.requestContext = value;
        this.restoreSessionedUserWhereCriteria(this.requestContext);
    }

    public void requestComplete() {
        this.storeSessionedUserWhereCriteria(this.getRequestContext());
    }

    protected String beforeExecute(ModelExecutionContext context, int queryType, String sql) throws ModelControlException {
        return sql;
    }

    protected void afterExecute(ModelExecutionContext context, int queryType) throws ModelControlException {
    }

    protected void onDatabaseError(ModelExecutionContext context, int queryType, SQLException exception) {
    }

    public Connection getDefaultConnection() throws SQLException {
        RequestContext requestContext = this.getRequestContext();
        if (requestContext != null) {
            if (this.getDefaultConnectionUser() == null || this.getDefaultConnectionUser().trim().length() == 0) {
                return requestContext.getSQLConnectionManager().getConnection(this.getDataSourceName());
            }
            return requestContext.getSQLConnectionManager().getConnection(this.getDataSourceName(), this.getDefaultConnectionUser(), this.getDefaultConnectionPassword());
        }
        throw new SQLException("Could not obtain connection because request context is null");
    }

    public String getDefaultConnectionUser() {
        return this.defaultUser;
    }

    public void setDefaultConnectionUser(String value) {
        this.defaultUser = value;
    }

    public String getDefaultConnectionPassword() {
        return this.defaultPassword;
    }

    public void setDefaultConnectionPassword(String value) {
        this.defaultPassword = value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeSelect(DatasetModelExecutionContext context) throws SQLException, ModelControlException {
        ResultSet resultSet;
        boolean usedDefaultConnection;
        Connection connection;
        block10: {
            Statement statement = null;
            connection = null;
            usedDefaultConnection = false;
            boolean usedDefaultStatement = false;
            ProfileTimer timer = new ProfileTimer();
            timer.start();
            String sql = this.getSQL(1);
            sql = this.beforeExecute(context, 1, sql);
            if (sql == null) {
                return null;
            }
            try {
                try {
                    if (context != null && context instanceof SQLModelExecutionContext) {
                        statement = ((SQLModelExecutionContext)((Object)context)).getStatement();
                        connection = ((SQLModelExecutionContext)((Object)context)).getConnection();
                    }
                    if (statement == null) {
                        if (connection == null) {
                            connection = this.getDefaultConnection();
                            usedDefaultConnection = true;
                        }
                        statement = connection.createStatement();
                        usedDefaultStatement = true;
                    }
                    if (context != null && usedDefaultConnection && context.getDatasetSize() == -2) {
                        throw new ModelControlException("Model context cannot specify DatasetModelExecutionContext.DATASET_SIZE_ALL_INCREMENTAL directive with use of a default connection");
                    }
                    this.clear();
                    ResultSet results = statement.executeQuery(sql);
                    this.setResultSet(results);
                    this.setNumAffectedRows(-1);
                    this.positionResultSet(context);
                    this.afterExecute(context, 1);
                    resultSet = results;
                    Object var11_11 = null;
                    if (!usedDefaultConnection || !usedDefaultStatement || statement == null) break block10;
                }
                catch (SQLException e) {
                    this.onDatabaseError(context, 1, e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (usedDefaultConnection && usedDefaultStatement && statement != null) {
                    statement.close();
                }
                if (!usedDefaultConnection) throw throwable;
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            statement.close();
        }
        if (!usedDefaultConnection) return resultSet;
        if (connection == null) return resultSet;
        connection.close();
        return resultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(ModelExecutionContext context) throws SQLException, ModelControlException {
        int n;
        boolean usedDefaultConnection;
        Connection connection;
        block9: {
            this.clearResultSet();
            Statement statement = null;
            connection = null;
            usedDefaultConnection = false;
            boolean usedDefaultStatement = false;
            String sql = this.getSQL(3);
            sql = this.beforeExecute(context, 3, sql);
            if (sql == null) {
                return -1;
            }
            try {
                try {
                    if (context != null && context instanceof SQLModelExecutionContext) {
                        statement = ((SQLModelExecutionContext)context).getStatement();
                        connection = ((SQLModelExecutionContext)context).getConnection();
                    }
                    if (statement == null) {
                        if (connection == null) {
                            connection = this.getDefaultConnection();
                            usedDefaultConnection = true;
                        }
                        statement = connection.createStatement();
                        usedDefaultStatement = true;
                    }
                    int result = statement.executeUpdate(sql);
                    this.setNumAffectedRows(result);
                    this.afterExecute(context, 3);
                    n = result;
                    Object var10_10 = null;
                    if (!usedDefaultStatement || statement == null) break block9;
                }
                catch (SQLException e) {
                    this.onDatabaseError(context, 3, e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (usedDefaultStatement && statement != null) {
                    statement.close();
                }
                if (!usedDefaultConnection) throw throwable;
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            statement.close();
        }
        if (!usedDefaultConnection) return n;
        if (connection == null) return n;
        connection.close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeInsert(ModelExecutionContext context) throws SQLException, ModelControlException {
        int n;
        boolean usedDefaultConnection;
        Connection connection;
        block9: {
            this.clearResultSet();
            Statement statement = null;
            connection = null;
            usedDefaultConnection = false;
            boolean usedDefaultStatement = false;
            String sql = this.getSQL(2);
            sql = this.beforeExecute(context, 2, sql);
            if (sql == null) {
                return -1;
            }
            try {
                try {
                    if (context != null && context instanceof SQLModelExecutionContext) {
                        statement = ((SQLModelExecutionContext)context).getStatement();
                        connection = ((SQLModelExecutionContext)context).getConnection();
                    }
                    if (statement == null) {
                        if (connection == null) {
                            connection = this.getDefaultConnection();
                            usedDefaultConnection = true;
                        }
                        statement = connection.createStatement();
                        usedDefaultStatement = true;
                    }
                    int result = statement.executeUpdate(sql);
                    this.setNumAffectedRows(result);
                    this.afterExecute(context, 2);
                    n = result;
                    Object var10_10 = null;
                    if (!usedDefaultStatement || statement == null) break block9;
                }
                catch (SQLException e) {
                    this.onDatabaseError(context, 2, e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (usedDefaultStatement && statement != null) {
                    statement.close();
                }
                if (!usedDefaultConnection) throw throwable;
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            statement.close();
        }
        if (!usedDefaultConnection) return n;
        if (connection == null) return n;
        connection.close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeDelete(ModelExecutionContext context) throws SQLException, ModelControlException {
        int n;
        boolean usedDefaultConnection;
        Connection connection;
        block9: {
            this.clearResultSet();
            Statement statement = null;
            connection = null;
            usedDefaultConnection = false;
            boolean usedDefaultStatement = false;
            String sql = this.getSQL(4);
            sql = this.beforeExecute(context, 4, sql);
            if (sql == null) {
                return -1;
            }
            try {
                try {
                    if (context != null && context instanceof SQLModelExecutionContext) {
                        statement = ((SQLModelExecutionContext)context).getStatement();
                        connection = ((SQLModelExecutionContext)context).getConnection();
                    }
                    if (statement == null) {
                        if (connection == null) {
                            connection = this.getDefaultConnection();
                            usedDefaultConnection = true;
                        }
                        statement = connection.createStatement();
                        usedDefaultStatement = true;
                    }
                    int result = statement.executeUpdate(sql);
                    this.setNumAffectedRows(result);
                    this.afterExecute(context, 4);
                    n = result;
                    Object var10_10 = null;
                    if (!usedDefaultStatement || statement == null) break block9;
                }
                catch (SQLException e) {
                    this.onDatabaseError(context, 4, e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (usedDefaultStatement && statement != null) {
                    statement.close();
                }
                if (!usedDefaultConnection) throw throwable;
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            statement.close();
        }
        if (!usedDefaultConnection) return n;
        if (connection == null) return n;
        connection.close();
        return n;
    }

    public int getNumAffectedRows() {
        return this.numAffectedRows;
    }

    protected void setNumAffectedRows(int value) {
        this.numAffectedRows = value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        QUERY_TYPE_SELECT = 1;
        QUERY_TYPE_INSERT = 2;
        QUERY_TYPE_UPDATE = 3;
        QUERY_TYPE_DELETE = 4;
        OPTION_OPTIMAL_DRIVER_USAGE = false;
        OPTION_CHECK_FOR_EXISTING_USER_WHERE_CRITERIA = false;
    }

    public static class WhereCriterion
    implements Serializable {
        public transient QueryFieldDescriptor fieldDescriptor;
        public String logicalFieldName;
        public String operator;
        public Object value;

        public WhereCriterion(QueryFieldDescriptor fieldDescriptor, String logicalFieldName, String operator, Object value) {
            this.fieldDescriptor = fieldDescriptor;
            this.logicalFieldName = logicalFieldName;
            this.operator = operator;
            this.value = value;
        }

        public int hashCode() {
            NonSyncStringBuffer result = new NonSyncStringBuffer(64);
            if (this.logicalFieldName != null) {
                result.append(this.logicalFieldName);
            }
            if (this.operator != null) {
                result.append(this.operator);
            }
            if (this.value != null) {
                result.append(this.value);
            }
            return result.toString().hashCode();
        }

        public boolean equals(Object other) {
            WhereCriterion otherCriterion = null;
            if (!(other instanceof WhereCriterion)) {
                return false;
            }
            otherCriterion = (WhereCriterion)other;
            return otherCriterion.logicalFieldName.equals(this.logicalFieldName) && otherCriterion.operator.equals(this.operator) && otherCriterion.value != null && this.value != null && otherCriterion.value.equals(this.value);
        }
    }
}

