/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.util;

import com.iplanet.jato.util.ApplicationObjectInputStream;
import com.iplanet.jato.util.Http64Decoder;
import com.iplanet.jato.util.Http64Encoder;
import com.iplanet.jato.util.StringTokenizer2;
import com.iplanet.jato.util.WrapperRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Encoder {
    private static final int COMPRESS_BUFFER_SIZE = 1024;

    private Encoder() {
    }

    public static String encode(byte[] bytes) {
        return Encoder.encodeHttp64(bytes, Integer.MAX_VALUE);
    }

    public static byte[] decode(String s) {
        return Encoder.decodeHttp64(s);
    }

    public static String encodeBase64(byte[] bytes) {
        BASE64Encoder encoder = new BASE64Encoder();
        String result = encoder.encodeBuffer(bytes);
        result = StringTokenizer2.replace(result, "\r", "");
        result = StringTokenizer2.replace(result, "\n", "");
        return result;
    }

    public static byte[] decodeBase64(String s) {
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            return decoder.decodeBuffer(s);
        }
        catch (IOException e) {
            e.printStackTrace();
            return s.getBytes();
        }
    }

    public static String encodeHttp64(byte[] bytes, int compressThreshold) {
        byte[] result = null;
        if (bytes.length > compressThreshold) {
            result = Encoder.compress(bytes);
        } else {
            result = new byte[bytes.length + 1];
            result[0] = 0;
            System.arraycopy(bytes, 0, result, 1, bytes.length);
        }
        Http64Encoder encoder = new Http64Encoder();
        String encodedString = encoder.encodeBuffer(result);
        encodedString = StringTokenizer2.replace(encodedString, "\r", "");
        encodedString = StringTokenizer2.replace(encodedString, "\n", "");
        return encodedString;
    }

    public static byte[] decodeHttp64(String s) {
        try {
            Http64Decoder decoder = new Http64Decoder();
            byte[] result = decoder.decodeBuffer(s);
            return Encoder.decompress(result);
        }
        catch (IOException e) {
            e.printStackTrace();
            return s.getBytes();
        }
    }

    public static byte[] compress(byte[] in) {
        if (in.length == 0) {
            return in;
        }
        Deflater deflater = new Deflater(9);
        byte[] result = new byte[in.length + 1];
        deflater.setInput(in, 0, in.length);
        deflater.finish();
        int compressedLength = deflater.deflate(result, 1, in.length);
        if (compressedLength > 0 && deflater.finished()) {
            result[0] = (byte)((in.length + 1024 - 1) / 1024);
            return Encoder.subBuffer(result, 0, compressedLength + 1);
        }
        result[0] = 0;
        System.arraycopy(in, 0, result, 1, in.length);
        return result;
    }

    public static byte[] decompress(byte[] in) {
        if (in.length < 2) {
            return in;
        }
        if (in[0] == 0) {
            return Encoder.subBuffer(in, 1, in.length - 1);
        }
        int bufferSize = 1024 * in[0];
        byte[] buffer = new byte[bufferSize];
        try {
            Inflater inflater = new Inflater();
            inflater.setInput(in, 1, in.length - 1);
            bufferSize = inflater.inflate(buffer, 0, bufferSize);
            if (bufferSize == 0 || !inflater.finished()) {
                throw new RuntimeException("Decompression failed");
            }
        }
        catch (DataFormatException e) {
            throw new WrapperRuntimeException(e);
        }
        return Encoder.subBuffer(buffer, 0, bufferSize);
    }

    private static byte[] subBuffer(byte[] in, int idx, int len) {
        byte[] out = new byte[len];
        System.arraycopy(in, idx, out, 0, len);
        return out;
    }

    public static byte[] serialize(Serializable o, boolean compress) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        DeflaterOutputStream dos = null;
        ObjectOutputStream oos = null;
        if (compress) {
            dos = new DeflaterOutputStream((OutputStream)baos, new Deflater(9));
            oos = new ObjectOutputStream(dos);
        } else {
            oos = new ObjectOutputStream(baos);
        }
        oos.writeObject(o);
        oos.flush();
        oos.close();
        if (dos != null) {
            dos.finish();
            dos.close();
        }
        return baos.toByteArray();
    }

    public static Object deserialize(byte[] b, boolean compressed) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        InflaterInputStream iis = null;
        ApplicationObjectInputStream ois = null;
        if (compressed) {
            iis = new InflaterInputStream(bais);
            ois = new ApplicationObjectInputStream(iis);
        } else {
            ois = new ApplicationObjectInputStream(bais);
        }
        Object result = ois.readObject();
        return result;
    }

    static {
        COMPRESS_BUFFER_SIZE = 1024;
    }
}

