/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.util;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.util.StringTokenizer2;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;

public class HtmlUtil {
    private static final String LT = "&lt;";
    private static final String GT = "&gt;";
    private static final String AMP = "&amp;";
    private static final String QUOT = "&quot;";
    public static final char ALPHANUMERIC_MASK_TOKEN = '?';
    public static final int NO_FORMAT_TYPE = 0;
    public static final int ALPHANUMERIC_FORMAT_TYPE = 1;
    public static final int DATETIME_FORMAT_TYPE = 2;
    public static final int CURRENCY_FORMAT_TYPE = 3;
    public static final int DECIMAL_FORMAT_TYPE = 4;
    private static int uniqueValue;
    static /* synthetic */ Class class$com$iplanet$jato$util$HtmlUtil;

    private HtmlUtil() {
    }

    public static String escapeQuotes(String rawString) {
        return StringTokenizer2.replace(rawString, "\"", QUOT);
    }

    public static String escape(String rawString) {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(rawString.length() + 18);
        int i = 0;
        while (i < rawString.length()) {
            char c = rawString.charAt(i);
            switch (c) {
                case '<': {
                    buffer.append(LT);
                    break;
                }
                case '>': {
                    buffer.append(GT);
                    break;
                }
                case '&': {
                    buffer.append(AMP);
                    break;
                }
                case '\"': {
                    buffer.append(QUOT);
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String descape(String encodedString) {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(encodedString.length());
        int i = 0;
        while (i < encodedString.length()) {
            char c = encodedString.charAt(i);
            if (c == '&') {
                if (encodedString.startsWith(LT, i)) {
                    buffer.append('<');
                } else if (encodedString.startsWith(GT, i)) {
                    buffer.append('>');
                } else if (encodedString.startsWith(AMP, i)) {
                    buffer.append('&');
                } else if (encodedString.startsWith(QUOT, i)) {
                    buffer.append('\"');
                } else {
                    buffer.append(c);
                }
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUniqueValue() {
        int THRESHOLD = 2147433647;
        if (uniqueValue >= 2147433647) {
            Class clazz = class$com$iplanet$jato$util$HtmlUtil == null ? (class$com$iplanet$jato$util$HtmlUtil = HtmlUtil.class$("com.iplanet.jato.util.HtmlUtil")) : class$com$iplanet$jato$util$HtmlUtil;
            synchronized (clazz) {
                while (uniqueValue >= 2147433647) {
                    uniqueValue = Math.abs(new Random().nextInt());
                }
            }
        }
        return ++uniqueValue;
    }

    public static String format(Date value, String pattern) {
        return HtmlUtil.format(value, 2, pattern, Locale.getDefault(), null, null);
    }

    public static String format(String value, String pattern) {
        return HtmlUtil.format(value, 1, pattern, Locale.getDefault(), null, null);
    }

    public static String format(Object value, int formatType, String pattern) {
        return HtmlUtil.format(value, formatType, pattern, Locale.getDefault(), null, null);
    }

    public static String format(Object value, int formatType, String pattern, Locale locale) {
        return HtmlUtil.format(value, formatType, pattern, locale, null, null);
    }

    public static String format(Object value, int formatType, String pattern, Locale locale, DecimalFormatSymbols decimalSymbols, DateFormatSymbols dateSymbols) {
        if (value == null) {
            return null;
        }
        String result = null;
        switch (formatType) {
            case 0: {
                result = value.toString();
                break;
            }
            case 1: {
                result = HtmlUtil.formatString(value.toString(), pattern);
                break;
            }
            case 2: {
                SimpleDateFormat sdf = dateSymbols != null ? new SimpleDateFormat(pattern, dateSymbols) : new SimpleDateFormat(pattern, locale);
                if (value instanceof Date) {
                    result = sdf.format((Date)value);
                    break;
                }
                try {
                    String dateString = value.toString();
                    Date date = DateFormat.getDateInstance().parse(dateString);
                    result = sdf.format(date);
                    break;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Cannot format non-Date value as a Date using default java.text.DateFormat (to prevent this error, only attempt to format Date objects): " + e);
                }
            }
            case 3: {
                if (value instanceof String && ((String)value).trim().length() == 0) {
                    return (String)value;
                }
                DecimalFormat cf = decimalSymbols != null ? new DecimalFormat(pattern, decimalSymbols) : (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
                cf.applyPattern(pattern);
                if (value instanceof Number) {
                    result = cf.format((Number)value);
                    break;
                }
                result = cf.format(new Double(value.toString()));
                break;
            }
            case 4: {
                if (value instanceof String && ((String)value).trim().length() == 0) {
                    return (String)value;
                }
                DecimalFormat df = decimalSymbols != null ? new DecimalFormat(pattern, decimalSymbols) : (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
                df.applyPattern(pattern);
                if (value instanceof Number) {
                    result = df.format((Number)value);
                    break;
                }
                result = df.format(new Double(value.toString()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format type (type=" + formatType + ", pattern=" + pattern + ")");
            }
        }
        return result;
    }

    public static String formatString(String value, String pattern) {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(pattern.length());
        int sourceIndex = 0;
        boolean inEscape = false;
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (c == '\\' && !inEscape) {
                inEscape = true;
            } else if (c == '?' && !inEscape) {
                if (sourceIndex < value.length()) {
                    buffer.append(value.charAt(sourceIndex++));
                }
            } else {
                buffer.append(c);
                inEscape = false;
            }
            ++i;
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LT = LT;
        GT = GT;
        AMP = AMP;
        QUOT = QUOT;
        ALPHANUMERIC_MASK_TOKEN = (char)63;
        NO_FORMAT_TYPE = 0;
        ALPHANUMERIC_FORMAT_TYPE = 1;
        DATETIME_FORMAT_TYPE = 2;
        CURRENCY_FORMAT_TYPE = 3;
        DECIMAL_FORMAT_TYPE = 4;
        uniqueValue = Math.abs(new Random().nextInt());
    }
}

