/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.util;

import com.iplanet.jato.Log;
import com.iplanet.jato.util.MethodSpec;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MethodRegistry {
    private MethodSpec[] specs;
    private MethodSpec[] exclusionaryMethodSpecs;
    private Map methods = Collections.synchronizedMap(new HashMap(200));

    public MethodRegistry(MethodSpec spec) {
        this.specs = new MethodSpec[]{spec};
    }

    public MethodRegistry(MethodSpec[] specs) {
        this.specs = specs;
    }

    public MethodRegistry(MethodSpec[] specs, MethodSpec[] exclusionaryMethodSpecs) {
        this.specs = specs;
        this.exclusionaryMethodSpecs = exclusionaryMethodSpecs;
    }

    public MethodSpec[] getMethodSpecs() {
        return this.specs;
    }

    public MethodSpec[] getExclusionaryMethodSpecs() {
        return this.exclusionaryMethodSpecs;
    }

    public void registerMethods(Class clazz) {
        if (this.methods.get(clazz) != null) {
            return;
        }
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        MethodSpec[] methodSpecs = this.getMethodSpecs();
        Method[] methodArray = clazz.getMethods();
        int i = 0;
        while (i < methodArray.length) {
            int j = 0;
            while (j < methodSpecs.length) {
                if (methodSpecs[j].matches(methodArray[i])) {
                    boolean excluded = false;
                    if (this.getExclusionaryMethodSpecs() != null) {
                        MethodSpec[] exclusionaryMethodSpecs = this.getExclusionaryMethodSpecs();
                        int k = 0;
                        while (k < exclusionaryMethodSpecs.length) {
                            if (exclusionaryMethodSpecs[k].matches(methodArray[i])) {
                                excluded = true;
                                break;
                            }
                            ++k;
                        }
                    }
                    if (!excluded) {
                        methodMap.put(methodArray[i].getName(), methodArray[i]);
                        Log.log(8, "Registered method \"" + clazz.getName() + "." + methodArray[i].getName() + "\"");
                    } else {
                        Log.log(8, "Excluded method \"" + clazz.getName() + "." + methodArray[i].getName() + "\" from registration");
                    }
                }
                ++j;
            }
            ++i;
        }
        this.methods.put(clazz, methodMap);
    }

    public Map getMethodMap(Class clazz) {
        return (Map)this.methods.get(clazz);
    }

    public Method getMethod(Class clazz, String name) {
        Map methodMap = this.getMethodMap(clazz);
        if (methodMap != null) {
            return (Method)methodMap.get(name);
        }
        return null;
    }
}

