// OpenDlg.cpp : implementation file
//
#include "stdafx.h"
#include "resource.h"
#include "OpenDlg.h"
#include "Osmo4.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// OpenDlg dialog


OpenDlg::OpenDlg(CWnd* pParent /*=NULL*/)
	: CDialog(OpenDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(OpenDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void OpenDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(OpenDlg)
	DDX_Control(pDX, IDC_FILELIST, m_URLs);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(OpenDlg, CDialog)
	//{{AFX_MSG_MAP(OpenDlg)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_BN_CLICKED(ID_SHORTCUTS, OnShortcuts)
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// OpenDlg message handlers

void OpenDlg::OnBrowse() 
{
	TCHAR BASED_CODE szFilter[] = _T("MPEG-4 file (*.mp4)|*.mp4|All files (*.*)|*.*||");
	CFileDialog fd(TRUE,NULL,NULL,OFN_HIDEREADONLY ,szFilter);

	if (fd.DoModal()!=IDOK) return;

	GetApp()->m_filename = fd.GetPathName();
	EndDialog(IDOK);
	
}

void OpenDlg::OnOK() 
{
	CString URL;
	char szUrl[5000];

	int sel = m_URLs.GetCurSel();
	if (sel == CB_ERR) {
		m_URLs.GetWindowText(URL);
	} else {
		m_URLs.GetLBText(sel, URL);
	}
	if (!URL.GetLength()) {
		EndDialog(IDCANCEL);
		return;
	}

	COsmo4 *app = GetApp();
	char *sOpt;
	char filename[1024];
	u32 i=0;

	app->m_filename = URL;

	CE_WideToChar((unsigned short *) (LPCTSTR) URL, szUrl);

	while (1) {
		sprintf(filename, "last_file_%d", i);
		sOpt = IF_GetKey(app->m_config, "General", filename);
		if (!sOpt) break;
		if (!strcmp(sOpt, szUrl)) {
			EndDialog(IDOK);
			return;
		}
		i++;
	}
	if (i<10) {
		IF_SetKey(app->m_config, "General", filename, szUrl);
	} else {
		IF_SetKey(app->m_config, "General", "last_file_10", szUrl);
	}
	CDialog::OnOK();
}

BOOL OpenDlg::OnInitDialog() 
{
	TCHAR w_str[5000];
	CDialog::OnInitDialog();
	
	COsmo4 *app = GetApp();
	char *sOpt;
	char filename[1024];
	u32 i=0;

	while (m_URLs.GetCount()) m_URLs.DeleteString(0);
	while (1) {
		sprintf(filename, "last_file_%d", i);
		sOpt = IF_GetKey(app->m_config, "General", filename);
		if (!sOpt) 
			break;

		CE_CharToWide(sOpt, w_str);
		m_URLs.AddString(w_str);
		i++;
	}

	SetFocus();
	return TRUE;  
}

void OpenDlg::OnShortcuts() 
{
	MessageBox(
		_T("Right Arrow: frame by frame\n")
		_T("Main button: stop playback\n")
		_T("First button: load URL\n")
		_T("Second button: Exit\n")
		, 
		_T("Osmo4 Shortcuts"));
}

void OpenDlg::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	u32 vk = IPAQ_TRANSLATE_KEY(nChar);
	switch (vk) {
	case VK_IPAQ_D:
		OnBrowse();
		return;
	}

	CDialog::OnKeyDown(nChar, nRepCnt, nFlags);
}
