// OptVideo.cpp : implementation file
//

#include "stdafx.h"
#include "Osmo4.h"
#include "OptVideo.h"

#include <gpac/m4_avhw.h>
#include <gpac/m4_graphics.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptVideo dialog


COptVideo::COptVideo(CWnd* pParent /*=NULL*/)
	: CDialog(COptVideo::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptVideo)
	//}}AFX_DATA_INIT
}


void COptVideo::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptVideo)
	DDX_Control(pDX, IDC_VIDEO_LIST, m_Videos);
	DDX_Control(pDX, IDC_GD_LIST, m_Graphics);
	DDX_Control(pDX, IDC_AA_LIST, m_Antialias);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptVideo, CDialog)
	//{{AFX_MSG_MAP(COptVideo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptVideo message handlers

BOOL COptVideo::OnInitDialog() 
{
	CDialog::OnInitDialog();

	COsmo4 *gpac = GetApp();
	char *sOpt;
	
	sOpt = IF_GetKey(gpac->m_config, "Rendering", "AntiAlias");
	while (m_Antialias.GetCount()) m_Antialias.DeleteString(0);

	m_Antialias.AddString(_T("None"));
	m_Antialias.AddString(_T("Text only"));
	m_Antialias.AddString(_T("Complete"));
	s32 select = 2;
	if (sOpt && !stricmp(sOpt, "Text")) select = 1;
	else if (sOpt && !stricmp(sOpt, "None")) select = 0;
	m_Antialias.SetCurSel(select);


	/*graphics driver enum*/
	while (m_Graphics.GetCount()) m_Graphics.DeleteString(0);
	sOpt = IF_GetKey(gpac->m_config, "Render2D", "GraphicsDriver");
	u32 count = PM_GetPluginsCount(gpac->m_plugins);
	void *ifce;
	select = 0;
	s32 to_sel = 0;
	for (u32 i=0; i<count; i++) {
		if (!PM_LoadInterface(gpac->m_plugins, i, M4_GRAPHICS_2D_INTERFACE, &ifce)) continue;
		if (sOpt && !stricmp(((BaseInterface *)ifce)->plugin_name, sOpt)) select = to_sel;

		TCHAR wzTmp[500];
		CE_CharToWide((char *) ((BaseInterface *)ifce)->plugin_name, wzTmp);
		m_Graphics.AddString(wzTmp);
		PM_ShutdownInterface(ifce);
		to_sel++;
	}
	m_Graphics.SetCurSel(select);


	/*video drivers enum*/
	while (m_Videos.GetCount()) m_Videos.DeleteString(0);
	sOpt = IF_GetKey(gpac->m_config, "Video", "DriverName");
	to_sel = 0;
	select = 0;
	for (i=0; i<count; i++) {
		if (!PM_LoadInterface(gpac->m_plugins, i, M4_VIDEO_OUTPUT_INTERFACE, &ifce)) continue;
		if (sOpt && !stricmp(((BaseInterface *)ifce)->plugin_name, sOpt)) select = to_sel;

		TCHAR wzTmp[500];
		CE_CharToWide((char *) ((BaseInterface *)ifce)->plugin_name, wzTmp);
		m_Videos.AddString(wzTmp);
		PM_ShutdownInterface(ifce);
		to_sel++;
	}
	m_Videos.SetCurSel(select);
	
	return TRUE;
	            
}

void COptVideo::SaveOptions()
{
	COsmo4 *gpac = GetApp();
	TCHAR wstr[50];
	char str[50];

	m_Graphics.GetWindowText(wstr, 50);
	CE_WideToChar(wstr, str);

	IF_SetKey(gpac->m_config, "Render2D", "GraphicsDriver", str);
	s32 sel = m_Antialias.GetCurSel();
	IF_SetKey(gpac->m_config, "Rendering", "AntiAlias", (sel==0) ? "None" : ( (sel==1) ? "Text" : "All"));

	m_Videos.GetWindowText(wstr, 50);
	CE_WideToChar(wstr, str);
	IF_SetKey(gpac->m_config, "Video", "DriverName", str);

}

