// Options.cpp : implementation file
//

#include "stdafx.h"
#include "Osmo4.h"
#include "Options.h"
#include <gx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptions dialog


COptions::COptions(CWnd* pParent /*=NULL*/)
	: CDialog(COptions::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptions)
	//}}AFX_DATA_INIT
}


void COptions::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptions)
	DDX_Control(pDX, IDC_OPT_SET_NAME, m_OptSetName);
	DDX_Control(pDX, IDC_SPIN_OPT, m_OptSelect);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptions, CDialog)
	//{{AFX_MSG_MAP(COptions)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_OPT, OnDeltaposSpinOpt)
	ON_BN_CLICKED(IDC_SAVEOPT, OnSaveopt)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptions message handlers


void COptions::OnDeltaposSpinOpt(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	
	if (pNMUpDown->iDelta>0) 
		m_curPos = (m_curPos + 1) % 9;
	else if (m_curPos)
		m_curPos = m_curPos - 1;
	else
		m_curPos = 8;

	HideAll();

	switch (m_curPos) {
	case 0:
		ShowGeneral();
		break;
	case 1:
		ShowSystems();
		break;
	case 2:
		ShowRender();
		break;
	case 3:
		ShowDecoder();
		break;
	case 4:
		ShowVideo();
		break;
	case 5:
		ShowAudio();
		break;
	case 6:
		ShowFont();
		break;
	case 7:
		ShowHTTP();
		break;
	case 8:
		ShowStream();
		break;
	}

	*pResult = 0;
}

void COptions::HideAll()
{
	m_general.ShowWindow(SW_HIDE);
	m_systems.ShowWindow(SW_HIDE);
	m_render.ShowWindow(SW_HIDE);
	m_audio.ShowWindow(SW_HIDE);
	m_video.ShowWindow(SW_HIDE);
	m_http.ShowWindow(SW_HIDE);
	m_font.ShowWindow(SW_HIDE);
	m_stream.ShowWindow(SW_HIDE);
	m_decoder.ShowWindow(SW_HIDE);
}


void COptions::ShowGeneral()
{
	m_OptSetName.SetWindowText(_T("General"));
	m_general.ShowWindow(SW_SHOW);
}

void COptions::ShowSystems()
{
	m_OptSetName.SetWindowText(_T("MPEG-4 Systems"));
	m_systems.ShowWindow(SW_SHOW);
}

void COptions::ShowRender()
{
	m_OptSetName.SetWindowText(_T("Rendering"));
	m_render.ShowWindow(SW_SHOW);
}

void COptions::ShowAudio()
{
	m_OptSetName.SetWindowText(_T("Audio"));
	m_audio.ShowWindow(SW_SHOW);
}

void COptions::ShowVideo()
{
	m_OptSetName.SetWindowText(_T("Video"));
	m_video.ShowWindow(SW_SHOW);
}

void COptions::ShowDecoder()
{
	m_OptSetName.SetWindowText(_T("Decoders"));
	m_decoder.ShowWindow(SW_SHOW);
}

void COptions::ShowHTTP()
{
	m_OptSetName.SetWindowText(_T("File Download"));
	m_http.ShowWindow(SW_SHOW);
}

void COptions::ShowFont()
{
	m_OptSetName.SetWindowText(_T("Text Engine"));
	m_font.ShowWindow(SW_SHOW);
}

void COptions::ShowStream()
{
	m_OptSetName.SetWindowText(_T("Real Time Streaming"));
	m_stream.ShowWindow(SW_SHOW);
}

BOOL COptions::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_general.Create(IDD_OPT_GEN, this);
	m_systems.Create(IDD_OPT_SYSTEMS, this);
	m_render.Create(IDD_OPT_RENDER, this);
	m_audio.Create(IDD_OPT_AUDIO, this);
	m_video.Create(IDD_OPT_VIDEO, this);
	m_http.Create(IDD_OPT_HTTP, this);
	m_font.Create(IDD_OPT_FONT, this);
	m_stream.Create(IDD_OPT_STREAM, this);
	m_decoder.Create(IDD_OPT_DECODER, this);

	m_OptSelect.SetBase(10);
	m_OptSelect.SetRange(0, 3);
	m_curPos = 0;

	HideAll();
	ShowGeneral();

	return TRUE;  
}

void COptions::OnSaveopt() 
{
	m_general.SaveOptions();
	m_systems.SaveOptions();
	m_render.SaveOptions();
	m_audio.SaveOptions();
	m_video.SaveOptions();
	m_http.SaveOptions();
	m_font.SaveOptions();
	m_stream.SaveOptions();
	m_decoder.SaveOptions();

	COsmo4 *gpac = GetApp();
	GXSuspend();
	M4T_SetOption(gpac->m_term, M4O_ReloadConfig, 1);
	GXResume();
}
