// Osmo4.h : main header file for the OSMO4 application
//

#if !defined(AFX_OSMO4_H__7E4A02D1_F77D_4E97_9E10_032054B29E33__INCLUDED_)
#define AFX_OSMO4_H__7E4A02D1_F77D_4E97_9E10_032054B29E33__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// COsmo4:
// See Osmo4.cpp for the implementation of this class
//

/*MPEG4 term*/
#include <gpac/m4_terminal.h>

enum {
	WM_SCENE_DONE = WM_USER + 1, 
	WM_NAVIGATE,
	WM_SETSIZE,
	WM_OPENURL,
	WM_STOPURL,
	WM_RESTARTURL,
	WM_CONSOLEMSG,
	WM_SETTIMING,
};


#define IPAQ_TRANSLATE_KEY(vk)	(LOWORD(vk) != 0x5b ? LOWORD(vk) : vk )
/*navigation pad keys*/
#define VK_IPAQ_LEFT		0x25
#define VK_IPAQ_UP			0x26
#define VK_IPAQ_RIGHT		0x27
#define VK_IPAQ_DOWN		0x28
/*"enter" key*/
#define VK_IPAQ_START		0x86
/*ipaq keys from left to right*/
#define VK_IPAQ_A			0xC1
#define VK_IPAQ_B			0xC2
#define VK_IPAQ_C			0xC3
#define VK_IPAQ_D			0xC4
/*record button*/
#define VK_IPAQ_E			0xC5

class COsmo4 : public CWinApp
{
public:
	COsmo4();

	MPEG4CLIENT m_term;
	LPPLUGMAN m_plugins;
	LPINIFILE m_config;
	M4User m_user;
	CString m_filename;
	Bool m_open, m_paused, m_url_changed;
	u32 max_duration;
	Bool can_seek;
	u32 current_time_ms;
	Float current_FPS;
	Bool step_mode;
	CString m_navigate_url;
	Bool m_Loop, m_AutoStart, m_NoConsole, m_CheckOpen, m_Fill, m_Timing;
	u32 m_prev_time;

	void Pause();

private:
	void SetOptions();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COsmo4)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Implementation

	//{{AFX_MSG(COsmo4)
	afx_msg void OnAppAbout();
	afx_msg void OnFileOpen();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

inline COsmo4 *GetApp() { return (COsmo4 *)AfxGetApp(); }

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft eMbedded Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_OSMO4_H__7E4A02D1_F77D_4E97_9E10_032054B29E33__INCLUDED_)
