#ifndef _GPACPANEL_H
#define _GPACPANEL_H


#include "safe_include.h" 
#include <gpac/m4_scenegraph.h>
#include <gpac/m4_render.h>

class V4StudioFrame;

class wxGPACPanel 
{

public :
    wxGPACPanel(V4StudioFrame *v4sf);
    ~wxGPACPanel();

	LPSCENERENDER GetSceneRenderer() { return m_pSr; }	

	void Update();

	void SetSize(u32 width, u32 height);

	M4User m_Client;
	LPSCENERENDER m_pSr;
	V4StudioFrame *m_pV4sf;

	s32 m_iDragging;
	u32 m_transformMode; // 0 Move, 1 Scale, 2 Rotate
	SFNode *picked;
	u32 dragX, dragY;

protected:
	bool GPACInit();

private:
	void TranslateCoordinates(long x, long y, int &sceneX, int &sceneY);
};

#endif
