/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003 
 *					All rights reserved
 *
 *  This file is part of GPAC / Scene Rendering sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */



#ifndef NODE_STACKS_H
#define NODE_STACKS_H

#include "grouping.h"

/*Anchor*/
#ifdef M4_DEF_Anchor

typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK2D
	Bool enabled;
	SensorHandler hdl;
} AnchorStack;
void R2D_InitAnchor(Render2D *sr, SFNode *node);
SensorHandler *r2d_anchor_get_handler(SFNode *n);
#endif


/*background2D*/
#ifdef M4_DEF_Background2D
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	Chain *surfaces_links;
	Bool first_render;

	Drawable *node;

	/*for image background*/
	TextureHandler txh;
} Background2DStack;
void R2D_InitBackground2D(Render2D *sr, SFNode *node);
void R2D_Background2DModified(SFNode *node);
DrawableContext *b2D_GetContext(Background2DStack *ptr, Chain *from_stack);
B_Background2D *b2D_getnode(Background2DStack *ptr);
#endif

/*Bitmap*/
#ifdef M4_DEF_Bitmap
typedef struct _bitmap_stack
{
	/*rendering node*/
	Drawable *graph;
} BitmapStack;
void R2D_InitBitmap(Render2D *sr, SFNode *node);
#endif


/*CompositeTexture2D*/
#ifdef M4_DEF_CompositeTexture2D
typedef struct _composite_2D
{
	TextureHandler txh;
	u32 width, height;
	/*the surface object handling the texture*/
	struct _visual_surface_2D *surf;
	Chain *sensors;
} Composite2DStack;
void R2D_InitCompositeTexture2D(Render2D *sr, SFNode *node);
TextureHandler *r2d_ct2D_get_texture(SFNode *node);

Bool CT2D_has_sensors(TextureHandler *txh);
DrawableContext *CT2D_FindNode(DrawableContext *ctx, Float x, Float y);
void Composite2D_ResetGraphics(TextureHandler *txh);
/* this is to use carefully: picks a node based on the PREVIOUS frame state (no traversing)*/
SFNode *CT2D_PickNode(DrawableContext *ctx, Float x, Float y);
#endif


/*DiscSensor*/
#ifdef M4_DEF_DiscSensor

typedef struct 
{
	SensorHandler hdl;
	Bool mouse_down;
	Double start_angle;
	Bool last_not_over;
	M4Matrix2D inv_init_matrix;
	SceneRenderer *compositor;
} DiscSensorStack;
void R2D_InitDiscSensor(Render2D *sr, SFNode *node);
SensorHandler *r2d_ds_get_handler(SFNode *n);
#endif

/*Form*/
#ifdef M4_DEF_Form
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK2D
	Chain *grouplist;
	M4Rect clip;
} FormStack;
void R2D_InitForm(Render2D *sr, SFNode *node);
#endif

/*layer2D*/
#ifdef M4_DEF_Layer2D
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK2D

	Chain *backs;
	Chain *views;
	Bool first;
	M4Rect clip;
} Layer2DStack;
void R2D_InitLayer2D(Render2D *sr, SFNode *node);
#endif

/*layout*/
#ifdef M4_DEF_Layout
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK2D
	
	Bool start_scroll, all_scroll_out, is_scrolling;
	Double start_time, pause_time;
	Chain *lines;
	M4Rect clip;
	Float scroll_offset, last_scroll, prev_rate;
	Float scroll_rate, scale_scroll;
} LayoutStack;
void R2D_InitLayout(Render2D *sr, SFNode *node);
void R2D_LayoutModified(SFNode *node);
#endif

/*matte texture*/
#ifdef M4_DEF_MatteTexture
typedef struct
{
	/*resulting texture*/
	TextureHandler txh;
	/*input texture*/
	TextureHandler *surf_a, *surf_b, *surf_alpha;
	/*current overwrite*/
	Bool overwrite;
} MatteTextureStack;
void R2D_InitMatteTexture(Render2D *sr, SFNode *node);
void R2D_MatteTextureModified(SFNode *node);
TextureHandler *r2d_matte_get_texture(SFNode *node);
#endif

/*orderedGroup*/
#ifdef M4_DEF_OrderedGroup
struct og_pos
{
	Float priority;
	u32 position;
};
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK2D

	struct og_pos *priorities;
	u32 count;
} OrderedGroupStack;
void R2D_InitOrderedGroup(Render2D *sr, SFNode *node);
#endif


/*planesensor2D*/
#ifdef M4_DEF_PlaneSensor2D

typedef struct 
{
	SensorHandler hdl;
	Bool mouse_down;
	SFVec2f start_drag;
	Bool last_not_over;
	M4Matrix2D init_matrix;
	SceneRenderer *compositor;
} PS2DStack;
void R2D_InitPlaneSensor2D(Render2D *sr, SFNode *node);
SensorHandler *r2d_ps2D_get_handler(SFNode *n);
#endif


/*proximitySensor2D*/
#ifdef M4_DEF_ProximitySensor2D

typedef struct 
{
	SensorHandler hdl;
	Double last_time;
	Bool in_area, just_entered, has_left;
	M4Matrix2D init_matrix;
	SceneRenderer *compositor;
} Prox2DStack;
void R2D_InitProximitySensor2D(Render2D *sr, SFNode *node);
SensorHandler *r2d_prox2D_get_handler(SFNode *n);
#endif

#ifdef M4_DEF_Switch
typedef struct
{
	s32 last_switch;
} SwitchStack;
void R2D_InitSwitch(Render2D *sr, SFNode *node);
#endif

typedef struct
{
	Render2D *sr;
	u32 last_mod_time;
} LinePropStack;
u32 R2D_LP_GetLastUpdateTime(SFNode *node);

/*text*/
#ifdef M4_DEF_Text
typedef struct
{
	Drawable *graph;
	Float ascent, descent;
	Chain *text_lines;
	M4Rect bounds;
} TextStack;
void R2D_InitText(Render2D *sr, SFNode *node);
#endif

/*touchsensor*/
#ifdef M4_DEF_TouchSensor

typedef struct 
{
	SensorHandler hdl;
	Bool mouse_down;
	SceneRenderer *compositor;
} TouchSensorStack;
void R2D_InitTouchSensor(Render2D *sr, SFNode *node);
SensorHandler *r2d_touch_sensor_get_handler(SFNode *n);
#endif

/*viewport*/
#ifdef M4_DEF_Viewport
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	Chain *stack_list;
	u32 last_sim_time;
	Bool first_time;
} ViewportStack;
void R2D_InitViewport(Render2D *sr, SFNode *node);
void vp_setup(ViewportStack *vps, RenderEffect *eff, M4Rect *surf_clip);
#endif

/*linear/radial gradient*/
#if defined(M4_DEF_LinearGradient) || defined(M4_DEF_RadialGradient)
typedef struct
{
	TextureHandler txh;
} GradientStack;
#endif


typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK2D
	M4Matrix2D mat;
	Bool is_identity;
} Transform2DStack;

#ifdef M4_DEF_LinearGradient
void R2D_InitLinearGradient(Render2D *sr, SFNode *node);
TextureHandler *r2d_lg_get_texture(SFNode *node);
#endif

#ifdef M4_DEF_RadialGradient
void R2D_InitRadialGradient(Render2D *sr, SFNode *node);
TextureHandler *r2d_rg_get_texture(SFNode *node);
#endif

#ifdef M4_DEF_ColorTransform
typedef struct
{
	SFNode *owner;
	struct scene_renderer *compositor;
	GROUPINGNODESTACK2D
	M4ColorMatrix cmat;
} ColorTransformStack;
void R2D_InitColorTransform(Render2D *sr, SFNode *node);
#endif

/*simple nodes without specific stacks extensions*/
#ifdef M4_DEF_Circle
void R2D_InitCircle(Render2D *sr, SFNode *node);
#endif

#ifdef M4_DEF_Curve2D
void R2D_InitCurve2D(Render2D *sr, SFNode *node);
#endif

#ifdef M4_DEF_Ellipse
void R2D_InitEllipse(Render2D *sr, SFNode *node);
#endif

#ifdef M4_DEF_Group
void R2D_InitGroup(Render2D *sr, SFNode *node);
#endif

#ifdef M4_DEF_IndexedFaceSet2D
void R2D_InitIFS2D(Render2D *sr, SFNode *node);
#endif

#ifdef M4_DEF_IndexedLineSet2D
void R2D_InitILS2D(Render2D *sr, SFNode *node);
#endif

#ifdef M4_DEF_PointSet2D
void R2D_InitPointSet2D(Render2D *sr, SFNode *node);
#endif

#ifdef M4_DEF_Rectangle
void R2D_InitRectangle(Render2D *sr, SFNode *node);
#endif

#ifdef M4_DEF_Shape
void R2D_InitShape(Render2D *sr, SFNode *node);
#endif

#ifdef M4_DEF_Transform2D
void R2D_InitTransform2D(Render2D *sr, SFNode *node);
#endif

#ifdef M4_DEF_TransformMatrix2D
void R2D_InitTransformMatrix2D(Render2D *sr, SFNode *node);
void TM2D_GetMatrix(SFNode *n, M4Matrix2D *mat);
#endif

#ifdef M4_DEF_PathLayout
void R2D_InitPathLayout(Render2D *sr, SFNode *node);
#endif


#endif


