/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003 
 *					All rights reserved
 *
 *  This file is part of GPAC / MEGP4 systems tools
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef _M4_AUTHOR_DEV_H_
#define _M4_AUTHOR_DEV_H_

#include <gpac/m4_author.h>

/*
		RTP -> SL packetization tool
	You should ONLY modify the SLHeader while packetizing, all the rest is private
	to the tool.
	Also note that AU start/end is automatically updated, therefore you should only
	set CTS-DTS-OCR-sequenceNumber (which is automatically incremented when spliting a payload)
	-padding-idle infos
	SL flags are computed on the fly, but you may wish to modify them in case of 
	packet drop/... at the encoder side

*/
typedef struct _rtpbuilder
{
	/*input packet sl header cfg. modify oly if needed*/
	SLHeader sl_header;

	/*
	
		PRIVATE _ DO NOT TOUCH
	*/
	
	/*hint payload type*/
	u32 hintType;
	/*packetization flags*/
	u32 flags;
	/*Path MTU size without 12-bytes RTP header*/
	u32 Path_MTU;

	/*must be a dynamic payload*/
	u8 payloadType;

	/*RTP header of current packet*/
	RTPHeader rtp_header;

	/*signals new packet*/
	void (*OnNewPacket)(void *cbk_obj, RTPHeader *header);
	/*callback on packet */
	void (*OnPacketDone)(void *cbk_obj, RTPHeader *header, 
		/*payload header if any (AMR, MPEG-4 SL, ...), may be NULL*/
		char *payl_hdr, u32 payl_hdr_size, 
		/*data payload (ptr to input data)*/
		char *payload, u32 payload_size);

	/*offset_from_orig indicates the offset in b ytes the payload is located
	from the original input buffer (for hint tracks mainly)*/
	void (*OnDataReference)(void *cbk_obj, u32 payload_size, u32 offset_from_orig);
	void *cbk_obj;


	/*set to 1 if first AU in RTP packet is RAP*/
	Bool RAP_Packet;
	
	/*rest of struct is for MPEG-4 Generic hinting */
	/*SL to RTP map*/
	RTPSLMap slMap;
	/*SL conf and state*/
	SLConfigDescriptor sl_config;

	/*set to 1 if firstSL in RTP packet*/
	Bool first_sl_in_rtp;
	Bool has_AU_header;
	/*current info writers*/
	BitStream *auheader, *payload;

	/*AU SN of last au*/
	u32 last_au_sn;

	/*info for the current packet*/
	u32 auh_size, bytesInPacket;
} M4RTPBuilder;


/*packetization routines*/
M4Err M4RTP_ProcessMPEG4(M4RTPBuilder *builder, char *data, u32 data_size, u8 IsAUEnd, u32 FullAUSize);
M4Err M4RTP_ProcessH263(M4RTPBuilder *builder, char *data, u32 data_size, u8 IsAUEnd, u32 FullAUSize);
M4Err M4RTP_ProcessAMR(M4RTPBuilder *builder, char *data, u32 data_size, u8 IsAUEnd, u32 FullAUSize);
M4Err M4RTP_ProcessMPEG12(M4RTPBuilder *builder, char *data, u32 data_size, u8 IsAUEnd, u32 FullAUSize);


/*RTP track hinter*/
typedef struct _tagM4Hinter
{
	u32 HinterFlags;

	Bool copy_media;
	u8 PayloadType, SampleIsRAP, hasBFrames;
	u32 Path_MTU, Last_RTP_SeqNum, base_offset_in_sample;
	M4File *file;
	u32 TrackNum, HintTrack, HintSample, RTPTime, TrackID, HintID;
	u32 OrigTimeScale;
	u32 Priority, Group;
	//hinter
	LPM4RTPBUILDER hinter;

	void (*OnProgress)(void *cbk_obj, u32 done, u32 total);
	void *cbk_obj;

	//stats
	u32 TotalSample, CurrentSample;
} MP4_RTPHinter;

#endif

