/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Utils {
    private static final Log LOG = LogFactory.getLog(Utils.class);
    private static final String NEW_LINE = "\n";

    public static void exit(int code, String msg, Exception e) throws RuntimeException {
        if (msg != null) {
            LOG.fatal((Object)msg);
        }
        System.exit(code);
        throw new RuntimeException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append(NEW_LINE);
            }
        }
        catch (FileNotFoundException e) {
            Utils.exit(1, "File not found", e);
        }
        catch (IOException e) {
            Utils.exit(1, e.getMessage(), e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
        return sb.toString();
    }
}

