/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserListGroupsRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.Group;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListGroupsForUserRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListGroupsForUserResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMUserListGroupsDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserListGroupsDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserListGroupsRequest) {
            UserListGroupsRequest req = (UserListGroupsRequest)request;
            LOG.debug((Object)("List user's group membership " + request));
            ListGroupsForUserRequest listGroupsForUserRequest = new ListGroupsForUserRequest();
            listGroupsForUserRequest.setUserName(req.getUserName());
            LOG.debug((Object)"List group membership");
            ListGroupsForUserResult result = this.getClient().listGroupsForUser(listGroupsForUserRequest);
            for (Group group : result.getGroups()) {
                LOG.info((Object)group.getArn());
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

