/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.build.ContainerFactory;
import htsjdk.samtools.cram.build.Cram2SamRecordFactory;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.build.Sam2CramRecordFactory;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.lossy.PreservationPolicy;
import htsjdk.samtools.cram.lossy.QualityScorePreservation;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceTracks;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringLineReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CRAMFileWriter
extends SAMFileWriterImpl {
    private static final int REF_SEQ_INDEX_NOT_INITED = -2;
    private static final int DEFAULT_RECORDS_PER_SLICE = 10000;
    private static final int DEFAULT_SLICES_PER_CONTAINER = 1;
    private static final Version cramVersion = CramVersions.CRAM_v2_1;
    private String fileName;
    private List<SAMRecord> samRecords = new ArrayList<SAMRecord>();
    private ContainerFactory containerFactory;
    protected int recordsPerSlice = 10000;
    protected int containerSize = this.recordsPerSlice * 1;
    private Sam2CramRecordFactory sam2CramRecordFactory;
    private OutputStream os;
    private ReferenceSource source;
    private int refSeqIndex = -2;
    private static Log log = Log.getInstance(CRAMFileWriter.class);
    private SAMFileHeader samFileHeader;
    private boolean preserveReadNames = true;
    private QualityScorePreservation preservation = null;
    private boolean captureAllTags = true;
    private Set<String> captureTags = new TreeSet<String>();
    private Set<String> ignoreTags = new TreeSet<String>();

    public CRAMFileWriter(OutputStream os, ReferenceSource source, SAMFileHeader samFileHeader, String fileName) {
        this.os = os;
        this.source = source;
        this.samFileHeader = samFileHeader;
        this.fileName = fileName;
        this.setSortOrder(samFileHeader.getSortOrder(), true);
        this.setHeader(samFileHeader);
        if (this.source == null) {
            this.source = new ReferenceSource(Defaults.REFERENCE_FASTA);
        }
        this.containerFactory = new ContainerFactory(samFileHeader, this.recordsPerSlice);
    }

    protected boolean shouldFlushContainer(SAMRecord nextRecord) {
        if (this.samRecords.size() >= this.containerSize) {
            return true;
        }
        return this.refSeqIndex != -2 && this.refSeqIndex != nextRecord.getReferenceIndex();
    }

    private static void updateTracks(List<SAMRecord> samRecords, ReferenceTracks tracks) {
        for (SAMRecord samRecord : samRecords) {
            if (samRecord.getAlignmentStart() == 0) continue;
            int refPos = samRecord.getAlignmentStart();
            int readPos = 0;
            for (CigarElement ce : samRecord.getCigar().getCigarElements()) {
                int i;
                if (ce.getOperator().consumesReferenceBases()) {
                    for (i = 0; i < ce.getLength(); ++i) {
                        tracks.addCoverage(refPos + i, 1);
                    }
                }
                switch (ce.getOperator()) {
                    case M: 
                    case X: 
                    case EQ: {
                        for (i = readPos; i < ce.getLength(); ++i) {
                            byte refBase;
                            byte readBase = samRecord.getReadBases()[readPos + i];
                            if (readBase == (refBase = tracks.baseAt(refPos + i))) continue;
                            tracks.addMismatches(refPos + i, 1);
                        }
                        break;
                    }
                }
                readPos += ce.getOperator().consumesReadBases() ? ce.getLength() : 0;
                refPos += ce.getOperator().consumesReferenceBases() ? ce.getLength() : 0;
            }
        }
    }

    protected void flushContainer() throws IllegalArgumentException, IllegalAccessException, IOException {
        byte[] refs = this.refSeqIndex == -1 ? new byte[]{} : this.source.getReferenceBases(this.samFileHeader.getSequence(this.refSeqIndex), true);
        int start = 0;
        int stop = 0;
        for (SAMRecord r : this.samRecords) {
            if (r.getAlignmentStart() == 0) continue;
            if (start == 0) {
                start = r.getAlignmentStart();
            }
            start = Math.min(r.getAlignmentStart(), start);
            stop = Math.max(r.getAlignmentEnd(), stop);
        }
        ReferenceTracks tracks = null;
        if (this.preservation != null && this.preservation.areReferenceTracksRequired()) {
            if (tracks == null || tracks.getSequenceId() != this.refSeqIndex) {
                tracks = new ReferenceTracks(this.refSeqIndex, refs);
            }
            tracks.ensureRange(start, stop - start + 1);
            CRAMFileWriter.updateTracks(this.samRecords, tracks);
        }
        ArrayList<CramCompressionRecord> cramRecords = new ArrayList<CramCompressionRecord>(this.samRecords.size());
        this.sam2CramRecordFactory = new Sam2CramRecordFactory(this.refSeqIndex, refs, this.samFileHeader);
        this.sam2CramRecordFactory.preserveReadNames = this.preserveReadNames;
        this.sam2CramRecordFactory.captureAllTags = this.captureAllTags;
        this.sam2CramRecordFactory.captureTags.addAll(this.captureTags);
        this.sam2CramRecordFactory.ignoreTags.addAll(this.ignoreTags);
        this.containerFactory.setPreserveReadNames(this.preserveReadNames);
        int index = 0;
        int prevAlStart = start;
        for (SAMRecord samRecord : this.samRecords) {
            CramCompressionRecord cramRecord = this.sam2CramRecordFactory.createCramRecord(samRecord);
            cramRecord.index = ++index;
            cramRecord.alignmentDelta = samRecord.getAlignmentStart() - prevAlStart;
            cramRecord.alignmentStart = samRecord.getAlignmentStart();
            prevAlStart = samRecord.getAlignmentStart();
            cramRecords.add(cramRecord);
            if (this.preservation != null) {
                this.preservation.addQualityScores(samRecord, cramRecord, tracks);
                continue;
            }
            cramRecord.setForcePreserveQualityScores(true);
        }
        if (this.sam2CramRecordFactory.getBaseCount() < 3L * this.sam2CramRecordFactory.getFeatureCount()) {
            log.warn("Abnormally high number of mismatches, possibly wrong reference.");
        }
        TreeMap primaryMateMap = new TreeMap();
        TreeMap<String, CramCompressionRecord> secondaryMateMap = new TreeMap<String, CramCompressionRecord>();
        for (CramCompressionRecord r : cramRecords) {
            if (!r.isMultiFragment()) {
                r.setDetached(true);
                r.setHasMateDownStream(false);
                r.recordsToNextFragment = -1;
                r.next = null;
                r.previous = null;
                continue;
            }
            String name = r.readName;
            TreeMap<String, CramCompressionRecord> mateMap = r.isSecondaryAlignment() ? secondaryMateMap : primaryMateMap;
            CramCompressionRecord mate = (CramCompressionRecord)mateMap.get(name);
            if (mate == null) {
                mateMap.put(name, r);
                continue;
            }
            mate.recordsToNextFragment = r.index - mate.index - 1;
            mate.next = r;
            r.previous = mate;
            r.previous.setHasMateDownStream(true);
            r.setHasMateDownStream(false);
            r.setDetached(false);
            r.previous.setDetached(false);
            mateMap.remove(name);
        }
        for (CramCompressionRecord r : primaryMateMap.values()) {
            r.setDetached(true);
            r.setHasMateDownStream(false);
            r.recordsToNextFragment = -1;
            r.next = null;
            r.previous = null;
        }
        for (CramCompressionRecord r : secondaryMateMap.values()) {
            r.setDetached(true);
            r.setHasMateDownStream(false);
            r.recordsToNextFragment = -1;
            r.next = null;
            r.previous = null;
        }
        Cram2SamRecordFactory f = new Cram2SamRecordFactory(this.samFileHeader);
        for (int i = 0; i < this.samRecords.size(); ++i) {
            String s1 = this.samRecords.get(i).getSAMString();
            SAMRecord r = f.create((CramCompressionRecord)cramRecords.get(i));
            String s2 = r.getSAMString();
            assert (s1.equals(s2));
        }
        Container container = this.containerFactory.buildContainer(cramRecords);
        for (Slice slice : container.slices) {
            slice.setRefMD5(refs);
        }
        CramIO.writeContainer(container, this.os);
        this.samRecords.clear();
    }

    @Override
    protected void writeAlignment(SAMRecord alignment) {
        if (this.shouldFlushContainer(alignment)) {
            try {
                this.flushContainer();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.updateReferenceContext(alignment.getReferenceIndex());
        this.samRecords.add(alignment);
    }

    private void updateReferenceContext(int samRecordReferenceIndex) {
        if (this.refSeqIndex == -2) {
            this.refSeqIndex = samRecordReferenceIndex;
        } else {
            int newRefSeqIndex = samRecordReferenceIndex;
            if (this.refSeqIndex != newRefSeqIndex) {
                this.refSeqIndex = newRefSeqIndex;
            }
        }
    }

    @Override
    protected void writeHeader(String textHeader) {
        SAMFileHeader header = new SAMTextHeaderCodec().decode(new StringLineReader(textHeader), this.fileName != null ? this.fileName : null);
        this.containerFactory = new ContainerFactory(header, this.recordsPerSlice);
        CramHeader cramHeader = new CramHeader(CRAMFileWriter.cramVersion.major, CRAMFileWriter.cramVersion.minor, this.fileName, header);
        try {
            CramIO.writeCramHeader(cramHeader, this.os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void finish() {
        try {
            if (!this.samRecords.isEmpty()) {
                this.flushContainer();
            }
            CramIO.issueZeroB_EOF_marker(this.os);
            this.os.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getFilename() {
        return this.fileName;
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public void setPreserveReadNames(boolean preserveReadNames) {
        this.preserveReadNames = preserveReadNames;
    }

    public List<PreservationPolicy> getPreservationPolicies() {
        if (this.preservation == null) {
            this.preservation = new QualityScorePreservation("*8");
        }
        return this.preservation.getPreservationPolicies();
    }

    public boolean isCaptureAllTags() {
        return this.captureAllTags;
    }

    public void setCaptureAllTags(boolean captureAllTags) {
        this.captureAllTags = captureAllTags;
    }

    public Set<String> getCaptureTags() {
        return this.captureTags;
    }

    public void setCaptureTags(Set<String> captureTags) {
        this.captureTags = captureTags;
    }

    public Set<String> getIgnoreTags() {
        return this.ignoreTags;
    }

    public void setIgnoreTags(Set<String> ignoreTags) {
        this.ignoreTags = ignoreTags;
    }
}

