/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.cram.common.IntHashMap;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.DataSeries;
import htsjdk.samtools.cram.encoding.DataSeriesMap;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.encoding.reader.DataReader;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.ReadTag;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;

public class DataReaderFactory {
    private boolean collectStats = false;

    public AbstractReader buildReader(AbstractReader reader, BitInputStream bis, Map<Integer, InputStream> inputMap, CompressionHeader h, int refId) throws IllegalArgumentException, IllegalAccessException {
        reader.captureReadNames = h.readNamesIncluded;
        reader.refId = refId;
        reader.AP_delta = h.AP_seriesDelta;
        for (Field f : reader.getClass().getFields()) {
            DataSeriesMap dsm;
            String name;
            if (f.isAnnotationPresent(DataSeries.class)) {
                DataSeries ds = f.getAnnotation(DataSeries.class);
                EncodingKey key = ds.key();
                DataSeriesType type = ds.type();
                if (h.eMap.get((Object)key) == null) {
                    System.err.println("Encoding not found for key: " + (Object)((Object)key));
                }
                f.set(reader, this.createReader(type, h.eMap.get((Object)key), bis, inputMap));
            }
            if (!f.isAnnotationPresent(DataSeriesMap.class) || !"TAG".equals(name = (dsm = f.getAnnotation(DataSeriesMap.class)).name())) continue;
            IntHashMap map = new IntHashMap();
            for (Integer key : h.tMap.keySet()) {
                EncodingParams params = h.tMap.get(key);
                DataReader tagReader = this.createReader(DataSeriesType.BYTE_ARRAY, params, bis, inputMap);
                map.put(key, tagReader);
            }
            f.set(reader, map);
        }
        reader.tagIdDictionary = h.dictionary;
        return reader;
    }

    private <T> DataReader<T> createReader(DataSeriesType valueType, EncodingParams params, BitInputStream bis, Map<Integer, InputStream> inputMap) {
        if (params.id == EncodingID.NULL) {
            return this.collectStats ? new DataReaderWithStats<T>(DataReaderFactory.buildNullReader(valueType)) : DataReaderFactory.buildNullReader(valueType);
        }
        EncodingFactory f = new EncodingFactory();
        Encoding encoding = f.createEncoding(valueType, params.id);
        if (encoding == null) {
            throw new RuntimeException("Encoding not found for value type " + valueType.name() + ", id=" + (Object)((Object)params.id));
        }
        encoding.fromByteArray(params.params);
        return this.collectStats ? new DataReaderWithStats(new DefaultDataReader(encoding.buildCodec(inputMap, null), bis)) : new DefaultDataReader(encoding.buildCodec(inputMap, null), bis);
    }

    private static <T> DataReader<T> buildNullReader(DataSeriesType valueType) {
        switch (valueType) {
            case BYTE: {
                return new SingleValueReader<Byte>(new Byte(0));
            }
            case INT: {
                return new SingleValueReader<Integer>(new Integer(0));
            }
            case LONG: {
                return new SingleValueReader<Long>(new Long(0L));
            }
            case BYTE_ARRAY: {
                return new SingleValueReader<byte[]>(new byte[0]);
            }
        }
        throw new RuntimeException("Unknown data type: " + valueType.name());
    }

    public Map<String, DataReaderWithStats> getStats(CramRecordReader reader) throws IllegalArgumentException, IllegalAccessException {
        TreeMap<String, DataReaderWithStats> map = new TreeMap<String, DataReaderWithStats>();
        if (!this.collectStats) {
            return map;
        }
        for (Field f : reader.getClass().getFields()) {
            DataSeriesMap dsm;
            String name;
            if (f.isAnnotationPresent(DataSeries.class)) {
                DataSeries ds = f.getAnnotation(DataSeries.class);
                EncodingKey key = ds.key();
                DataSeriesType type = ds.type();
                map.put(key.name(), (DataReaderWithStats)f.get(reader));
            }
            if (!f.isAnnotationPresent(DataSeriesMap.class) || !"TAG".equals(name = (dsm = f.getAnnotation(DataSeriesMap.class)).name())) continue;
            Map tagMap = (Map)f.get(reader);
            for (Integer key : tagMap.keySet()) {
                String tag = ReadTag.intToNameType4Bytes(key);
                map.put(tag, (DataReaderWithStats)tagMap.get(key));
            }
        }
        return map;
    }

    public static class DataReaderWithStats<T>
    implements DataReader<T> {
        public long nanos = 0L;
        DataReader<T> delegate;

        public DataReaderWithStats(DataReader<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T readData() throws IOException {
            long time = System.nanoTime();
            T value = this.delegate.readData();
            this.nanos += System.nanoTime() - time;
            return value;
        }

        @Override
        public T readDataArray(int len) throws IOException {
            long time = System.nanoTime();
            T value = this.delegate.readDataArray(len);
            this.nanos += System.nanoTime() - time;
            return value;
        }

        @Override
        public void skip() throws IOException {
            long time = System.nanoTime();
            this.delegate.skip();
            this.nanos += System.nanoTime() - time;
        }

        @Override
        public void readByteArrayInto(byte[] dest, int offset, int len) throws IOException {
            long time = System.nanoTime();
            this.delegate.readByteArrayInto(dest, offset, len);
            this.nanos += System.nanoTime() - time;
        }
    }

    private static class SingleValueReader<T>
    implements DataReader<T> {
        private T value;
        private Byte byteValue;

        public SingleValueReader(T value) {
            this.value = value;
            this.byteValue = value instanceof Byte ? (Byte)value : null;
        }

        @Override
        public T readData() throws IOException {
            return this.value;
        }

        @Override
        public T readDataArray(int len) {
            return this.value;
        }

        @Override
        public void skip() throws IOException {
        }

        @Override
        public void readByteArrayInto(byte[] dest, int offset, int len) throws IOException {
            if (this.byteValue != null) {
                for (int i = 0; i < len; ++i) {
                    dest[i + offset] = this.byteValue;
                }
            } else {
                throw new RuntimeException("Not a byte reader.");
            }
        }
    }

    private static class DefaultDataReader<T>
    implements DataReader<T> {
        private BitCodec<T> codec;
        private BitInputStream bis;

        public DefaultDataReader(BitCodec<T> codec, BitInputStream bis) {
            this.codec = codec;
            this.bis = bis;
        }

        @Override
        public T readData() throws IOException {
            return this.codec.read(this.bis);
        }

        @Override
        public T readDataArray(int len) throws IOException {
            return this.codec.read(this.bis, len);
        }

        @Override
        public void skip() throws IOException {
            this.codec.read(this.bis);
        }

        @Override
        public void readByteArrayInto(byte[] dest, int offset, int len) throws IOException {
            this.codec.readInto(this.bis, dest, offset, len);
        }
    }
}

