/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.lossy;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.encoding.read_features.BaseQualityScore;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.lossy.BaseCategory;
import htsjdk.samtools.cram.lossy.BaseCategoryType;
import htsjdk.samtools.cram.lossy.Binning;
import htsjdk.samtools.cram.lossy.PreservationPolicy;
import htsjdk.samtools.cram.lossy.QualityScoreTreatment;
import htsjdk.samtools.cram.lossy.ReadCategory;
import htsjdk.samtools.cram.ref.ReferenceTracks;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class QualityScorePreservation {
    private String specification;
    private List<PreservationPolicy> policyList;
    private static final Comparator<ReadFeature> readFeaturePositionComparator = new Comparator<ReadFeature>(){

        @Override
        public int compare(ReadFeature o1, ReadFeature o2) {
            return o1.getPosition() - o2.getPosition();
        }
    };

    public QualityScorePreservation(String specification) {
        this.specification = specification;
        this.policyList = QualityScorePreservation.parsePolicies(specification);
    }

    public List<PreservationPolicy> getPreservationPolicies() {
        return this.policyList;
    }

    private static final int readParam(LinkedList<Character> list) {
        int value = 0;
        while (!list.isEmpty() && Character.isDigit(list.getFirst().charValue())) {
            value = value * 10 + (list.removeFirst().charValue() - 48);
        }
        return value;
    }

    private static final QualityScoreTreatment readTreament(LinkedList<Character> list) {
        QualityScoreTreatment t;
        int param = QualityScorePreservation.readParam(list);
        switch (param) {
            case 0: {
                t = QualityScoreTreatment.drop();
                break;
            }
            case 40: {
                t = QualityScoreTreatment.preserve();
                break;
            }
            default: {
                t = QualityScoreTreatment.bin(param);
            }
        }
        return t;
    }

    public static final List<PreservationPolicy> parsePolicies(String spec) {
        ArrayList<PreservationPolicy> policyList = new ArrayList<PreservationPolicy>();
        for (String s : spec.split("-")) {
            if (s.length() == 0) continue;
            PreservationPolicy policy = QualityScorePreservation.parseSinglePolicy(s);
            policyList.add(policy);
        }
        Collections.sort(policyList, new Comparator<PreservationPolicy>(){

            @Override
            public int compare(PreservationPolicy o1, PreservationPolicy o2) {
                QualityScoreTreatment t1 = o1.treatment;
                QualityScoreTreatment t2 = o2.treatment;
                int result = t2.type.ordinal() - t1.type.ordinal();
                if (result != 0) {
                    return result;
                }
                return 0;
            }
        });
        return policyList;
    }

    private static final PreservationPolicy parseSinglePolicy(String spec) {
        PreservationPolicy p = new PreservationPolicy();
        LinkedList<Character> list = new LinkedList<Character>();
        for (char b : spec.toCharArray()) {
            list.add(Character.valueOf(b));
        }
        while (!list.isEmpty()) {
            char code = ((Character)list.removeFirst()).charValue();
            switch (code) {
                case 'R': {
                    p.baseCategories.add(BaseCategory.match());
                    p.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case 'N': {
                    p.baseCategories.add(BaseCategory.mismatch());
                    p.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case 'X': {
                    int coverage = QualityScorePreservation.readParam(list);
                    p.baseCategories.add(BaseCategory.lower_than_coverage(coverage));
                    break;
                }
                case 'D': {
                    p.baseCategories.add(BaseCategory.flanking_deletion());
                    p.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case 'M': {
                    int score = QualityScorePreservation.readParam(list);
                    p.readCategory = ReadCategory.higher_than_mapping_score(score);
                    break;
                }
                case 'm': {
                    int score = QualityScorePreservation.readParam(list);
                    p.readCategory = ReadCategory.lower_than_mapping_score(score);
                    break;
                }
                case 'U': {
                    p.readCategory = ReadCategory.unplaced();
                    p.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case 'P': {
                    int mismatches = QualityScorePreservation.readParam(list);
                    p.baseCategories.add(BaseCategory.pileup(mismatches));
                    p.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case 'I': {
                    p.baseCategories.add(BaseCategory.insertion());
                    p.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case '_': {
                    p.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case '*': {
                    p.readCategory = ReadCategory.all();
                    p.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                default: {
                    throw new RuntimeException("Uknown read or base category: " + code);
                }
            }
            if (p.treatment != null) continue;
            p.treatment = QualityScoreTreatment.preserve();
        }
        return p;
    }

    public static final void applyBinning(byte[] scores) {
        for (int i = 0; i < scores.length; ++i) {
            scores[i] = Binning.Illumina_binning_matrix[scores[i]];
        }
    }

    public static final byte applyTreatment(byte score, QualityScoreTreatment t) {
        switch (t.type) {
            case BIN: {
                return Binning.Illumina_binning_matrix[score];
            }
            case DROP: {
                return -1;
            }
            case PRESERVE: {
                return score;
            }
        }
        throw new RuntimeException("Unknown quality score treatment type: " + t.type.name());
    }

    public void addQualityScores(SAMRecord s, CramCompressionRecord r, ReferenceTracks t) {
        if (s.getBaseQualities() == SAMRecord.NULL_QUALS) {
            r.qualityScores = SAMRecord.NULL_QUALS;
            r.setForcePreserveQualityScores(false);
            return;
        }
        byte[] scores = new byte[s.getReadLength()];
        Arrays.fill(scores, (byte)-1);
        for (PreservationPolicy p : this.policyList) {
            QualityScorePreservation.addQS(s, r, scores, t, p);
        }
        if (!r.isForcePreserveQualityScores()) {
            for (int i = 0; i < scores.length; ++i) {
                if (scores[i] <= -1) continue;
                if (r.readFeatures == null) {
                    r.readFeatures = new LinkedList<ReadFeature>();
                }
                r.readFeatures.add(new BaseQualityScore(i + 1, scores[i]));
            }
            if (r.readFeatures != null) {
                Collections.sort(r.readFeatures, readFeaturePositionComparator);
            }
        }
        r.qualityScores = scores;
    }

    public boolean areReferenceTracksRequired() {
        if (this.policyList == null || this.policyList.isEmpty()) {
            return false;
        }
        for (PreservationPolicy p : this.policyList) {
            if (p.baseCategories == null || p.baseCategories.isEmpty()) continue;
            for (BaseCategory c : p.baseCategories) {
                switch (c.type) {
                    case LOWER_COVERAGE: 
                    case PILEUP: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static final void addQS(SAMRecord s, CramCompressionRecord r, byte[] scores, ReferenceTracks t, PreservationPolicy p) {
        int alSpan = s.getAlignmentEnd() - s.getAlignmentStart();
        byte[] qs = s.getBaseQualities();
        if (p.readCategory != null) {
            boolean properRead = false;
            switch (p.readCategory.type) {
                case ALL: {
                    properRead = true;
                    break;
                }
                case UNPLACED: {
                    properRead = s.getReadUnmappedFlag();
                    break;
                }
                case LOWER_MAPPING_SCORE: {
                    properRead = s.getMappingQuality() < p.readCategory.param;
                    break;
                }
                case HIGHER_MAPPING_SCORE: {
                    properRead = s.getMappingQuality() > p.readCategory.param;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown read category: " + p.readCategory.type.name());
                }
            }
            if (!properRead) {
                return;
            }
        }
        if (p.baseCategories == null || p.baseCategories.isEmpty()) {
            switch (p.treatment.type) {
                case BIN: {
                    if (r.qualityScores == null) {
                        r.qualityScores = s.getBaseQualities();
                    }
                    System.arraycopy(s.getBaseQualities(), 0, scores, 0, scores.length);
                    QualityScorePreservation.applyBinning(scores);
                    r.setForcePreserveQualityScores(true);
                    break;
                }
                case PRESERVE: {
                    System.arraycopy(s.getBaseQualities(), 0, scores, 0, scores.length);
                    r.setForcePreserveQualityScores(true);
                    break;
                }
                case DROP: {
                    r.qualityScores = null;
                    r.setForcePreserveQualityScores(false);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown quality score treatment type: " + p.treatment.type.name());
                }
            }
            return;
        }
        boolean[] mask = new boolean[qs.length];
        int alStart = s.getAlignmentStart();
        if (alStart == 0) {
            return;
        }
        t.ensureRange(alStart, alSpan);
        block24: for (BaseCategory c : p.baseCategories) {
            switch (c.type) {
                case FLANKING_DELETION: {
                    int pos = 0;
                    for (CigarElement ce : s.getCigar().getCigarElements()) {
                        if (ce.getOperator() == CigarOperator.D) {
                            mask[pos] = true;
                            if (pos + 1 < mask.length) {
                                mask[pos + 1] = true;
                            }
                        }
                        pos += ce.getOperator().consumesReadBases() ? ce.getLength() : 0;
                    }
                    continue block24;
                }
                case MATCH: 
                case MISMATCH: {
                    int i;
                    int pos = 0;
                    int refPos = s.getAlignmentStart();
                    for (CigarElement ce : s.getCigar().getCigarElements()) {
                        if (ce.getOperator().consumesReadBases()) {
                            for (i = 0; i < ce.getLength(); ++i) {
                                boolean match = s.getReadBases()[pos + i] == t.baseAt(refPos + i);
                                mask[pos + i] = c.type == BaseCategoryType.MATCH && match || c.type == BaseCategoryType.MISMATCH && !match;
                            }
                            pos += ce.getLength();
                        }
                        refPos += ce.getOperator().consumesReferenceBases() ? ce.getLength() : 0;
                    }
                    continue block24;
                }
                case INSERTION: {
                    int i;
                    int pos = 0;
                    for (CigarElement ce : s.getCigar().getCigarElements()) {
                        switch (ce.getOperator()) {
                            case I: {
                                for (i = 0; i < ce.getLength(); ++i) {
                                    mask[pos + i] = true;
                                }
                                break;
                            }
                        }
                        pos += ce.getOperator().consumesReadBases() ? ce.getLength() : 0;
                    }
                    continue block24;
                }
                case LOWER_COVERAGE: {
                    int i;
                    int pos = 1;
                    int refPos = s.getAlignmentStart();
                    for (CigarElement ce : s.getCigar().getCigarElements()) {
                        switch (ce.getOperator()) {
                            case M: 
                            case EQ: 
                            case X: {
                                for (i = 0; i < ce.getLength(); ++i) {
                                    mask[pos + i - 1] = t.coverageAt(refPos + i) < c.param;
                                }
                                break;
                            }
                        }
                        pos += ce.getOperator().consumesReadBases() ? ce.getLength() : 0;
                        refPos += ce.getOperator().consumesReferenceBases() ? ce.getLength() : 0;
                    }
                    continue block24;
                }
                case PILEUP: {
                    for (int i = 0; i < qs.length; ++i) {
                        if (t.mismatchesAt(alStart + i) <= c.param) continue;
                        mask[i] = true;
                    }
                    continue block24;
                }
            }
        }
        int maskedCount = 0;
        for (int i = 0; i < mask.length; ++i) {
            if (!mask[i]) continue;
            scores[i] = QualityScorePreservation.applyTreatment(qs[i], p.treatment);
            ++maskedCount;
        }
        if (maskedCount > s.getReadLength() / 2) {
            r.setForcePreserveQualityScores(true);
        }
    }
}

