/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.mask;

import htsjdk.samtools.cram.mask.PositionMask;
import java.util.Arrays;

public class ArrayPositionMask
implements PositionMask {
    private int[] array;
    public static final PositionMask EMPTY_INSTANCE = new ArrayPositionMask(new int[0]);

    public ArrayPositionMask(int[] array) {
        if (array == null) {
            throw new NullPointerException("Expecting a non-null array.");
        }
        this.array = array;
        Arrays.sort(array);
    }

    @Override
    public boolean isMasked(int position) {
        return Arrays.binarySearch(this.array, position) > -1;
    }

    @Override
    public int[] getMaskedPositions() {
        return this.array;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public int getMaskedCount() {
        return this.array.length;
    }

    @Override
    public int getMinMaskedPosition() {
        return this.array.length > 0 ? this.array[0] : -1;
    }

    @Override
    public int getMaxMaskedPosition() {
        return this.array.length > 0 ? this.array[this.array.length - 1] : -1;
    }

    @Override
    public byte[] toByteArrayUsing(byte mask, byte nonMask) {
        byte[] ba = new byte[this.array[this.array.length - 1]];
        Arrays.fill(ba, nonMask);
        for (int pos : this.array) {
            ba[pos - 1] = mask;
        }
        return ba;
    }
}

