/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.NumberAssert;
import org.fest.assertions.PrimitiveAssert;

public class LongAssert
extends PrimitiveAssert
implements NumberAssert {
    private static final long ZERO = 0L;
    private final long actual;

    protected LongAssert(long actual) {
        this.actual = actual;
    }

    public LongAssert as(String description) {
        this.description(description);
        return this;
    }

    public LongAssert describedAs(String description) {
        return this.as(description);
    }

    public LongAssert as(Description description) {
        this.description(description);
        return this;
    }

    public LongAssert describedAs(Description description) {
        return this.as(description);
    }

    public LongAssert isEqualTo(long expected) {
        if (this.actual == expected) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public LongAssert isNotEqualTo(long other) {
        if (this.actual != other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, other));
    }

    public LongAssert isGreaterThan(long other) {
        if (this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public LongAssert isLessThan(long other) {
        if (this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public LongAssert isGreaterThanOrEqualTo(long other) {
        if (this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public LongAssert isLessThanOrEqualTo(long other) {
        if (this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    public LongAssert isZero() {
        return this.isEqualTo(0L);
    }

    public LongAssert isPositive() {
        return this.isGreaterThan(0L);
    }

    public LongAssert isNegative() {
        return this.isLessThan(0L);
    }

    public LongAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

