/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ClassReferenceInitializer
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter missingClassWarningPrinter;
    private final WarningPrinter missingProgramMemberWarningPrinter;
    private final WarningPrinter missingLibraryMemberWarningPrinter;
    private final WarningPrinter dependencyWarningPrinter;
    private final MemberFinder memberFinder = new MemberFinder();

    public ClassReferenceInitializer(ClassPool classPool, ClassPool classPool2) {
        this(classPool, classPool2, null, null, null, null);
    }

    public ClassReferenceInitializer(ClassPool classPool, ClassPool classPool2, WarningPrinter warningPrinter, WarningPrinter warningPrinter2, WarningPrinter warningPrinter3, WarningPrinter warningPrinter4) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.missingClassWarningPrinter = warningPrinter;
        this.missingProgramMemberWarningPrinter = warningPrinter2;
        this.missingLibraryMemberWarningPrinter = warningPrinter3;
        this.dependencyWarningPrinter = warningPrinter4;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.fieldsAccept(this);
        libraryClass.methodsAccept(this);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        programField.referencedClass = this.findReferencedClass(programClass, programField.getDescriptor(programClass));
        programField.attributesAccept(programClass, this);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.referencedClasses = this.findReferencedClasses(programClass, programMethod.getDescriptor(programClass));
        programMethod.attributesAccept(programClass, this);
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        libraryField.referencedClass = this.findReferencedClass(libraryClass, libraryField.getDescriptor(libraryClass));
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        libraryMethod.referencedClasses = this.findReferencedClasses(libraryClass, libraryMethod.getDescriptor(libraryClass));
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.javaLangStringClass = this.findClass(clazz, "java/lang/String");
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        invokeDynamicConstant.referencedClasses = this.findReferencedClasses(clazz, invokeDynamicConstant.getType(clazz));
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        methodHandleConstant.javaLangInvokeMethodHandleClass = this.findClass(clazz, "java/lang/invoke/MethodHandle");
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        Clazz clazz2;
        String string = refConstant.getClassName(clazz);
        if (ClassUtil.isInternalArrayType(string)) {
            string = "java/lang/Object";
        }
        if ((clazz2 = this.findClass(clazz, string)) != null) {
            String string2 = refConstant.getName(clazz);
            String string3 = refConstant.getType(clazz);
            boolean bl = refConstant.getTag() == 9;
            refConstant.referencedMember = this.memberFinder.findMember(clazz, clazz2, string2, string3, bl);
            refConstant.referencedClass = this.memberFinder.correspondingClass();
            if (refConstant.referencedMember == null) {
                WarningPrinter warningPrinter;
                boolean bl2 = clazz2 instanceof ProgramClass;
                WarningPrinter warningPrinter2 = warningPrinter = bl2 ? this.missingProgramMemberWarningPrinter : this.missingLibraryMemberWarningPrinter;
                if (warningPrinter != null) {
                    warningPrinter.print(clazz.getName(), string, "Warning: " + ClassUtil.externalClassName(clazz.getName()) + ": can't find referenced " + (bl ? "field '" + ClassUtil.externalFullFieldDescription(0, string2, string3) : "method '" + ClassUtil.externalFullMethodDescription(string, 0, string2, string3)) + "' in " + (bl2 ? "program" : "library") + " class " + ClassUtil.externalClassName(string));
                }
            }
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClass = this.findClass(clazz, ClassUtil.internalClassNameFromClassType(classConstant.getName(clazz)));
        classConstant.javaLangClassClass = this.findClass(clazz, "java/lang/Class");
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        methodTypeConstant.javaLangInvokeMethodTypeClass = this.findClass(clazz, "java/lang/invoke/MethodType");
        methodTypeConstant.referencedClasses = this.findReferencedClasses(clazz, methodTypeConstant.getType(clazz));
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        String string = enclosingMethodAttribute.getClassName(clazz);
        enclosingMethodAttribute.referencedClass = this.findClass(clazz, string);
        if (enclosingMethodAttribute.referencedClass != null && enclosingMethodAttribute.u2nameAndTypeIndex != 0) {
            String string2 = enclosingMethodAttribute.getName(clazz);
            String string3 = enclosingMethodAttribute.getType(clazz);
            enclosingMethodAttribute.referencedMethod = enclosingMethodAttribute.referencedClass.findMethod(string2, string3);
            if (enclosingMethodAttribute.referencedMethod == null && this.missingProgramMemberWarningPrinter != null) {
                String string4 = clazz.getName();
                this.missingProgramMemberWarningPrinter.print(string4, string, "Warning: " + ClassUtil.externalClassName(string4) + ": can't find enclosing method '" + ClassUtil.externalFullMethodDescription(string, 0, string2, string3) + "' in program class " + ClassUtil.externalClassName(string));
            }
        }
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        signatureAttribute.referencedClasses = this.findReferencedClasses(clazz, signatureAttribute.getSignature(clazz));
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.referencedClass = this.findReferencedClass(clazz, localVariableInfo.getDescriptor(clazz));
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.referencedClasses = this.findReferencedClasses(clazz, localVariableTypeInfo.getSignature(clazz));
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.referencedClasses = this.findReferencedClasses(clazz, annotation.getType(clazz));
        annotation.elementValuesAccept(clazz, this);
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.initializeElementValue(clazz, annotation, constantElementValue);
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.initializeElementValue(clazz, annotation, enumConstantElementValue);
        enumConstantElementValue.referencedClasses = this.findReferencedClasses(clazz, enumConstantElementValue.getTypeName(clazz));
    }

    @Override
    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        this.initializeElementValue(clazz, annotation, classElementValue);
        classElementValue.referencedClasses = this.findReferencedClasses(clazz, classElementValue.getClassName(clazz));
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.initializeElementValue(clazz, annotation, annotationElementValue);
        annotationElementValue.annotationAccept(clazz, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.initializeElementValue(clazz, annotation, arrayElementValue);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private void initializeElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        if (annotation != null && annotation.referencedClasses != null && elementValue.u2elementNameIndex != 0) {
            Clazz clazz2;
            String string = elementValue.getMethodName(clazz);
            elementValue.referencedClass = clazz2 = annotation.referencedClasses[0];
            elementValue.referencedMethod = clazz2.findMethod(string, null);
        }
    }

    private Clazz findReferencedClass(Clazz clazz, String string) {
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(string);
        descriptorClassEnumeration.nextFluff();
        if (descriptorClassEnumeration.hasMoreClassNames()) {
            return this.findClass(clazz, descriptorClassEnumeration.nextClassName());
        }
        return null;
    }

    private Clazz[] findReferencedClasses(Clazz clazz, String string) {
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(string);
        int n = descriptorClassEnumeration.classCount();
        if (n > 0) {
            Clazz[] clazzArray = new Clazz[n];
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string2 = descriptorClassEnumeration.nextFluff();
                String string3 = descriptorClassEnumeration.nextClassName();
                Clazz clazz2 = this.findClass(clazz, string3);
                if (clazz2 == null) continue;
                clazzArray[i] = clazz2;
                bl = true;
            }
            if (bl) {
                return clazzArray;
            }
        }
        return null;
    }

    private Clazz findClass(Clazz clazz, String string) {
        Clazz clazz2;
        if (ClassUtil.isInternalArrayType(string)) {
            if (!ClassUtil.isInternalClassType(string)) {
                return null;
            }
            string = ClassUtil.internalClassNameFromClassType(string);
        }
        if ((clazz2 = this.programClassPool.getClass(string)) == null) {
            clazz2 = this.libraryClassPool.getClass(string);
            if (clazz2 == null && this.missingClassWarningPrinter != null) {
                String string2 = clazz.getName();
                this.missingClassWarningPrinter.print(string2, string, "Warning: " + ClassUtil.externalClassName(string2) + ": can't find referenced class " + ClassUtil.externalClassName(string));
            }
        } else if (this.dependencyWarningPrinter != null) {
            String string3 = clazz.getName();
            this.dependencyWarningPrinter.print(string3, string, "Warning: library class " + ClassUtil.externalClassName(string3) + " depends on program class " + ClassUtil.externalClassName(string));
        }
        return clazz2;
    }
}

