/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HAClusterManagerImpl
extends ClusterManagerImpl
implements ClusterManager {
    private static boolean IGNORE_HADB_ERRORS = true;
    private String localBrokerId = null;
    private int VERSION = 40;
    private haStore store = new jdbcStore();
    UID localSessionUID = null;

    public boolean isHA() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return true;
    }

    public void reloadConfig() throws BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String[] stringArray = new String[]{"imq.cluster.url"};
        this.config.reloadProps(Globals.getConfigName(), stringArray, false);
    }

    protected Map getAllBrokers() throws BrokerException {
        return new HAMap();
    }

    public String initialize(MQAddress mQAddress) throws BrokerException {
        this.logger.log(4, "initializingCluster at " + mQAddress + " with " + this.store);
        this.localBrokerId = Globals.getBrokerID();
        if (this.localBrokerId == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Broker can not have a null brokerID"));
        }
        String string = this.config.getProperty("imq.cluster.masterbroker");
        if (string != null) {
            throw new UnsupportedOperationException("MasterBroker not allowed w/ HA");
        }
        super.initialize(mQAddress);
        return this.localBrokerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set parseBrokerList() throws MalformedURLException {
        String string = this.config.getProperty("imq.cluster.brokerlist");
        String string2 = this.config.getProperty("imq.cluster.brokerlist.manual");
        if (string != null) {
            this.logger.log(8, "B1192", "imq.cluster.brokerlist");
        }
        if (string2 != null) {
            this.logger.log(8, "B1192", "imq.cluster.brokerlist.manual");
        }
        HashSet<MQAddress> hashSet = new HashSet<MQAddress>();
        Map map = this.allBrokers;
        synchronized (map) {
            Iterator iterator = this.allBrokers.values().iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)v;
                if (hAClusteredBroker.isLocalBroker()) continue;
                hashSet.add(hAClusteredBroker.getBrokerURL());
            }
        }
        return hashSet;
    }

    protected String addBroker(MQAddress mQAddress, boolean bl, boolean bl2, UID uID) throws NoSuchElementException, BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String string = null;
        ClusteredBroker clusteredBroker = null;
        if (bl) {
            string = this.localBrokerId;
            clusteredBroker = this.getBroker(string);
            if (clusteredBroker == null) {
                clusteredBroker = new HAClusteredBrokerImpl(string, mQAddress, this.VERSION, BrokerState.INITIALIZING, uID);
                ((HAClusteredBrokerImpl)clusteredBroker).setIsLocal(true);
            } else {
                ((HAClusteredBrokerImpl)clusteredBroker).setIsLocal(true);
                if (clusteredBroker.getState() == BrokerState.FAILOVER_PENDING || clusteredBroker.getState() == BrokerState.FAILOVER_STARTED || clusteredBroker.getState() == BrokerState.FAILOVER_FAILED || clusteredBroker.getState() == BrokerState.FAILOVER_COMPLETE) {
                    this.logger.log(4, "Broker needs to update sessionUID" + clusteredBroker.getState());
                    try {
                        ((HAClusteredBrokerImpl)clusteredBroker).setStoreSessionUID(uID);
                    }
                    catch (Exception exception) {
                        this.logger.logStack(8, "Internal Error: ", exception);
                    }
                } else {
                    this.logger.log(4, "broker can keep old sessionUID" + clusteredBroker.getState());
                }
            }
            ((HAClusteredBrokerImpl)clusteredBroker).resetTakeoverBroker();
            this.allBrokers.put(string, clusteredBroker);
        } else {
            string = this.lookupBrokerID(mQAddress);
            if (string != null) {
                clusteredBroker = this.getBroker(string);
            }
        }
        if (uID != null) {
            ((HAClusteredBrokerImpl)clusteredBroker).setBrokerSessionUID(uID);
        }
        if (string == null) {
            throw new NoSuchElementException(Globals.getBrokerResources().getKString("B3100", "Unable to access broker " + string + " it is not available in the persistent store"));
        }
        if (bl) {
            clusteredBroker.setStatus(257, null);
        } else {
            this.updateBroker(clusteredBroker);
        }
        this.brokerChanged(ClusterManagerImpl.ClusterReason.ADDED, clusteredBroker.getBrokerName(), null, clusteredBroker, clusteredBroker.getBrokerSessionUID(), null);
        if (bl) {
            this.logger.log(8, "B1193", (Object)new Long(((HAClusteredBrokerImpl)clusteredBroker).getStoreSessionUID().longValue()), new Long(((HAClusteredBrokerImpl)clusteredBroker).getBrokerSessionUID().longValue()));
        }
        return string;
    }

    public ClusteredBroker updateBroker(ClusteredBroker clusteredBroker) {
        HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)((HAMap)this.allBrokers).get(clusteredBroker.getBrokerName(), true);
        return hAClusteredBroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateBroker(String string, Object object) throws NoSuchElementException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        ClusteredBroker clusteredBroker = this.getBroker(string);
        if (clusteredBroker == null) {
            throw new NoSuchElementException("Unknown brokerid " + string);
        }
        HAClusterManagerImpl hAClusterManagerImpl = this;
        synchronized (hAClusterManagerImpl) {
            clusteredBroker.setStatus(BrokerStatus.setBrokerLinkIsDown(clusteredBroker.getStatus()), object);
        }
    }

    public String lookupStoreSessionUID(UID uID) {
        try {
            ((HAMap)this.allBrokers).updateHAMap();
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(16, "Internal error, could not load db", brokerException);
        }
        Iterator iterator = this.getKnownBrokers();
        while (iterator.hasNext()) {
            HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)iterator.next();
            if (hAClusteredBroker.getStoreSessionUID() == null || !hAClusteredBroker.getStoreSessionUID().equals(uID)) continue;
            try {
                String string = hAClusteredBroker.getTakeoverBroker();
                if (string == null || string.length() == 0) {
                    return hAClusteredBroker.getBrokerName();
                }
                return string;
            }
            catch (Exception exception) {
                this.logger.logStack(32, "Internal error ", exception);
                return null;
            }
        }
        return null;
    }

    public String lookupBrokerID(MQAddress mQAddress) {
        try {
            ((HAMap)this.allBrokers).updateHAMap();
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(16, "Internal error, could not load db", brokerException);
        }
        return super.lookupBrokerID(mQAddress);
    }

    public int getConfigBrokerCount() {
        return super.getKnownBrokerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getKnownBrokers() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        HashSet hashSet = null;
        try {
            ((HAMap)this.allBrokers).updateHAMap(true);
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(16, "Internal error, could not load db", brokerException);
        }
        Map map = this.allBrokers;
        synchronized (map) {
            hashSet = new HashSet(this.allBrokers.values());
        }
        return hashSet.iterator();
    }

    public Iterator getConfigBrokers() {
        return this.getKnownBrokers();
    }

    protected void masterBrokerChanged(String string) {
        throw new UnsupportedOperationException("Can not use/set/ change masterbroker");
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
        if (string.equals("imq.cluster.masterbroker")) {
            throw new PropertyUpdateException(Globals.getBrokerResources().getKString("B4250"));
        }
        super.validate(string, string2);
    }

    public ClusteredBroker getLocalBroker() {
        return super.getLocalBroker();
    }

    public UID getStoreSessionUID() {
        if (this.localSessionUID == null) {
            this.localSessionUID = ((HAClusteredBroker)this.getLocalBroker()).getStoreSessionUID();
        }
        return this.localSessionUID;
    }

    public ClusteredBroker getBroker(String string) {
        ClusteredBroker clusteredBroker = super.getBroker(string);
        if (clusteredBroker != null) {
            return clusteredBroker;
        }
        try {
            ((HAMap)this.allBrokers).updateHAMap(true);
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(16, "Internal error, could not load db", brokerException);
        }
        return super.getBroker(string);
    }

    class jdbcStore
    implements haStore {
        private Store store = Globals.getStore();

        public String toString() {
            return "jdbcStore[" + this.store + "]";
        }

        public Map getAllBrokerInfoByState(BrokerState brokerState) throws BrokerException {
            return this.store.getAllBrokerInfoByState(brokerState);
        }

        public TakeoverStoreInfo takeOverBrokerStore(String string, String string2) throws BrokerException {
            return this.store.takeOverBrokerStore(string, string2);
        }

        public void getTakeOverLock(String string, String string2, long l, BrokerState brokerState, long l2, BrokerState brokerState2) throws BrokerException {
            int n = HAClusterManagerImpl.this.config.getIntProperty("imq.cluster.takeover.delay.interval", 0);
            if (n > 0) {
                try {
                    Thread.sleep(n * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.store.getTakeOverLock(string, string2, l, brokerState, l2, brokerState2);
        }

        public void updateBrokerState(String string, BrokerState brokerState, BrokerState brokerState2) throws BrokerException {
            this.store.updateBrokerState(string, brokerState, brokerState2);
        }

        public BrokerState getBrokerState(String string) throws BrokerException {
            return this.store.getBrokerState(string);
        }

        public void updateBrokerInfo(String string, UID uID, MQAddress mQAddress, Integer n, BrokerState brokerState) throws BrokerException {
            this.store.updateBrokerInfo(string, "", mQAddress.toString(), n, brokerState, uID.longValue());
        }

        public void updateBrokerHeartbeat(String string, long l, BrokerState brokerState) throws BrokerException {
            this.store.updateBrokerHeartbeat(string, System.currentTimeMillis());
        }

        public long getBrokerHeartbeat(String string) throws BrokerException {
            return this.store.getBrokerHeartbeat(string);
        }

        public void addBrokerInfo(String string, UID uID, MQAddress mQAddress, Integer n, BrokerState brokerState, String string2, long l) throws BrokerException {
            this.store.addBrokerInfo(string, mQAddress.toString(), brokerState, n, uID.longValue(), l);
        }

        public HABrokerInfo getBrokerInfo(String string) throws BrokerException {
            return this.store.getBrokerInfo(string);
        }
    }

    static interface haStore {
        public Map getAllBrokerInfoByState(BrokerState var1) throws BrokerException;

        public TakeoverStoreInfo takeOverBrokerStore(String var1, String var2) throws BrokerException;

        public void getTakeOverLock(String var1, String var2, long var3, BrokerState var5, long var6, BrokerState var8) throws BrokerException;

        public void updateBrokerState(String var1, BrokerState var2, BrokerState var3) throws BrokerException;

        public BrokerState getBrokerState(String var1) throws BrokerException;

        public void updateBrokerInfo(String var1, UID var2, MQAddress var3, Integer var4, BrokerState var5) throws BrokerException;

        public void updateBrokerHeartbeat(String var1, long var2, BrokerState var4) throws BrokerException;

        public long getBrokerHeartbeat(String var1) throws BrokerException;

        public void addBrokerInfo(String var1, UID var2, MQAddress var3, Integer var4, BrokerState var5, String var6, long var7) throws BrokerException;

        public HABrokerInfo getBrokerInfo(String var1) throws BrokerException;
    }

    public class HAMap
    extends HashMap
    implements Map {
        public HAMap() throws BrokerException {
            List list = BrokerState.getAllStates();
            for (int i = 0; i < list.size(); ++i) {
                Map map = HAClusterManagerImpl.this.store.getAllBrokerInfoByState((BrokerState)list.get(i));
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    HABrokerInfo hABrokerInfo = (HABrokerInfo)map.get(string);
                    HAClusteredBrokerImpl hAClusteredBrokerImpl = new HAClusteredBrokerImpl(hABrokerInfo.getId(), hABrokerInfo);
                    this.put(string, hAClusteredBrokerImpl);
                    HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.ADDED, hAClusteredBrokerImpl.getBrokerName(), null, hAClusteredBrokerImpl, hAClusteredBrokerImpl.getBrokerSessionUID(), null);
                }
            }
        }

        public void updateHAMap() throws BrokerException {
            this.updateHAMap(false);
        }

        public void updateHAMap(boolean bl) throws BrokerException {
            if (bl) {
                List list = BrokerState.getAllStates();
                for (int i = 0; i < list.size(); ++i) {
                    this.updateHAMapForState((BrokerState)list.get(i));
                }
            } else {
                this.updateHAMapForState(BrokerState.OPERATING);
            }
        }

        public void updateHAMapForState(BrokerState brokerState) throws BrokerException {
            Map map = HAClusterManagerImpl.this.store.getAllBrokerInfoByState(brokerState);
            Iterator iterator = new HashSet(map.keySet()).iterator();
            while (iterator.hasNext()) {
                HAClusteredBrokerImpl hAClusteredBrokerImpl;
                String string = (String)iterator.next();
                HABrokerInfo hABrokerInfo = (HABrokerInfo)map.get(string);
                if (hABrokerInfo == null) {
                    hABrokerInfo = (HABrokerInfo)map.get(string);
                    hAClusteredBrokerImpl = new HAClusteredBrokerImpl(hABrokerInfo.getId(), hABrokerInfo);
                    this.put(string, hAClusteredBrokerImpl);
                    HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.ADDED, hAClusteredBrokerImpl.getBrokerName(), null, hAClusteredBrokerImpl, hAClusteredBrokerImpl.getBrokerSessionUID(), null);
                    continue;
                }
                hAClusteredBrokerImpl = (HAClusteredBrokerImpl)this.get(string);
                hAClusteredBrokerImpl.update(hABrokerInfo);
            }
        }

        public Object get(Object object) {
            return this.get(object, false);
        }

        public Object get(Object object, boolean bl) {
            Object object2 = super.get(object);
            if (object2 == null || bl) {
                try {
                    HABrokerInfo hABrokerInfo = HAClusterManagerImpl.this.store.getBrokerInfo((String)object);
                    if (hABrokerInfo != null && object2 == null) {
                        HAClusteredBrokerImpl hAClusteredBrokerImpl = new HAClusteredBrokerImpl((String)object, hABrokerInfo);
                        this.put(object, hAClusteredBrokerImpl);
                        HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.ADDED, hAClusteredBrokerImpl.getBrokerName(), null, hAClusteredBrokerImpl, hAClusteredBrokerImpl.getBrokerSessionUID(), null);
                        object2 = hAClusteredBrokerImpl;
                    }
                }
                catch (BrokerException brokerException) {
                    HAClusterManagerImpl.this.logger.log(8, "B3100", (Object)(" exception while creating broker entry " + object), (Throwable)brokerException);
                }
            }
            return object2;
        }
    }

    public class HAClusteredBrokerImpl
    implements HAClusteredBroker {
        boolean dirty = false;
        boolean local = false;
        Integer status = new Integer(0);
        BrokerState state = BrokerState.INITIALIZING;
        String brokerid = null;
        MQAddress address = null;
        Integer version = new Integer(0);
        UID session = null;
        long heartbeat = 0L;
        String takeoverBroker = null;
        UID brokerSessionUID;

        public HAClusteredBrokerImpl(String string) throws BrokerException {
            this(string, hAClusterManagerImpl.store.getBrokerInfo(string));
        }

        public HAClusteredBrokerImpl(String string, HABrokerInfo hABrokerInfo) throws BrokerException {
            this.brokerid = string;
            this.status = new Integer(0);
            String string2 = hABrokerInfo.getUrl();
            try {
                this.address = BrokerMQAddress.createAddress(string2);
            }
            catch (Exception exception) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "invalid URL stored on disk " + string2, exception));
            }
            this.version = new Integer(hABrokerInfo.getVersion());
            this.state = BrokerState.getState(hABrokerInfo.getState());
            this.session = new UID(hABrokerInfo.getSessionID());
            this.takeoverBroker = hABrokerInfo.getTakeoverBrokerID();
            this.heartbeat = hABrokerInfo.getHeartbeat();
        }

        public HAClusteredBrokerImpl(String string, MQAddress mQAddress, int n, BrokerState brokerState, UID uID) throws BrokerException {
            this.brokerid = string;
            this.local = this.local;
            this.status = new Integer(0);
            this.address = mQAddress;
            this.version = new Integer(n);
            this.state = brokerState;
            this.session = uID;
            this.takeoverBroker = "";
            this.brokerSessionUID = new UID();
            HAClusterManagerImpl.this.store.addBrokerInfo(string, uID, this.address, this.version, brokerState, this.takeoverBroker, this.heartbeat);
            this.heartbeat = HAClusterManagerImpl.this.store.getBrokerHeartbeat(string);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ClusteredBroker)) {
                return false;
            }
            return this.getBrokerName().equals(((ClusteredBroker)object).getBrokerName());
        }

        public int hashCode() {
            return this.getBrokerName().hashCode();
        }

        public void update(HABrokerInfo hABrokerInfo) {
            this.brokerid = hABrokerInfo.getId();
            String string = hABrokerInfo.getUrl();
            try {
                this.address = BrokerMQAddress.createAddress(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.version = new Integer(hABrokerInfo.getVersion());
            this.state = BrokerState.getState(hABrokerInfo.getState());
            this.session = new UID(hABrokerInfo.getSessionID());
            this.takeoverBroker = hABrokerInfo.getTakeoverBrokerID();
            this.heartbeat = hABrokerInfo.getHeartbeat();
        }

        void setIsLocal(boolean bl) {
            this.local = bl;
        }

        public String toString() {
            if (!this.local) {
                return "-" + this.brokerid + "@" + this.address + ":" + this.state + "[" + this.session + "]" + ":" + BrokerStatus.toString(this.status);
            }
            return "*" + this.brokerid + "@" + this.address + ":" + this.state + "[" + this.session + "]" + ":" + BrokerStatus.toString(this.status);
        }

        public String getBrokerName() {
            return this.brokerid;
        }

        public MQAddress getBrokerURL() {
            return this.address;
        }

        public void setBrokerURL(MQAddress mQAddress) throws UnsupportedOperationException {
            if (!this.local) {
                throw new UnsupportedOperationException("Only the local broker can have its url changed");
            }
            MQAddress mQAddress2 = this.address;
            this.address = mQAddress;
            this.dirty = true;
            try {
                this.updateEntry();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.ADDRESS_CHANGED, this.getBrokerName(), mQAddress2, this.address, null, null);
        }

        public void resetTakeoverBroker() {
            if (!this.local) {
                throw new UnsupportedOperationException("Only the local broker can have its takeover broker reset");
            }
            this.dirty = true;
            try {
                this.updateEntry();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public boolean isLocalBroker() {
            return this.local;
        }

        public synchronized int getStatus() {
            return this.status;
        }

        public synchronized int getVersion() {
            return this.version == null ? 0 : this.version;
        }

        public synchronized void setVersion(int n) throws UnsupportedOperationException {
            Integer n2 = this.version;
            this.version = new Integer(n);
            if (this.local) {
                try {
                    this.updateEntry();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.VERSION_CHANGED, this.getBrokerName(), n2, this.version, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStatus(int n, Object object) {
            UID uID = null;
            Integer n2 = null;
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                if (this.status == n) {
                    return;
                }
                uID = this.getBrokerSessionUID();
                n2 = this.status;
                this.status = new Integer(n);
            }
            if (!n2.equals(this.status)) {
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATUS_CHANGED, this.getBrokerName(), n2, this.status, uID, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBrokerIsUp(boolean bl, Object object) {
            UID uID = null;
            Integer n = null;
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                n = this.status;
                int n2 = 0;
                if (bl) {
                    n2 = BrokerStatus.setBrokerIsUp(this.status);
                } else {
                    n2 = BrokerStatus.setBrokerIsDown(this.status);
                    n2 = BrokerStatus.setBrokerNotInDoubt(n2);
                }
                uID = this.getBrokerSessionUID();
                this.status = new Integer(n2);
            }
            if (!n.equals(this.status)) {
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, this.status, uID, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBrokerLinkUp(boolean bl, Object object) {
            UID uID = null;
            Integer n = null;
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                n = this.status;
                int n2 = 0;
                uID = this.getBrokerSessionUID();
                n2 = bl ? BrokerStatus.setBrokerLinkIsUp(this.status) : BrokerStatus.setBrokerLinkIsDown(this.status);
                this.status = new Integer(n2);
            }
            if (!n.equals(this.status)) {
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, this.status, uID, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBrokerInDoubt(boolean bl, Object object) {
            UID uID = null;
            Integer n = null;
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                n = this.status;
                int n2 = 0;
                n2 = bl ? BrokerStatus.setBrokerInDoubt(this.status) : BrokerStatus.setBrokerNotInDoubt(this.status);
                uID = this.getBrokerSessionUID();
                this.status = new Integer(n2);
            }
            if (!n.equals(this.status)) {
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, this.status, uID, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                this.status = new Integer(BrokerStatus.setBrokerIsDown(this.status));
            }
        }

        public synchronized UID getStoreSessionUID() {
            return this.session;
        }

        public synchronized UID getBrokerSessionUID() {
            return this.brokerSessionUID;
        }

        public synchronized void setStoreSessionUID(UID uID) throws IllegalAccessException {
            if (!this.local) {
                throw new IllegalAccessException("Only the local broker can have its session changed");
            }
            UID uID2 = this.session;
            try {
                this.session = uID;
                HAClusterManagerImpl.this.localSessionUID = uID;
                this.dirty = true;
                this.updateEntry();
            }
            catch (IllegalAccessException illegalAccessException) {
                this.session = uID2;
                HAClusterManagerImpl.this.localSessionUID = uID;
                throw illegalAccessException;
            }
            catch (RuntimeException runtimeException) {
                this.session = uID2;
                HAClusterManagerImpl.this.localSessionUID = uID;
                throw runtimeException;
            }
        }

        public synchronized void setBrokerSessionUID(UID uID) {
            this.brokerSessionUID = uID;
        }

        public boolean isBrokerIDGenerated() {
            return false;
        }

        public synchronized String getTakeoverBroker() throws BrokerException {
            HABrokerInfo hABrokerInfo = HAClusterManagerImpl.this.store.getBrokerInfo(this.brokerid);
            if (hABrokerInfo == null) {
                HAClusterManagerImpl.this.logger.log(32, "Unable to find " + this.brokerid + " in the store");
                return null;
            }
            this.takeoverBroker = hABrokerInfo.getTakeoverBrokerID();
            return this.takeoverBroker;
        }

        public long getHeartbeat() throws BrokerException {
            this.heartbeat = HAClusterManagerImpl.this.store.getBrokerHeartbeat(this.brokerid);
            return this.heartbeat;
        }

        public synchronized long updateHeartbeat() throws BrokerException {
            HAClusterManagerImpl.this.store.updateBrokerHeartbeat(this.brokerid, this.heartbeat, this.state);
            this.heartbeat = HAClusterManagerImpl.this.store.getBrokerHeartbeat(this.brokerid);
            return this.heartbeat;
        }

        private synchronized void updateEntry() throws IllegalStateException, IllegalAccessException {
            if (!this.dirty) {
                return;
            }
            if (!this.local) {
                throw new IllegalAccessException("Can not update entry  for broker " + this.brokerid);
            }
            try {
                HAClusterManagerImpl.this.store.updateBrokerInfo(this.brokerid, this.session, this.address, this.version, this.state);
                this.heartbeat = HAClusterManagerImpl.this.store.getBrokerHeartbeat(this.brokerid);
                this.dirty = false;
            }
            catch (Exception exception) {
                IllegalStateException illegalStateException = new IllegalStateException(Globals.getBrokerResources().getKString("B3100", "could not update broker info for " + this.brokerid));
                illegalStateException.initCause(exception);
                throw illegalStateException;
            }
        }

        public BrokerState getState() throws BrokerException {
            BrokerState brokerState = this.state;
            this.state = HAClusterManagerImpl.this.store.getBrokerState(this.brokerid);
            if (brokerState != this.state && this.state != BrokerState.FAILOVER_PENDING) {
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATE_CHANGED, this.getBrokerName(), brokerState, this.state, null, null);
            }
            return this.state;
        }

        public void setState(BrokerState brokerState) throws IllegalAccessException, IllegalStateException, IndexOutOfBoundsException {
            if (!this.local && brokerState != BrokerState.FAILOVER_COMPLETE && brokerState != BrokerState.FAILOVER_PENDING && brokerState != BrokerState.FAILOVER_STARTED && brokerState != BrokerState.FAILOVER_FAILED) {
                throw new IllegalAccessException("Can not update state  for broker " + this.brokerid);
            }
            try {
                BrokerState brokerState2 = this.getState();
                if (brokerState != BrokerState.FAILOVER_PENDING && brokerState != BrokerState.FAILOVER_FAILED) {
                    HAClusterManagerImpl.this.store.updateBrokerState(this.brokerid, brokerState, this.state);
                }
                this.state = brokerState;
                HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATE_CHANGED, this.getBrokerName(), brokerState2, this.state, null, null);
            }
            catch (BrokerException brokerException) {
                IllegalStateException illegalStateException = new IllegalStateException(Globals.getBrokerResources().getKString("B3100", " bad state for " + this.brokerid));
                illegalStateException.initCause(brokerException);
                throw illegalStateException;
            }
        }

        public TakeoverStoreInfo takeover(boolean bl) throws BrokerException {
            boolean bl2 = false;
            boolean bl3 = false;
            BrokerState brokerState = this.getState();
            if (!bl) {
                if (brokerState == BrokerState.INITIALIZING || brokerState == BrokerState.SHUTDOWN_STARTED || brokerState == BrokerState.SHUTDOWN_COMPLETE) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B1191", this.brokerid), 405);
                }
                if (brokerState == BrokerState.FAILOVER_PENDING || brokerState == BrokerState.FAILOVER_STARTED || brokerState == BrokerState.FAILOVER_COMPLETE) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B1191", this.brokerid), 409);
                }
            }
            long l = System.currentTimeMillis();
            BrokerState brokerState2 = BrokerState.FAILOVER_PENDING;
            HAClusterManagerImpl.this.store.getTakeOverLock(HAClusterManagerImpl.this.localBroker, this.brokerid, this.heartbeat, brokerState, l, brokerState2);
            bl2 = true;
            this.state = brokerState2;
            HAClusterManagerImpl.this.logger.log(4, "state = FAILOVER_PENDING " + this.brokerid);
            HAClusterManagerImpl.this.brokerChanged(ClusterManagerImpl.ClusterReason.STATE_CHANGED, this.brokerid, brokerState, brokerState2, null, null);
            TakeoverStoreInfo takeoverStoreInfo = null;
            try {
                HAClusterManagerImpl.this.logger.log(4, "state = FAILOVER_STARTED " + this.brokerid);
                this.setState(BrokerState.FAILOVER_STARTED);
                takeoverStoreInfo = HAClusterManagerImpl.this.store.takeOverBrokerStore(HAClusterManagerImpl.this.localBroker, this.brokerid);
                HAClusterManagerImpl.this.logger.log(4, "state = FAILOVER_COMPLETE " + this.brokerid);
                bl3 = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Internal error, shouldnt happen", illegalAccessException);
            }
            finally {
                if (bl2 && !bl3) {
                    try {
                        this.setState(BrokerState.FAILOVER_FAILED);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger logger = HAClusterManagerImpl.this.logger;
                        HAClusterManagerImpl.this.logger;
                        logger.log(8, "Internal Error  unable to set state to failed", illegalAccessException);
                    }
                    HAClusterManagerImpl.this.logger.log(16, "Failed to takeover :" + this.brokerid + " state expected is " + brokerState);
                }
            }
            this.heartbeat = l;
            HAClusterManagerImpl.this.addSupportedStoreSessionUID(this.session);
            this.takeoverBroker = HAClusterManagerImpl.this.localBroker;
            return takeoverStoreInfo;
        }

        public boolean isConfigBroker() {
            return true;
        }
    }
}

