/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.lists.EventBroadcastHelper;
import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Prioritized;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Session
implements EventBroadcaster,
EventListener {
    public static final int AUTO_ACKNOWLEDGE = 1;
    public static final int CLIENT_ACKNOWLEDGE = 2;
    public static final int DUPS_OK_ACKNOWLEDGE = 3;
    public static final int NO_ACK_ACKNOWLEDGE = 32768;
    public static final int NONE = 0;
    public static boolean DEBUG;
    protected Logger logger = Globals.getLogger();
    private int ackType = 0;
    SessionUID uid;
    Map deliveredMessages;
    Map cidToStoredCid = null;
    Object sessionLock = new Object();
    EventBroadcastHelper evb = new EventBroadcastHelper();
    Map cleanupList = new HashMap();
    Map storeMap = new HashMap();
    Map consumers = null;
    Map listeners = null;
    Set busyConsumers = null;
    boolean paused = false;
    int pausecnt = 0;
    boolean valid = false;
    private boolean busy = false;
    ConnectionUID parentCuid = null;
    transient SysMessageID creator = null;
    public static boolean NOACK_ENABLED;
    static Map ConsumerToSession;
    static Map allSessions;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean isValidAckType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 32768: {
                return true;
            }
        }
        return false;
    }

    public ConnectionUID getConnectionUID() {
        return this.parentCuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getAllDebugState() {
        Object object;
        Iterator<Object> iterator;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("TABLE", "All Sessions");
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        Map map = allSessions;
        synchronized (map) {
            hashtable.put("allSessionCnt", String.valueOf(allSessions.size()));
            iterator = allSessions.values().iterator();
            while (iterator.hasNext()) {
                object = (Session)iterator.next();
                hashtable2.put(String.valueOf(((Session)object).getSessionUID().longValue()), ((Session)object).getDebugState());
            }
        }
        hashtable.put("allSessions", hashtable2);
        hashtable2 = new Hashtable();
        map = ConsumerToSession;
        synchronized (map) {
            hashtable.put("ConsumerToSession", String.valueOf(ConsumerToSession.size()));
            iterator = ConsumerToSession.keySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                hashtable2.put(object.toString(), ConsumerToSession.get(object).toString());
            }
        }
        hashtable.put("ConsumerToSession", hashtable2);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Object object;
        Iterator iterator;
        Object object2;
        Cloneable cloneable;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("TABLE", "Session[" + this.uid.longValue() + "]");
        hashtable.put("uid", String.valueOf(this.uid.longValue()));
        hashtable.put("connection", String.valueOf(this.parentCuid.longValue()));
        hashtable.put("paused", String.valueOf(this.paused));
        hashtable.put("pausecnt", String.valueOf(this.pausecnt));
        hashtable.put("valid", String.valueOf(this.valid));
        hashtable.put("busy", String.valueOf(this.busy));
        hashtable.put("PendingAcks(deliveredMessages)", String.valueOf(this.deliveredMessages.size()));
        if (this.deliveredMessages.size() > 0) {
            int n;
            Object object3;
            cloneable = null;
            object2 = null;
            iterator = null;
            object = this.deliveredMessages;
            synchronized (object) {
                cloneable = new HashMap(this.deliveredMessages);
            }
            object = this.consumers;
            synchronized (object) {
                object2 = new ArrayList(this.consumers.keySet());
            }
            iterator = (Iterator)new int[((ArrayList)object2).size()];
            object = ((HashMap)cloneable).values().iterator();
            while (object.hasNext()) {
                object3 = (ackEntry)object.next();
                n = ((ArrayList)object2).indexOf(((ackEntry)object3).getConsumerUID());
                if (n == -1) continue;
                Iterator iterator2 = iterator;
                int n2 = n;
                iterator2[n2] = iterator2[n2] + true;
            }
            object3 = new Hashtable();
            for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                if (iterator[n] == false) continue;
                ConsumerUID consumerUID = (ConsumerUID)((ArrayList)object2).get(n);
                ((Hashtable)object3).put(String.valueOf(consumerUID.longValue()), String.valueOf(iterator[n]));
            }
            if (!((Hashtable)object3).isEmpty()) {
                hashtable.put("PendingAcksByConsumer", object3);
            }
        }
        hashtable.put("consumerCnt", String.valueOf(this.consumers.size()));
        cloneable = new Vector();
        object2 = this.consumers;
        synchronized (object2) {
            iterator = this.consumers.keySet().iterator();
            while (iterator.hasNext()) {
                object = (ConsumerUID)iterator.next();
                ((Vector)cloneable).add(String.valueOf(((UID)object).longValue()));
            }
        }
        hashtable.put("consumers", cloneable);
        hashtable.put("busyConsumerCnt", String.valueOf(this.busyConsumers.size()));
        cloneable = new Vector();
        object2 = this.busyConsumers;
        synchronized (object2) {
            iterator = this.busyConsumers.iterator();
            while (iterator.hasNext()) {
                object = (ConsumerUID)iterator.next();
                ((Vector)cloneable).add(String.valueOf(((UID)object).longValue()));
            }
        }
        hashtable.put("busyConsumers", cloneable);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDebugMessages(boolean bl) {
        Vector<String> vector = new Vector<String>();
        Map map = this.deliveredMessages;
        synchronized (map) {
            Iterator iterator = this.deliveredMessages.values().iterator();
            while (iterator.hasNext()) {
                ackEntry ackEntry2 = (ackEntry)iterator.next();
                vector.add(ackEntry2.getDebugMessage(bl));
            }
        }
        return vector;
    }

    public int getNumPendingAcks(ConsumerUID consumerUID) {
        return this.getPendingAcks(consumerUID).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPendingAcks(ConsumerUID consumerUID) {
        ArrayList<SysMessageID> arrayList = new ArrayList<SysMessageID>();
        HashMap hashMap = new HashMap();
        Object object = this.deliveredMessages;
        synchronized (object) {
            if (this.deliveredMessages.size() == 0) {
                return arrayList;
            }
            hashMap.putAll(this.deliveredMessages);
        }
        object = hashMap.values().iterator();
        while (object.hasNext()) {
            ackEntry ackEntry2 = (ackEntry)object.next();
            if (!ackEntry2.getConsumerUID().equals(consumerUID)) continue;
            arrayList.add(ackEntry2.getSysMessageID());
        }
        return arrayList;
    }

    public void setAckType(int n) throws BrokerException {
        if (!Session.isValidAckType(n)) {
            throw new BrokerException("Internal Error: Invalid Ack Type :" + n, 400);
        }
        if (n == 32768 && !NOACK_ENABLED) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3122", Globals.getBrokerResources().getKString("B0058")), "B3122", null, 405);
        }
        this.ackType = n;
    }

    public int getConsumerCnt() {
        if (this.consumers == null) {
            return 0;
        }
        return this.consumers.size();
    }

    public Iterator getConsumers() {
        if (this.consumers == null) {
            return new ArrayList().iterator();
        }
        return new ArrayList(this.consumers.values()).iterator();
    }

    public boolean isAutoAck(ConsumerUID consumerUID) {
        if (this.isUnknown()) {
            return consumerUID.isAutoAck();
        }
        return this.ackType == 1;
    }

    public boolean isUnknown() {
        return this.ackType == 0;
    }

    public boolean isClientAck(ConsumerUID consumerUID) {
        if (this.isUnknown()) {
            return !consumerUID.isAutoAck() && !consumerUID.isDupsOK();
        }
        return this.ackType == 2;
    }

    public boolean isDupsOK(ConsumerUID consumerUID) {
        if (this.isUnknown()) {
            return consumerUID.isDupsOK();
        }
        return this.ackType == 3;
    }

    public boolean isUnsafeAck(ConsumerUID consumerUID) {
        return this.isDupsOK(consumerUID) || this.isNoAck(consumerUID);
    }

    public boolean isNoAck(ConsumerUID consumerUID) {
        if (this.isUnknown()) {
            return consumerUID.isNoAck();
        }
        return this.ackType == 32768;
    }

    public void debug(String string) {
        if (string == null) {
            string = "";
        }
        this.logger.log(8, string + "Session " + this.uid);
        this.logger.log(8, "Paused " + this.paused);
        this.logger.log(8, "pausecnt " + this.pausecnt);
        this.logger.log(8, "busy " + this.busy);
        this.logger.log(8, "ConsumerCnt " + this.consumers.size());
        this.logger.log(8, "BusyConsumerCnt " + this.consumers.size());
        Iterator iterator = this.consumers.values().iterator();
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            consumer.debug("\t");
        }
    }

    private Session(ConnectionUID connectionUID, SysMessageID sysMessageID) {
        this(new SessionUID(), connectionUID, sysMessageID);
    }

    private Session(SessionUID sessionUID, ConnectionUID connectionUID, SysMessageID sysMessageID) {
        this.uid = sessionUID;
        this.parentCuid = connectionUID;
        this.deliveredMessages = Collections.synchronizedMap(new LinkedHashMap());
        this.cidToStoredCid = Collections.synchronizedMap(new HashMap());
        this.consumers = Collections.synchronizedMap(new HashMap());
        this.listeners = Collections.synchronizedMap(new HashMap());
        this.busyConsumers = Collections.synchronizedSet(new LinkedHashSet());
        this.valid = true;
        this.creator = sysMessageID;
        this.logger.log(4, "Created new session " + sessionUID + " on connection " + connectionUID);
    }

    public void dump(String string) {
        if (string == null) {
            string = "";
        }
        this.logger.log(8, string + " Session " + this.uid);
        this.logger.log(8, string + "---------------------------");
        this.logger.log(8, string + "busyConsumers (size) " + this.busyConsumers.size());
        this.logger.log(8, string + "busyConsumers (list) " + this.busyConsumers);
        this.logger.log(8, string + "consumers (size) " + this.consumers.size());
        this.logger.log(8, string + "consumers (list) " + this.consumers);
        this.logger.log(8, string + "---------------------------");
        Iterator iterator = this.consumers.values().iterator();
        while (iterator.hasNext()) {
            ((Consumer)iterator.next()).dump(string + "\t");
        }
    }

    public SessionUID getSessionUID() {
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(String string) {
        Object object = this.sessionLock;
        synchronized (object) {
            this.paused = true;
            ++this.pausecnt;
            if (DEBUG) {
                this.logger.log(8, "Session: Pausing " + this + "[" + this.pausecnt + "]" + string);
            }
        }
        this.checkState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(String string) {
        Object object = this.sessionLock;
        synchronized (object) {
            --this.pausecnt;
            if (this.pausecnt <= 0) {
                this.paused = false;
            }
            if (!$assertionsDisabled && this.pausecnt < 0) {
                throw new AssertionError((Object)("Bad pause " + this));
            }
            if (DEBUG) {
                this.logger.log(8, "Session: Resuming " + this + "[" + this.pausecnt + "]" + string);
            }
        }
        this.checkState(null);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean hasWork() {
        return this.busyConsumers.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fillNextPacket(Packet packet) {
        if (this.paused) {
            return false;
        }
        while (!this.paused) {
            Object object;
            ConsumerUID consumerUID = null;
            Consumer consumer = null;
            Object object2 = this.busyConsumers;
            synchronized (object2) {
                if (this.busyConsumers.isEmpty()) {
                    break;
                }
                object = this.busyConsumers.iterator();
                consumerUID = (ConsumerUID)object.next();
                consumer = (Consumer)this.consumers.get(consumerUID);
                object.remove();
            }
            if (!$assertionsDisabled && packet == null) {
                throw new AssertionError();
            }
            if (consumer == null) {
                return false;
            }
            object2 = null;
            object = this.sessionLock;
            synchronized (object) {
                block32: {
                    Object object3;
                    Object object4;
                    if (this.paused) {
                        object4 = this.busyConsumers;
                        synchronized (object4) {
                            if (consumer != null && consumer.isBusy()) {
                                this.busyConsumers.add(consumerUID);
                            }
                        }
                        return false;
                    }
                    object2 = consumer.getAndFillNextPacket(packet);
                    object4 = this.busyConsumers;
                    synchronized (object4) {
                        if (consumer != null && consumer.isBusy()) {
                            this.busyConsumers.add(consumerUID);
                        }
                    }
                    if (object2 == null) {
                        continue;
                    }
                    object4 = consumer.getStoredConsumerUID();
                    ackEntry ackEntry2 = null;
                    if (!consumer.getConsumerUID().isNoAck()) {
                        ackEntry2 = new ackEntry((PacketReference)object2, consumerUID, (ConsumerUID)object4);
                        object3 = this.deliveredMessages;
                        synchronized (object3) {
                            this.deliveredMessages.put(ackEntry2, ackEntry2);
                        }
                    }
                    try {
                        object3 = consumer.getConsumerUID();
                        boolean bl = !this.isAutoAck((ConsumerUID)object3) || this.deliveredMessages.size() == 1;
                        if (!((PacketReference)object2).delivered((ConsumerUID)object3, (ConsumerUID)object4, !this.isUnsafeAck((ConsumerUID)object3), bl)) break block32;
                        Destination destination = ((PacketReference)object2).getDestination();
                        if (((PacketReference)object2).isDead()) {
                            destination.removeDeadMessage((PacketReference)object2);
                            object2 = null;
                            continue;
                        }
                        destination.removeMessage(((PacketReference)object2).getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    }
                    catch (Exception exception) {
                        this.logger.logStack(8, "Message Gone, unable to update state of the message " + object2, exception);
                        Map map = this.deliveredMessages;
                        synchronized (map) {
                            if (ackEntry2 != null) {
                                this.deliveredMessages.get(ackEntry2);
                            }
                        }
                    }
                }
            }
            this.checkState(null);
            return object2 != null;
        }
        this.checkState(null);
        return false;
    }

    public Object getBusyLock() {
        return this.busyConsumers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        Set set = this.busyConsumers;
        synchronized (set) {
            return this.busy;
        }
    }

    public String toString() {
        return "Session [" + this.uid + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void attachConsumer(Consumer consumer) {
        this.logger.log(4, "Attaching Consumer " + consumer.getConsumerUID() + " to Session " + this.uid);
        if (!this.valid) {
            throw new IllegalStateException(this + " is closed");
        }
        consumer.attachToSession(this.getSessionUID());
        ConsumerUID consumerUID = consumer.getConsumerUID();
        consumerUID.setAckType(this.ackType);
        consumer.getStoredConsumerUID().setAckType(this.ackType);
        this.consumers.put(consumerUID, consumer);
        this.listeners.put(consumerUID, consumer.addEventListener(this, EventType.BUSY_STATE_CHANGED, null));
        if (consumer.isBusy()) {
            this.busyConsumers.add(consumerUID);
        }
        Map map = ConsumerToSession;
        synchronized (map) {
            ConsumerToSession.put(consumer.getConsumerUID(), this.getSessionUID());
        }
        this.checkState(null);
    }

    public Consumer detatchConsumer(ConsumerUID consumerUID, SysMessageID sysMessageID, boolean bl) throws BrokerException {
        this.pause("Consumer.java: detatch consumer " + consumerUID);
        Consumer consumer = (Consumer)this.consumers.remove(consumerUID);
        if (consumer == null) {
            if (!$assertionsDisabled && consumer == null) {
                throw new AssertionError();
            }
            this.resume("Consumer.java: bad removal " + consumerUID);
            throw new BrokerException("Detatching consumer " + consumerUID + " not currently attached " + "to " + this);
        }
        consumer.pause("Consumer.java: detatch consumer " + consumerUID + " DEAD");
        this.detatchConsumer(consumer, sysMessageID, bl);
        this.resume("Consumer.java: detatch consumer " + consumerUID);
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detatchConsumer(Consumer consumer, SysMessageID sysMessageID, boolean bl) {
        this.logger.log(4, "Detaching Consumer " + consumer.getConnectionUID() + " from Session " + this.uid + " last id was " + sysMessageID);
        consumer.pause("Consumer.java: Detatch consumer 1 " + consumer);
        this.pause("Consumer.java: Detatch consumer A " + consumer);
        ConsumerUID consumerUID = consumer.getConsumerUID();
        ConsumerUID consumerUID2 = consumer.getStoredConsumerUID();
        Object v = this.listeners.remove(consumerUID);
        if (!$assertionsDisabled && v == null) {
            throw new AssertionError();
        }
        consumer.removeEventListener(v);
        consumer.attachToSession(null);
        this.busyConsumers.remove(consumerUID);
        this.consumers.remove(consumerUID);
        this.checkState(null);
        LinkedHashSet<PacketReference> linkedHashSet = new LinkedHashSet<PacketReference>();
        Map map = this.deliveredMessages;
        synchronized (map) {
            PacketReference packetReference;
            ackEntry ackEntry2;
            boolean bl2;
            Object object;
            ackEntry ackEntry3 = null;
            if (sysMessageID != null) {
                object = new ackEntry(sysMessageID, consumerUID);
                ackEntry3 = (ackEntry)this.deliveredMessages.get(object);
            }
            this.cleanupList.put(consumerUID, consumer.getParentList());
            this.storeMap.put(consumerUID, consumer.getStoredConsumerUID());
            object = this.deliveredMessages.values().iterator();
            boolean bl3 = bl2 = ackEntry3 == null && sysMessageID != null;
            while (!bl2 && object.hasNext()) {
                ackEntry2 = (ackEntry)object.next();
                if (ackEntry2 == ackEntry3) {
                    bl2 = true;
                }
                if (ackEntry2.storedcid != consumerUID2 && ackEntry2.uid != consumerUID) continue;
                packetReference = ackEntry2.getReference();
                try {
                    packetReference.consumed(consumerUID2, !this.isUnsafeAck(consumerUID), this.isAutoAck(consumerUID));
                }
                catch (Exception exception) {
                    this.logger.log(8, "Internal Error Unable to consume " + consumerUID2 + ":" + packetReference, exception);
                }
                if (!bl) continue;
                linkedHashSet.add(packetReference);
                object.remove();
            }
            while (object.hasNext()) {
                ackEntry2 = (ackEntry)object.next();
                if (ackEntry2.storedcid != consumerUID2 && ackEntry2.uid != consumerUID) continue;
                packetReference = ackEntry2.getReference();
                if (packetReference != null) {
                    linkedHashSet.add(packetReference);
                }
                object.remove();
                try {
                    if (packetReference == null) continue;
                    packetReference.removeDelivered(consumerUID2, true);
                }
                catch (Exception exception) {
                    this.logger.log(8, "Internal Error Unable to consume " + consumerUID2 + ":" + packetReference, exception);
                }
            }
        }
        consumer.destroyConsumer(linkedHashSet, false);
        this.resume("Consumer.java: resuming after detatch " + consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeInTransaction(ConsumerUID consumerUID, SysMessageID sysMessageID, TransactionUID transactionUID) throws BrokerException {
        ackEntry ackEntry2 = new ackEntry(sysMessageID, consumerUID);
        PacketReference packetReference = null;
        Map map = this.deliveredMessages;
        synchronized (map) {
            ackEntry2 = (ackEntry)this.deliveredMessages.get(ackEntry2);
            if (ackEntry2 == null) {
                String string = "Internal Error: Received unknown message for transaction " + transactionUID + " on session " + this.uid + " ack info is " + consumerUID + "," + sysMessageID;
                PacketReference packetReference2 = Destination.get(sysMessageID);
                string = packetReference2 == null ? string + ": Broker does not know about the message" : string + ":Broker knows about the message, not associated with the session";
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
            ackEntry2.setTUID(transactionUID);
            if (Globals.useNewTxnProtocol()) {
                packetReference = ackEntry2.getReference();
                try {
                    packetReference.txnAcknowledge(consumerUID, transactionUID);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        Object object;
        Object object2;
        Iterator iterator = this;
        synchronized (iterator) {
            if (!this.valid) {
                return;
            }
            this.valid = false;
        }
        iterator = null;
        Object object3 = this;
        synchronized (object3) {
            iterator = new HashSet(this.consumers.values()).iterator();
        }
        while (iterator.hasNext()) {
            object3 = (Consumer)iterator.next();
            iterator.remove();
            this.detatchConsumer((Consumer)object3, null, true);
        }
        object3 = this.deliveredMessages;
        synchronized (object3) {
            if (!this.deliveredMessages.isEmpty()) {
                Set<Object> set;
                Serializable serializable;
                Object object4;
                object2 = new HashMap();
                iterator = this.deliveredMessages.keySet().iterator();
                while (iterator.hasNext()) {
                    object = (ackEntry)iterator.next();
                    object4 = ((ackEntry)object).getTUID();
                    if (object4 != null && (serializable = Globals.getTransactionList().UIDToXid((TransactionUID)object4)) != null) {
                        Globals.getTransactionList().addOrphanAck((TransactionUID)object4, ((ackEntry)object).getSysMessageID(), ((ackEntry)object).getConsumerUID());
                        iterator.remove();
                        continue;
                    }
                    serializable = ((ackEntry)object).getConsumerUID();
                    set = (LinkedHashSet<Object>)((HashMap)object2).get(serializable);
                    if (set == null) {
                        set = new LinkedHashSet<Object>();
                        ((HashMap)object2).put(serializable, set);
                    }
                    set.add(object);
                }
                iterator = ((HashMap)object2).keySet().iterator();
                while (iterator.hasNext()) {
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object8;
                    object = (ConsumerUID)iterator.next();
                    object4 = (Prioritized)this.cleanupList.get(object);
                    serializable = (ConsumerUID)this.storeMap.get(object);
                    if (object4 == null) {
                        set = (Set)((HashMap)object2).get(object);
                        object8 = set.iterator();
                        while (object8.hasNext()) {
                            object7 = (ackEntry)object8.next();
                            try {
                                object6 = ((ackEntry)object7).acknowledged(false, null);
                                if (object6 == null) continue;
                                object5 = ((PacketReference)object6).getDestination();
                                try {
                                    ((Destination)object5).removeMessage(((PacketReference)object6).getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                                }
                                catch (Exception exception) {
                                    this.logger.logStack(8, "Internal Error", exception);
                                }
                            }
                            catch (Exception exception) {}
                        }
                        continue;
                    }
                    set = new LinkedHashSet();
                    object8 = (Set)((HashMap)object2).get(object);
                    object7 = object8.iterator();
                    while (object7.hasNext()) {
                        object6 = (ackEntry)object7.next();
                        object5 = ((ackEntry)object6).getReference();
                        if (object5 != null) {
                            try {
                                ((PacketReference)object5).consumed((ConsumerUID)serializable, !this.isUnsafeAck((ConsumerUID)object), this.isAutoAck((ConsumerUID)object));
                            }
                            catch (Exception exception) {
                                this.logger.log(8, "Internal Error Unable to consume " + serializable + ":" + object5, exception);
                            }
                            ((HashSet)set).add(object5);
                            continue;
                        }
                        object7.remove();
                    }
                    object4.addAllToFront(set, 0);
                }
                this.deliveredMessages.clear();
                this.cleanupList.clear();
                this.storeMap.clear();
            }
        }
        object3 = ConsumerToSession;
        synchronized (object3) {
            object2 = ConsumerToSession.values().iterator();
            while (object2.hasNext()) {
                object = (SessionUID)object2.next();
                if (!((UID)object).equals(this.uid)) continue;
                object2.remove();
            }
        }
        allSessions.remove(this.uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketReference handleUndeliverable(ConsumerUID consumerUID, SysMessageID sysMessageID) throws BrokerException {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        ackEntry ackEntry2 = new ackEntry(sysMessageID, consumerUID);
        PacketReference packetReference = null;
        Object object = this.deliveredMessages;
        synchronized (object) {
            ackEntry2 = (ackEntry)this.deliveredMessages.remove(ackEntry2);
            if (ackEntry2 == null) {
                return null;
            }
            packetReference = ackEntry2.getReference();
        }
        if (packetReference == null) {
            return null;
        }
        object = consumer.getStoredConsumerUID();
        if (((UID)object).equals(consumerUID)) {
            try {
                if (packetReference.acknowledged(consumerUID, (ConsumerUID)object, false, false)) {
                    return packetReference;
                }
            }
            catch (Exception exception) {
                this.logger.logStack(4, "Error handling undeliverable", exception);
            }
            return null;
        }
        Destination destination = packetReference.getDestination();
        destination.forwardOrphanMessage(packetReference, (ConsumerUID)object);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketReference handleDead(ConsumerUID consumerUID, SysMessageID sysMessageID, Throwable throwable, String string, int n) throws BrokerException {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        ackEntry ackEntry2 = new ackEntry(sysMessageID, consumerUID);
        PacketReference packetReference = null;
        Object object = this.deliveredMessages;
        synchronized (object) {
            ackEntry2 = (ackEntry)this.deliveredMessages.remove(ackEntry2);
            if (ackEntry2 == null) {
                return null;
            }
            packetReference = ackEntry2.getReference();
        }
        if (packetReference == null) {
            return null;
        }
        object = consumer.getStoredConsumerUID();
        Destination destination = packetReference.getDestination();
        if (packetReference.markDead((ConsumerUID)object, string, throwable, RemoveReason.UNDELIVERABLE, n, null)) {
            return packetReference;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketReference ackMessage(ConsumerUID consumerUID, SysMessageID sysMessageID, TransactionUID transactionUID) throws BrokerException {
        ackEntry ackEntry2 = new ackEntry(sysMessageID, consumerUID);
        PacketReference packetReference = null;
        Map map = this.deliveredMessages;
        synchronized (map) {
            ackEntry2 = (ackEntry)this.deliveredMessages.remove(ackEntry2);
            if (ackEntry2 == null) {
                return null;
            }
            packetReference = ackEntry2.acknowledged(true, transactionUID);
        }
        if (this.isAutoAck(ackEntry2.getConsumerUID())) {
            map = this.deliveredMessages;
            synchronized (map) {
                Iterator iterator = this.deliveredMessages.values().iterator();
                while (iterator.hasNext()) {
                    ackEntry ackEntry3 = (ackEntry)iterator.next();
                    PacketReference packetReference2 = ackEntry3.getReference();
                    if (packetReference2 == null) {
                        packetReference2 = Destination.get(sysMessageID);
                        if (packetReference2 == null) {
                            this.logger.log(2, "Removing purged reference " + ackEntry3);
                        } else {
                            this.logger.log(8, "Weird reference behavior" + packetReference2);
                            try {
                                ackEntry3.acknowledged(true, null);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        iterator.remove();
                        continue;
                    }
                    try {
                        packetReference2.delivered(ackEntry3.getConsumerUID(), ackEntry3.getStoredUID(), true, packetReference2.isStored());
                        break;
                    }
                    catch (Exception exception) {
                        this.logger.logStack(8, "Internal error, unable to deliver " + consumerUID + ":" + packetReference, exception);
                    }
                }
            }
        }
        return packetReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acknowledgeToMessage(ConsumerUID consumerUID, SysMessageID sysMessageID) throws BrokerException {
        boolean bl = false;
        ackEntry ackEntry2 = new ackEntry(sysMessageID, consumerUID);
        Map map = this.deliveredMessages;
        synchronized (map) {
            ackEntry ackEntry3 = (ackEntry)this.deliveredMessages.get(ackEntry2);
            if (ackEntry3 == null) {
                if (!$assertionsDisabled) {
                    throw new AssertionError(ackEntry2);
                }
                return false;
            }
            Iterator iterator = this.deliveredMessages.values().iterator();
            while (iterator.hasNext()) {
                ackEntry ackEntry4 = (ackEntry)iterator.next();
                PacketReference packetReference = ackEntry4.acknowledged(true, null);
                if (packetReference != null) {
                    Destination destination = packetReference.getDestination();
                    try {
                        destination.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    }
                    catch (Exception exception) {
                        this.logger.logStack(8, "Internal Error", exception);
                    }
                }
                iterator.remove();
                bl = true;
                if (!ackEntry4.equals(ackEntry3)) continue;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
        ConsumerUID consumerUID = ((Consumer)object).getConsumerUID();
        if (eventType == EventType.BUSY_STATE_CHANGED) {
            Set set = this.busyConsumers;
            synchronized (set) {
                Consumer consumer = (Consumer)this.consumers.get(consumerUID);
                if (consumer != null && consumer.isBusy()) {
                    this.busyConsumers.add(consumerUID);
                }
            }
            this.checkState(null);
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)" event is not valid ");
        }
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Object object) throws UnsupportedOperationException {
        if (eventType != EventType.BUSY_STATE_CHANGED) {
            throw new UnsupportedOperationException("Only Busy and Not Busy types supported on this class");
        }
        return this.evb.addEventListener(eventListener, eventType, object);
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Reason reason, Object object) throws UnsupportedOperationException {
        if (eventType != EventType.BUSY_STATE_CHANGED) {
            throw new UnsupportedOperationException("Only Busy and Not Busy types supported on this class");
        }
        return this.evb.addEventListener(eventListener, eventType, reason, object);
    }

    public Object removeEventListener(Object object) {
        return this.evb.removeEventListener(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState(Reason reason) {
        boolean bl = false;
        boolean bl2 = false;
        Set set = this.busyConsumers;
        synchronized (set) {
            boolean bl3 = bl2 = !this.paused && this.busyConsumers.size() > 0;
            if (bl2 != this.busy) {
                this.busy = bl2;
                bl = true;
            }
        }
        if (bl) {
            this.notifyChange(EventType.BUSY_STATE_CHANGED, reason, this, new Boolean(!bl2), new Boolean(bl2));
        }
    }

    private void notifyChange(EventType eventType, Reason reason, Object object, Object object2, Object object3) {
        this.evb.notifyChange(eventType, reason, object, object2, object3);
    }

    public synchronized Consumer getConsumerOnSession(ConsumerUID consumerUID) {
        return (Consumer)this.consumers.get(consumerUID);
    }

    public static void clearSessions() {
        ConsumerToSession.clear();
        allSessions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(ConsumerUID consumerUID) {
        SessionUID sessionUID = null;
        Map map = ConsumerToSession;
        synchronized (map) {
            sessionUID = (SessionUID)ConsumerToSession.get(consumerUID);
        }
        if (sessionUID == null) {
            return null;
        }
        return Session.getSession(sessionUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll() {
        Map map = allSessions;
        synchronized (map) {
            Globals.getLogger().log(8, "Dumping active sessions");
            Iterator iterator = allSessions.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = allSessions.get(k);
                Globals.getLogger().log(8, "\t" + k + " : " + v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session createSession(ConnectionUID connectionUID, SysMessageID sysMessageID) {
        Session session = new Session(connectionUID, sysMessageID);
        Map map = allSessions;
        synchronized (map) {
            allSessions.put(session.getSessionUID(), session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session createSession(SessionUID sessionUID, ConnectionUID connectionUID, SysMessageID sysMessageID) {
        Session session = new Session(sessionUID, connectionUID, sysMessageID);
        Map map = allSessions;
        synchronized (map) {
            allSessions.put(session.getSessionUID(), session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeSession(SessionUID sessionUID) {
        Session session = null;
        Map map = allSessions;
        synchronized (map) {
            session = (Session)allSessions.remove(sessionUID);
        }
        if (session == null) {
            return;
        }
        if (!$assertionsDisabled && session == null) {
            throw new AssertionError();
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(SessionUID sessionUID) {
        Map map = allSessions;
        synchronized (map) {
            return (Session)allSessions.get(sessionUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(SysMessageID sysMessageID) {
        if (sysMessageID == null) {
            return null;
        }
        Map map = allSessions;
        synchronized (map) {
            Iterator iterator = allSessions.values().iterator();
            while (iterator.hasNext()) {
                Session session = (Session)iterator.next();
                if (!sysMessageID.equals(session.creator)) continue;
                return session;
            }
        }
        return null;
    }

    static {
        $assertionsDisabled = !Session.class.desiredAssertionStatus();
        DEBUG = false;
        NOACK_ENABLED = false;
        try {
            LicenseBase licenseBase = Globals.getCurrentLicense(null);
            NOACK_ENABLED = licenseBase.getBooleanProperty("imq.enable_no_ack", false);
        }
        catch (BrokerException brokerException) {
            NOACK_ENABLED = false;
        }
        ConsumerToSession = new HashMap();
        allSessions = new HashMap();
    }

    class ackEntry {
        ConsumerUID uid = null;
        ConsumerUID storedcid = null;
        Object pref = null;
        SysMessageID id = null;
        TransactionUID tuid = null;
        int hc = 0;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ackEntry(SysMessageID sysMessageID, ConsumerUID consumerUID) {
            if (!$assertionsDisabled && sysMessageID == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && consumerUID == null) {
                throw new AssertionError();
            }
            this.id = sysMessageID;
            this.uid = consumerUID;
            this.pref = null;
        }

        public String getDebugMessage(boolean bl) {
            PacketReference packetReference = this.getReference();
            Packet packet = packetReference == null ? null : packetReference.getPacket();
            String string = "[" + this.uid + "," + this.storedcid + "," + (packet == null ? "null" : packet.toString()) + "]";
            if (bl && packet != null) {
                string = string + "\n" + packet.dumpPacketString(">>");
            }
            return string;
        }

        public void setTUID(TransactionUID transactionUID) {
            this.tuid = transactionUID;
        }

        public TransactionUID getTUID() {
            return this.tuid;
        }

        public ConsumerUID getConsumerUID() {
            return this.uid;
        }

        public ConsumerUID getStoredUID() {
            return this.storedcid;
        }

        public SysMessageID getSysMessageID() {
            return this.id;
        }

        public PacketReference getReference() {
            if (this.pref instanceof WeakReference) {
                return (PacketReference)((WeakReference)this.pref).get();
            }
            return (PacketReference)this.pref;
        }

        public ackEntry(PacketReference packetReference, ConsumerUID consumerUID, ConsumerUID consumerUID2) {
            this.pref = packetReference.isLocal() ? new WeakReference<PacketReference>(packetReference) : packetReference;
            this.id = packetReference.getSysMessageID();
            this.storedcid = consumerUID2;
            this.uid = consumerUID;
        }

        public PacketReference acknowledged(boolean bl, TransactionUID transactionUID) throws BrokerException {
            if (!$assertionsDisabled && this.pref == null) {
                throw new AssertionError();
            }
            boolean bl2 = false;
            PacketReference packetReference = this.getReference();
            try {
                if (packetReference == null) {
                    packetReference = Destination.get(this.id);
                }
                bl2 = packetReference.acknowledged(this.uid, this.storedcid, !Session.this.isUnsafeAck(this.uid), bl, transactionUID);
                Consumer consumer = (Consumer)Session.this.consumers.get(this.uid);
                if (consumer != null) {
                    consumer.setLastAckTime(System.currentTimeMillis());
                }
            }
            catch (Exception exception) {
                if (!$assertionsDisabled) {
                    throw new AssertionError(packetReference);
                }
                Session.this.logger.logStack(4, "Unable to process acknowledgement, Ignoring", exception);
                if (exception instanceof BrokerException) {
                    throw (BrokerException)exception;
                }
                throw new BrokerException("Unable to process ack", exception);
            }
            return bl2 ? packetReference : null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ackEntry)) {
                return false;
            }
            ackEntry ackEntry2 = (ackEntry)object;
            return this.uid.equals(ackEntry2.uid) && this.id.equals(ackEntry2.id);
        }

        public int hashCode() {
            if (this.hc == 0) {
                this.hc = this.id.hashCode() * 15 + this.uid.hashCode();
            }
            return this.hc;
        }

        static {
            $assertionsDisabled = !(class$com$sun$messaging$jmq$jmsserver$core$Session == null ? (class$com$sun$messaging$jmq$jmsserver$core$Session = Session.class$("com.sun.messaging.jmq.jmsserver.core.Session")) : class$com$sun$messaging$jmq$jmsserver$core$Session).desiredAssertionStatus();
        }
    }
}

