/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.ConflictException;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryGlobals;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import java.util.Hashtable;

public class CreateDestinationHandler
extends AdminCmdHandler {
    public CreateDestinationHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        SizeString sizeString;
        SizeString sizeString2;
        int n;
        int n2;
        String string;
        int n3;
        Packet packet2;
        DestinationInfo destinationInfo;
        block32: {
            destinationInfo = (DestinationInfo)this.getBodyObject(packet);
            if (DEBUG) {
                this.logger.log(4, this.getClass().getName() + ": " + "Creating destination: " + hashtable + ": " + destinationInfo.toString());
            }
            packet2 = new Packet(iMQConnection.useDirectBuffers());
            packet2.setPacketType(5);
            n3 = 200;
            string = null;
            n2 = 257;
            n = -1;
            sizeString2 = null;
            sizeString = null;
            if (MemoryGlobals.MEM_DISALLOW_CREATE_DEST) {
                n3 = 500;
                string = "B2077";
            } else if (destinationInfo.isModified(1)) {
                if (destinationInfo.isModified(2)) {
                    n2 = destinationInfo.type;
                }
                if (destinationInfo.isModified(4)) {
                    n = destinationInfo.maxMessages;
                }
                if (destinationInfo.isModified(8)) {
                    sizeString2 = new SizeString();
                    sizeString2.setBytes(destinationInfo.maxMessageBytes);
                }
                if (destinationInfo.isModified(16)) {
                    sizeString = new SizeString();
                    sizeString.setBytes(destinationInfo.maxMessageSize);
                }
            } else {
                n3 = 500;
                string = "B4089";
            }
            if (n3 == 200) {
                if (DestType.destNameIsInternal(destinationInfo.name)) {
                    n3 = 500;
                    string = this.rb.getKString("B4175", destinationInfo.name, DestType.INTERNAL_DEST_PREFIX);
                } else if (CreateDestinationHandler.isValidDestinationName(destinationInfo.name)) {
                    try {
                        Destination.createDestination(destinationInfo.name, n2);
                    }
                    catch (Exception exception) {
                        n3 = 500;
                        string = this.rb.getString("B4090", destinationInfo.name, CreateDestinationHandler.getMessageFromException(exception));
                        if (exception instanceof ConflictException) {
                            this.logger.log(8, string, exception);
                            break block32;
                        }
                        this.logger.logStack(8, string, exception);
                    }
                } else {
                    n3 = 500;
                    string = this.rb.getKString("B4091", destinationInfo.name);
                }
            }
        }
        if (n3 == 200) {
            try {
                Destination destination = Destination.getDestination(destinationInfo.name, DestType.isQueue(n2));
                destination.setCapacity(n);
                destination.setByteCapacity(sizeString2);
                destination.setMaxByteSize(sizeString);
                if (destinationInfo.isModified(32)) {
                    int bl = destinationInfo.destScope;
                    destination.setScope(bl);
                }
                if (destinationInfo.isModified(64)) {
                    int destinationUID = destinationInfo.destLimitBehavior;
                    destination.setLimitBehavior(destinationUID);
                }
                if (destinationInfo.isModified(128)) {
                    int exception2 = destinationInfo.maxPrefetch;
                    destination.setMaxPrefetch(exception2);
                }
                if (destinationInfo.isModified(256)) {
                    int n4 = destinationInfo.destCDP;
                    destination.setClusterDeliveryPolicy(n4);
                }
                if (destinationInfo.isModified(512)) {
                    int n5 = destinationInfo.maxActiveConsumers;
                    destination.setMaxActiveConsumers(n5);
                }
                if (destinationInfo.isModified(2048)) {
                    int n6 = destinationInfo.maxProducers;
                    destination.setMaxProducers(n6);
                }
                if (destinationInfo.isModified(1024)) {
                    int n7 = destinationInfo.maxFailoverConsumers;
                    destination.setMaxFailoverConsumers(n7);
                }
                if (destinationInfo.isModified(4096)) {
                    int n8 = destinationInfo.maxNumSharedConsumers;
                    destination.setMaxSharedConsumers(n8);
                }
                if (destinationInfo.isModified(8192)) {
                    int n9 = destinationInfo.sharedConsumerFlowLimit;
                    destination.setSharedFlowLimit(n9);
                }
                if (destinationInfo.isModified(16384)) {
                    boolean bl = destinationInfo.useDMQ;
                    destination.setUseDMQ(bl);
                }
                destination.update();
            }
            catch (Exception exception) {
                try {
                    DestinationUID destinationUID = DestinationUID.getUID(destinationInfo.name, DestType.isQueue(n2));
                    Destination.removeDestination(destinationUID, false, exception.toString());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                n3 = 500;
                string = this.rb.getString("B4092", destinationInfo.name, CreateDestinationHandler.getMessageFromException(exception));
                this.logger.log(16, string, exception);
            }
        }
        CreateDestinationHandler.setProperties(packet2, 11, n3, string);
        this.parent.sendReply(iMQConnection, packet, packet2);
        return true;
    }

    public static boolean isValidDestinationName(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (cArray == null || cArray.length < 1) {
            return false;
        }
        if (Character.isJavaIdentifierStart(cArray[0])) {
            for (int i = 1; i < cArray.length; ++i) {
                if (Character.isJavaIdentifierPart(cArray[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

