/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ConsumerIterator;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolConsumerUIDIterator;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ClusterConsumerInfo {
    private Logger logger = Globals.getLogger();
    private static final long ConsumerVersionUID = 99353142765567461L;
    private Cluster c;
    private Collection consumers = null;
    private GPacket pkt = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ClusterConsumerInfo(Collection collection, Cluster cluster) {
        this.consumers = collection;
        this.c = cluster;
    }

    private ClusterConsumerInfo(Consumer consumer, Cluster cluster) {
        HashSet<Consumer> hashSet = new HashSet<Consumer>();
        hashSet.add(consumer);
        this.consumers = hashSet;
        this.c = cluster;
    }

    private ClusterConsumerInfo(GPacket gPacket, Cluster cluster) {
        this.pkt = gPacket;
        this.c = cluster;
    }

    public static ClusterConsumerInfo newInstance(Collection collection, Cluster cluster) {
        return new ClusterConsumerInfo(collection, cluster);
    }

    public static ClusterConsumerInfo newInstance(Consumer consumer, Cluster cluster) {
        return new ClusterConsumerInfo(consumer, cluster);
    }

    public static ClusterConsumerInfo newInstance(GPacket gPacket, Cluster cluster) {
        return new ClusterConsumerInfo(gPacket, cluster);
    }

    public GPacket getGPacket(short s) {
        return this.getGPacket(s, -1);
    }

    public GPacket getGPacket(short s, int n) {
        if (!$assertionsDisabled && this.consumers == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && s != 5 && s != 9) {
            throw new AssertionError();
        }
        if (s == 9 && !$assertionsDisabled && n != 4 && n != 2 && n != 3) {
            throw new AssertionError();
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType(s);
        gPacket.putProp("C", new Integer(this.consumers.size()));
        if (this.c != null) {
            this.c.marshalBrokerAddress(this.c.getSelfAddress(), gPacket);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        switch (s) {
            case 5: {
                try {
                    Iterator iterator = this.consumers.iterator();
                    while (iterator.hasNext()) {
                        Consumer consumer = (Consumer)iterator.next();
                        ClusterConsumerInfo.writeConsumer(consumer, dataOutputStream);
                    }
                    dataOutputStream.flush();
                    byteArrayOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                gPacket.setPayload(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
                break;
            }
            case 9: {
                gPacket.putProp("T", new Integer(n));
                try {
                    Iterator iterator = this.consumers.iterator();
                    while (iterator.hasNext()) {
                        Consumer consumer = (Consumer)iterator.next();
                        ClusterConsumerInfo.writeConsumerUID(consumer.getConsumerUID(), dataOutputStream);
                    }
                    dataOutputStream.flush();
                    byteArrayOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                gPacket.setPayload(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            }
        }
        return gPacket;
    }

    public int getConsumerCount() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        return (Integer)this.pkt.getProp("C");
    }

    public int getSubtype() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        short s = this.pkt.getType();
        if (!$assertionsDisabled && s != 9) {
            throw new AssertionError();
        }
        return (Integer)this.pkt.getProp("T");
    }

    public Iterator getConsumers() throws Exception {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        short s = this.pkt.getType();
        if (!$assertionsDisabled && s != 5) {
            throw new AssertionError();
        }
        return new ConsumerIterator(this.pkt.getPayload().array(), this.getConsumerCount(), this.c.unmarshalBrokerAddress(this.pkt));
    }

    public Iterator getConsumerUIDs() throws Exception {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        short s = this.pkt.getType();
        if (!$assertionsDisabled && s != 9) {
            throw new AssertionError();
        }
        return new ProtocolConsumerUIDIterator(this.pkt.getPayload().array(), this.getConsumerCount(), this.c.unmarshalBrokerAddress(this.pkt));
    }

    public boolean isConfigSyncResponse() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        boolean bl = false;
        if (this.pkt.getProp("M") != null) {
            bl = (Boolean)this.pkt.getProp("M");
        }
        return bl;
    }

    public boolean needReply() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        return this.pkt.getBit(1);
    }

    public static void writeConsumer(Consumer consumer, DataOutputStream dataOutputStream) throws IOException {
        String string = consumer.getDestinationUID().getName();
        ConsumerUID consumerUID = consumer.getConsumerUID();
        String string2 = null;
        String string3 = null;
        String string4 = consumer.getSelectorStr();
        boolean bl = consumer.getNoLocal();
        boolean bl2 = consumer.getDestinationUID().isQueue();
        boolean bl3 = true;
        boolean bl4 = false;
        int n = 1;
        if (consumer instanceof Subscription) {
            Subscription subscription = (Subscription)consumer;
            n = subscription.getMaxNumActiveConsumers();
            bl4 = true;
            string2 = subscription.getDurableName();
            string3 = subscription.getClientID();
            if (!subscription.isActive()) {
                bl3 = false;
            }
        }
        dataOutputStream.writeLong(99353142765567461L);
        dataOutputStream.writeUTF(string);
        dataOutputStream.writeBoolean(consumerUID != null);
        if (consumerUID != null) {
            ClusterConsumerInfo.writeConsumerUID(consumerUID, dataOutputStream);
        }
        dataOutputStream.writeBoolean(string3 != null);
        if (string3 != null) {
            dataOutputStream.writeUTF(string3);
        }
        dataOutputStream.writeBoolean(string2 != null);
        if (string2 != null) {
            dataOutputStream.writeUTF(string2);
        }
        dataOutputStream.writeBoolean(string4 != null);
        if (string4 != null) {
            dataOutputStream.writeUTF(string4);
        }
        dataOutputStream.writeBoolean(bl2);
        dataOutputStream.writeBoolean(bl);
        dataOutputStream.writeBoolean(bl3);
        dataOutputStream.writeBoolean(bl4);
        if (bl4) {
            dataOutputStream.writeInt(n);
        }
    }

    public static Consumer readConsumer(DataInputStream dataInputStream) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Logger logger = Globals.getLogger();
        ConsumerUID consumerUID = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        long l = dataInputStream.readLong();
        if (l != 99353142765567461L) {
            throw new IOException("Wrong Consumer Version " + l + " expected " + 99353142765567461L);
        }
        string = dataInputStream.readUTF();
        boolean bl4 = dataInputStream.readBoolean();
        if (bl4) {
            consumerUID = ClusterConsumerInfo.readConsumerUID(dataInputStream);
        }
        if (bl3 = dataInputStream.readBoolean()) {
            string2 = dataInputStream.readUTF();
        }
        if (bl2 = dataInputStream.readBoolean()) {
            string3 = dataInputStream.readUTF();
        }
        if (bl = dataInputStream.readBoolean()) {
            string4 = dataInputStream.readUTF();
        }
        boolean bl5 = dataInputStream.readBoolean();
        boolean bl6 = dataInputStream.readBoolean();
        boolean bl7 = dataInputStream.readBoolean();
        boolean bl8 = false;
        int n = 1;
        try {
            bl8 = dataInputStream.readBoolean();
            if (bl8) {
                n = dataInputStream.readInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DestinationUID destinationUID = DestinationUID.getUID(string, bl5);
        try {
            if (string3 != null) {
                Subscription subscription = Subscription.findCreateDurableSubscription(string2, string3, destinationUID, string4, bl6, false, consumerUID);
                if (subscription != null) {
                    subscription.setMaxNumActiveConsumers(n);
                }
                return subscription;
            }
            if (bl8) {
                Subscription subscription = Subscription.findCreateNonDurableSubscription(string2, string4, destinationUID, bl6, consumerUID);
                if (subscription != null) {
                    subscription.setMaxNumActiveConsumers(n);
                }
                return subscription;
            }
            Consumer consumer = new Consumer(destinationUID, string4, bl6, consumerUID);
            return consumer;
        }
        catch (SelectorFormatException selectorFormatException) {
            logger.log(8, "Internal Error: Got bad selector[" + string4 + "] ", selectorFormatException);
            throw new IOException("bad selector " + string4);
        }
        catch (BrokerException brokerException) {
            logger.logStack(8, "Internal Error: error creating consumer ", brokerException);
            throw new IOException("error creating consumer ");
        }
    }

    public static void writeConsumerUID(ConsumerUID consumerUID, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeLong(consumerUID.longValue());
        dataOutputStream.writeLong(consumerUID.getConnectionUID() == null ? 0L : consumerUID.getConnectionUID().longValue());
        BrokerAddress brokerAddress = consumerUID.getBrokerAddress();
        if (brokerAddress == null) {
            brokerAddress = Globals.getMyAddress();
        }
        if (brokerAddress == null) {
            try {
                brokerAddress = new BrokerAddressImpl();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        brokerAddress.writeBrokerAddress(dataOutputStream);
    }

    public static ConsumerUID readConsumerUID(DataInputStream dataInputStream) throws IOException {
        long l = dataInputStream.readLong();
        ConnectionUID connectionUID = new ConnectionUID(dataInputStream.readLong());
        BrokerAddress brokerAddress = Globals.getMyAddress();
        BrokerAddress brokerAddress2 = (BrokerAddress)brokerAddress.clone();
        brokerAddress2.readBrokerAddress(dataInputStream);
        ConsumerUID consumerUID = new ConsumerUID(l);
        consumerUID.setConnectionUID(connectionUID);
        consumerUID.setBrokerAddress(brokerAddress2);
        return consumerUID;
    }

    public static GPacket getReplyGPacket(short s, int n) {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType(s);
        gPacket.putProp("S", new Integer(n));
        return gPacket;
    }

    static {
        $assertionsDisabled = !ClusterConsumerInfo.class.desiredAssertionStatus();
    }
}

