/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterMessageAckInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import java.io.IOException;
import java.util.HashMap;

public class MessageAckHandler
extends GPacketHandler {
    public static boolean DEBUG = false;
    private FaultInjection fi = FaultInjection.getInjection();
    private HashMap ackCounts = new HashMap();

    public MessageAckHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        if (gPacket.getType() == 3) {
            this.handleMessageAck(messageBusCallback, brokerAddress, gPacket);
        } else if (gPacket.getType() == 4) {
            this.handleMessageAckReply(brokerAddress, gPacket);
        } else {
            this.logger.log(16, "B3100", "Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    public void handleMessageAck(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        ClusterMessageAckInfo clusterMessageAckInfo = ClusterMessageAckInfo.newInstance(gPacket, this.c);
        int n = clusterMessageAckInfo.getAckType();
        Long l = clusterMessageAckInfo.getTransactionID();
        if (FaultInjection.FAULT_INJECTION) {
            ClusterMessageAckInfo.CHECKFAULT(this.ackCounts, n, l, FaultInjection.MSG_REMOTE_ACK_HOME_P, FaultInjection.STAGE_1);
        }
        UID uID = clusterMessageAckInfo.getMessageStoreSessionUID();
        UID uID2 = clusterMessageAckInfo.getMessageBrokerSessionUID();
        SysMessageID sysMessageID = null;
        ConsumerUID consumerUID = null;
        if (n != 7 && n != 8 && (n != 3 || l == null)) {
            clusterMessageAckInfo.initPayloadRead();
            try {
                sysMessageID = clusterMessageAckInfo.readPayloadSysMessageID();
                consumerUID = clusterMessageAckInfo.readPayloadConsumerUID();
            }
            catch (Exception exception) {
                this.logger.logStack(32, this.br.getKString("B3189", gPacket.toString(), brokerAddress), exception);
                this.sendReply(brokerAddress, clusterMessageAckInfo, 500, exception.getMessage());
                return;
            }
            clusterMessageAckInfo.initToString(sysMessageID, consumerUID);
        }
        if (DEBUG) {
            this.logger.log(1, "MessageBus: Received message ack : " + clusterMessageAckInfo);
        }
        if (uID != null != Globals.getHAEnabled()) {
            this.logger.log(32, "B3100", "HA mode not match for message ack " + clusterMessageAckInfo.toString());
            this.sendReply(brokerAddress, clusterMessageAckInfo, 500, "message HA mode not match");
            return;
        }
        if (this.p.isTakeoverTarget(this.selfAddress)) {
            this.logger.log(32, this.br.getKString("B3191", clusterMessageAckInfo.toString(), this.selfAddress));
            this.sendReply(brokerAddress, clusterMessageAckInfo, 500, this.br.getKString("B4244", clusterMessageAckInfo.toString(), this.selfAddress));
            return;
        }
        try {
            messageBusCallback.processRemoteAck(sysMessageID, consumerUID, n, clusterMessageAckInfo.getOptionalProps(), l, uID2, uID);
            if (FaultInjection.FAULT_INJECTION) {
                ClusterMessageAckInfo.CHECKFAULT(this.ackCounts, n, l, FaultInjection.MSG_REMOTE_ACK_HOME_P, FaultInjection.STAGE_2);
            }
            this.sendReply(brokerAddress, clusterMessageAckInfo, 200, null);
            if (FaultInjection.FAULT_INJECTION) {
                ClusterMessageAckInfo.CHECKFAULT(this.ackCounts, n, l, FaultInjection.MSG_REMOTE_ACK_HOME_P, FaultInjection.STAGE_3);
            }
        }
        catch (Exception exception) {
            this.logger.logStack(16, this.br.getKString("B2136", clusterMessageAckInfo.toString(), brokerAddress), exception);
            if (exception instanceof BrokerException) {
                this.sendReply(brokerAddress, clusterMessageAckInfo, ((BrokerException)exception).getStatusCode(), exception.getMessage());
            }
            this.sendReply(brokerAddress, clusterMessageAckInfo, 500, exception.getMessage());
        }
    }

    private void sendReply(BrokerAddress brokerAddress, ClusterMessageAckInfo clusterMessageAckInfo, int n, String string) {
        if (clusterMessageAckInfo.needReply()) {
            try {
                this.c.unicast(brokerAddress, clusterMessageAckInfo.getReplyGPacket(n, string));
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(4), brokerAddress, clusterMessageAckInfo.toString()};
                this.logger.logStack(32, this.br.getKString("B3192", (Object)objectArray), iOException);
            }
        }
    }

    public void handleMessageAckReply(BrokerAddress brokerAddress, GPacket gPacket) {
        this.logger.log(4, "MessageBus: Received G_MESSAGE_ACK_REPLY (" + ClusterMessageAckInfo.getAckAckType(gPacket) + ")  from " + brokerAddress + " : STATUS = " + ClusterMessageAckInfo.getAckAckStatus(gPacket));
        this.p.receivedMessageAckReply(brokerAddress, gPacket);
    }
}

