/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestinationDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class DestinationDAOImpl
extends BaseDAOImpl
implements DestinationDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateSQL;
    protected String updateConnectedTimeSQL;
    protected String deleteSQL;
    protected String selectSQL;
    protected String selectConnectedTimeSQL;
    protected String selectCountSQL;
    protected String selectAllSQL;
    protected String selectAllNamesSQL;
    protected String selectExistSQL;
    protected String selectAutoCreateDestActiveSQL;
    protected String selectTakeoverSQL;
    protected String takeoverSQL;

    DestinationDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQDST40");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("DESTINATION").append(", ").append("IS_LOCAL").append(", ").append("CONNECTION_ID").append(", ").append("CONNECTED_TS").append(", ").append("BROKER_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ? )").toString();
        this.updateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("DESTINATION").append(" = ?, ").append("IS_LOCAL").append(" = ?, ").append("CONNECTION_ID").append(" = ?, ").append("BROKER_ID").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateConnectedTimeSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("CONNECTED_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectConnectedTimeSQL = new StringBuffer(128).append("SELECT ").append("CONNECTED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectCountSQL = new StringBuffer(128).append("SELECT COUNT(*)").append(" FROM ").append(this.tableName).toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(" FROM ").append(this.tableName).append(" WHERE ").append("IS_LOCAL").append(" = 0").append(" OR ").append("BROKER_ID").append(" = ?").toString();
        this.selectAllNamesSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("IS_LOCAL").append(" = 0").append(" OR ").append("BROKER_ID").append(" = ?").toString();
        this.selectExistSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAutoCreateDestActiveSQL = new StringBuffer(128).append("SELECT COUNT(*) FROM ").append(dBManager.getTableName("MQMSG40")).append(" WHERE ").append("DESTINATION_ID").append(" = ?").append(" AND ").append("BROKER_ID").append(" <> ?").toString();
        this.selectTakeoverSQL = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
        this.takeoverSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("BROKER_ID").append(" = ?").append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
    }

    public final String getTableNamePrefix() {
        return "MQDST40";
    }

    public final String getTableName() {
        return this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Connection connection, Destination destination, String string, long l, long l2) throws BrokerException {
        block17: {
            PreparedStatement preparedStatement;
            block16: {
                String string2 = destination.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (this.hasDestination(connection, string2)) {
                        throw new BrokerException(this.br.getKString("B3012", string2));
                    }
                    try {
                        Object object;
                        int n = destination.getIsLocal() ? 1 : 0;
                        long l3 = -1L;
                        if (n > 0) {
                            object = destination.getConnectionUID();
                            if (object != null) {
                                if (l <= 0L) {
                                    l = System.currentTimeMillis();
                                }
                                l3 = ((UID)object).longValue();
                            }
                            if (string == null) {
                                string = dBManager.getBrokerID();
                            }
                        }
                        preparedStatement = connection.prepareStatement(this.insertSQL);
                        preparedStatement.setString(1, string2);
                        object = Util.setObject(preparedStatement, 2, destination);
                        preparedStatement.setInt(3, n);
                        Util.setLong(preparedStatement, 4, l3);
                        Util.setLong(preparedStatement, 5, l);
                        Util.setString(preparedStatement, 6, string);
                        preparedStatement.setLong(7, l2);
                        preparedStatement.executeUpdate();
                        ((ByteArrayInputStream)object).close();
                    }
                    catch (Exception exception) {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4014", string2), exception2);
                    }
                    if (!bl) break block16;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        Util.close(null, preparedStatement, connection);
                    } else {
                        Util.close(null, preparedStatement, null);
                    }
                    throw throwable;
                }
                Util.close(null, preparedStatement, connection);
                break block17;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void update(Connection connection, Destination destination) throws BrokerException {
        boolean bl;
        String string;
        block16: {
            PreparedStatement preparedStatement;
            block15: {
                string = destination.getUniqueName();
                bl = false;
                boolean bl2 = false;
                preparedStatement = null;
                try {
                    Object object;
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl2 = true;
                    }
                    int n = destination.getIsLocal() ? 1 : 0;
                    long l = -1L;
                    String string2 = null;
                    if (n > 0) {
                        object = destination.getConnectionUID();
                        if (object != null) {
                            l = ((UID)object).longValue();
                        }
                        string2 = dBManager.getBrokerID();
                    }
                    preparedStatement = connection.prepareStatement(this.updateSQL);
                    object = Util.setObject(preparedStatement, 1, destination);
                    preparedStatement.setInt(2, n);
                    Util.setLong(preparedStatement, 3, l);
                    Util.setString(preparedStatement, 4, string2);
                    preparedStatement.setString(5, string);
                    if (preparedStatement.executeUpdate() == 1) {
                        bl = true;
                    }
                    ((ByteArrayInputStream)object).close();
                    if (!bl2) break block15;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.updateSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4014", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block16;
            }
            Util.close(null, preparedStatement, null);
        }
        if (!bl) {
            throw new BrokerException(this.br.getKString("B3013", string), 404);
        }
    }

    public void updateConnectedTime(Connection connection, Destination destination, long l) throws BrokerException {
        String string = destination.getUniqueName();
        if (!destination.getIsLocal()) {
            throw new BrokerException(this.br.getKString("B3181", string));
        }
        boolean bl = false;
        boolean bl2 = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl2 = true;
            }
            preparedStatement = connection.prepareStatement(this.updateConnectedTimeSQL);
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            if (preparedStatement.executeUpdate() == 1) {
                bl = true;
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateConnectedTimeSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4014", string), exception2);
        }
        finally {
            if (bl2) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
        if (!bl) {
            throw new BrokerException(this.br.getKString("B3013", string), 404);
        }
    }

    public void delete(Connection connection, Destination destination) throws BrokerException {
        block16: {
            PreparedStatement preparedStatement;
            block15: {
                String string = destination.getUniqueName();
                boolean bl = false;
                String string2 = null;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    boolean bl2 = true;
                    if (destination.isAutoCreated() && Globals.getHAEnabled()) {
                        string2 = this.selectAutoCreateDestActiveSQL;
                        preparedStatement = connection.prepareStatement(string2);
                        preparedStatement.setString(1, string);
                        preparedStatement.setString(2, dBManager.getBrokerID());
                        ResultSet resultSet = preparedStatement.executeQuery();
                        if (resultSet.next() && resultSet.getInt(1) > 0) {
                            bl2 = false;
                        }
                        resultSet.close();
                    }
                    dBManager.getDAOFactory().getMessageDAO().deleteByDestination(connection, destination);
                    if (bl2) {
                        string2 = this.deleteSQL;
                        preparedStatement = connection.prepareStatement(string2);
                        preparedStatement.setString(1, string);
                        preparedStatement.executeUpdate();
                    }
                    if (bl) {
                        connection.commit();
                    }
                    if (!bl) break block15;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + string2 + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4144", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block16;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void deleteAll(Connection connection) throws BrokerException {
        String string = null;
        if (Globals.getHAEnabled()) {
            string = new StringBuffer(128).append("BROKER_ID").append(" = '").append(DBManager.getDBManager().getBrokerID()).append("'").toString();
        }
        this.deleteAll(connection, string, null, 0);
    }

    public List takeover(Connection connection, String string, String string2) throws BrokerException {
        List list = Collections.EMPTY_LIST;
        String string3 = null;
        PreparedStatement preparedStatement = null;
        try {
            string3 = this.selectTakeoverSQL;
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            list = (List)this.loadData(resultSet, false);
            resultSet.close();
            preparedStatement.close();
            string3 = this.takeoverSQL;
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            int n = preparedStatement.executeUpdate();
            if (n != list.size()) {
                Object[] objectArray = new String[]{string2, String.valueOf(list.size()), String.valueOf(n)};
                throw new BrokerException(this.br.getKString("B3173", objectArray));
            }
        }
        catch (Exception exception) {
            try {
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080", sQLException);
                }
                if (exception instanceof BrokerException) {
                    throw (BrokerException)exception;
                }
                Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + string3 + "]", (SQLException)exception) : exception;
                throw new BrokerException(this.br.getKString("B3174", string2), exception2);
            }
            catch (Throwable throwable) {
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(null, preparedStatement, null);
        return list;
    }

    public Destination getDestination(Connection connection, String string) throws BrokerException {
        Destination destination;
        block9: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block8: {
                destination = null;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    destination = (Destination)this.loadData(resultSet, true);
                    if (!bl) break block8;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4224", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block9;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return destination;
    }

    public long getDestinationConnectedTime(Connection connection, String string) throws BrokerException {
        long l;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                l = -1L;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectConnectedTimeSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3013", string), 404);
                    }
                    l = resultSet.getLong(1);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectConnectedTimeSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4224", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return l;
    }

    public List getAllDestinations(Connection connection, String string) throws BrokerException {
        List list;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                list = Collections.EMPTY_LIST;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (string == null) {
                        string = dBManager.getBrokerID();
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    list = (List)this.loadData(resultSet, false);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4031"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return list;
    }

    public boolean hasDestination(Connection connection, String string) throws BrokerException {
        boolean bl;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                bl = false;
                boolean bl2 = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectExistSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl = true;
                    }
                    if (!bl2) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectExistSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4166", this.selectExistSQL), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return bl;
    }

    public void checkDestination(Connection connection, String string) throws BrokerException {
        if (!this.hasDestination(connection, string)) {
            throw new BrokerException(this.br.getKString("B3013", string), 404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap getDebugInfo(Connection connection) {
        int n;
        HashMap<String, String> hashMap;
        block16: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            boolean bl;
            block15: {
                hashMap = new HashMap<String, String>();
                n = -1;
                bl = false;
                preparedStatement = null;
                resultSet = null;
                if (connection == null) {
                    connection = DBManager.getDBManager().getConnection(true);
                    bl = true;
                }
                if (!(resultSet = (preparedStatement = connection.prepareStatement(this.selectCountSQL)).executeQuery()).next()) break block15;
                n = resultSet.getInt(1);
            }
            try {
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    break block16;
                }
                Util.close(resultSet, preparedStatement, null);
            }
            catch (BrokerException brokerException) {
                this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
            }
            break block16;
            catch (Exception exception) {
                try {
                    this.logger.log(32, "B4166", (Object)this.selectCountSQL, (Throwable)exception);
                }
                catch (Throwable throwable) {
                    try {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                    }
                    throw throwable;
                }
                try {
                    if (bl) {
                        Util.close(resultSet, preparedStatement, connection);
                    }
                    Util.close(resultSet, preparedStatement, null);
                }
                catch (BrokerException brokerException) {
                    this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                }
            }
        }
        hashMap.put("Destinations(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }

    protected Object loadData(ResultSet resultSet, boolean bl) throws SQLException {
        ArrayList<Destination> arrayList = null;
        if (!bl) {
            arrayList = new ArrayList<Destination>(100);
        }
        while (resultSet.next()) {
            try {
                Destination destination = (Destination)Util.readObject(resultSet, 1);
                if (bl) {
                    return destination;
                }
                arrayList.add(destination);
            }
            catch (Exception exception) {
                this.logger.logStack(32, "B4124", exception);
            }
        }
        return arrayList;
    }
}

