/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.JMQByteArrayInputStream;
import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class PacketProperties {
    public static final short BOOLEAN = 1;
    public static final short BYTE = 2;
    public static final short SHORT = 3;
    public static final short INTEGER = 4;
    public static final short LONG = 5;
    public static final short FLOAT = 6;
    public static final short DOUBLE = 7;
    public static final short STRING = 8;
    public static final short OBJECT = 9;
    public static final int VERSION1 = 1;

    public static void write(Map map, OutputStream outputStream) throws IOException {
        if (map == null) {
            return;
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(map.size());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            dataOutputStream.writeUTF(string);
            if (v instanceof Boolean) {
                dataOutputStream.writeShort(1);
                dataOutputStream.writeBoolean((Boolean)v);
                continue;
            }
            if (v instanceof Byte) {
                dataOutputStream.writeShort(2);
                dataOutputStream.writeByte(((Byte)v).byteValue());
                continue;
            }
            if (v instanceof Short) {
                dataOutputStream.writeShort(3);
                dataOutputStream.writeShort(((Short)v).shortValue());
                continue;
            }
            if (v instanceof Integer) {
                dataOutputStream.writeShort(4);
                dataOutputStream.writeInt((Integer)v);
                continue;
            }
            if (v instanceof Long) {
                dataOutputStream.writeShort(5);
                dataOutputStream.writeLong((Long)v);
                continue;
            }
            if (v instanceof Float) {
                dataOutputStream.writeShort(6);
                dataOutputStream.writeFloat(((Float)v).floatValue());
                continue;
            }
            if (v instanceof Double) {
                dataOutputStream.writeShort(7);
                dataOutputStream.writeDouble((Double)v);
                continue;
            }
            if (v instanceof String) {
                dataOutputStream.writeShort(8);
                dataOutputStream.writeUTF((String)v);
                continue;
            }
            dataOutputStream.writeShort(9);
            JMQByteArrayOutputStream jMQByteArrayOutputStream = new JMQByteArrayOutputStream(new byte[256]);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(jMQByteArrayOutputStream);
            objectOutputStream.writeObject(v);
            objectOutputStream.close();
            byte[] byArray = jMQByteArrayOutputStream.getBuf();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
        }
    }

    public static Hashtable parseProperties(InputStream inputStream) throws IOException, ClassNotFoundException {
        String string;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        if (n != 1) {
            throw new IOException("Unsupported version of properties serialization [" + n + "]");
        }
        int n2 = dataInputStream.readInt();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n2);
        for (int i = 0; i < n2 && (string = dataInputStream.readUTF()) != null && string.length() > 0; ++i) {
            short s = dataInputStream.readShort();
            Object object = null;
            switch (s) {
                case 1: {
                    object = new Boolean(dataInputStream.readBoolean());
                    break;
                }
                case 2: {
                    object = new Byte(dataInputStream.readByte());
                    break;
                }
                case 3: {
                    object = new Short(dataInputStream.readShort());
                    break;
                }
                case 4: {
                    object = new Integer(dataInputStream.readInt());
                    break;
                }
                case 5: {
                    object = new Long(dataInputStream.readLong());
                    break;
                }
                case 6: {
                    object = new Float(dataInputStream.readFloat());
                    break;
                }
                case 7: {
                    object = new Double(dataInputStream.readDouble());
                    break;
                }
                case 8: {
                    object = dataInputStream.readUTF();
                    break;
                }
                case 9: {
                    int n3 = dataInputStream.readInt();
                    byte[] byArray = new byte[n3];
                    dataInputStream.read(byArray, 0, n3);
                    JMQByteArrayInputStream jMQByteArrayInputStream = new JMQByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(jMQByteArrayInputStream);
                    object = objectInputStream.readObject();
                    objectInputStream.close();
                    jMQByteArrayInputStream.close();
                }
            }
            hashtable.put(string, (String)object);
        }
        return hashtable;
    }
}

