/*
 * @(#)LongField.java	1.1 01/01/04
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 */
package com.sun.messaging.jmq.admin.apps.console.util;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LongField extends JTextField {
    
    //*****************************************************************
    // Constructors
    
    public LongField(long min, long max, String text) {
	this(min, max, text, 0);
    }

    public LongField(long min, long max, int columns) {
	this(min, max, null, columns);
    }

    public LongField(long min, long max, 
			String text, int columns) {
	super(new LongDocument(min, max), text, columns);
    }
}

//*************************************************************************
// LongDocument class

class LongDocument extends PlainDocument {
    long min;
    long max;

    //*********************************************************************
    // Constructors
    
    public LongDocument(long min, long max) {
	this.min = min;
	this.max = max;
    }
    
    //*********************************************************************
    // Validation routines

    public void insertString(int offset, String str, AttributeSet a)
	 throws BadLocationException 
    {
	// Validate each char in str checking if in '0' .. '9'.
	// If the min value is < 0, then allow a '-' only in the
	// first position.

	for (int i=0; i<str.length(); i++) {
	    int keyCode = (int)str.charAt(i);
	    if (keyCode < KeyEvent.VK_0 || keyCode > KeyEvent.VK_9) {
		// keyCode 45 is the '-' char.
		if (!(min < 0 && offset == 0 && keyCode == 45)) {
		    Toolkit.getDefaultToolkit().beep();
		    return;
		}
	    }
	}
	
	// Validate the entire string in text field making
	// sure it's within range.

	String sval = getText(0, getLength());
	sval = sval.substring(0, offset) + str +
	    sval.substring(offset, sval.length());
	// Max digits for a number to fit in a type long.
	// And also make sure two '-'s weren't entered.
	if (sval.length() > 18 || sval.startsWith("--")) {
	    Toolkit.getDefaultToolkit().beep();
	    return;
	} else if (!sval.equals("-")) {
	    // Evaluate only if it's not a single '-' char.
	    long ival = Long.valueOf(sval).longValue();
	    if (ival < min || ival > max) {
		Toolkit.getDefaultToolkit().beep();
		return;
	    }
	}
	
	// Accept the input.
	super.insertString(offset, new String(str), a);
    }
}







