/*
 * @(#)JMQByteArrayOutputStream.java	1.1 00/01/19
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package com.sun.messaging.jmq.io;

import java.io.ByteArrayOutputStream;

/**
 * This class extends ByteArrayOutputStream to provide the ability
 * to more directly manage the backing buffer to reduce the number of
 * memory allocations and data copies. In particular it supports
 * a constructor that accepts a byte array to use as the backing buffer
 * and an accessor to get the buffer back without making a copy.
 *
 * WARNING! Providing these hooks breaks the safe encapsulation that 
 * ByteArrayOutputStream provides, so be careful. In particular
 * please see the warning on the getBuf() method.
 * 
 * @version 1.1 00/01/19
 */

public class JMQByteArrayOutputStream extends ByteArrayOutputStream {

    /**
     * Creates a new byte array output stream with the specified buffer
     * as the initial backing buffer. Note: the provided buffer may
     * be replaced with another buffer if the implementation finds it
     * necessary to do so (for example to increase the buffer size).
     * You should consider this constructor to be an optimization hint
     * and always use getBuf() to retrieve the backing buffer.
     * 
     * @param    size    the buffer to use as the backing buffer.
     */
    public JMQByteArrayOutputStream(byte newBuf[]) {
	// If we don't invoke a constructor the no-arg constructor is
	// invoked which allocates a 32 byte buffer we don't want;
	super(0);
	buf = newBuf;
    }

    /**
     * Returns a reference to the backing buffer
     *
     * @return    a reference to the backing buffer. WARNING! This is a 
     *            reference to the buffer -- not a copy. Note that 
     *		  ByteArrayOutputStream will reallocate this buffer if it
     *		  needs more space -- so the buffer returned by getBuf()
     *		  may not match the buffer provided in the constructor!
     */
    public byte[] getBuf() {
	return buf;
    }

    /**
     * Returns the number of valid bytes in the buffer.
     *
     * @return    the number of valid bytes in the buffer.
     */
    public int getCount() {
	return count;
    }
}
