/*
 * @(#)MQObjectInputStream.java	1.3 12/22/05
 *
 * Copyright 2001 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.io;

import java.io.*;

/**
 * A special subclasses of ObjectInputStream that is used for store migration.
 * This class allow us to deserialize an old object format by allowing us to
 * locate class file containing the definitions for the old object format that
 * has been moved to a different package.
 *
 * As an example, we want to change the TransactionUID class, which would make
 * it incompatible with the serialized version in the old store. First, we
 * moved the original version of the TransactionUID to another package, e.g.
 * com.sun.messaging.jmq.jmsserver.data.migration.TransactionUID. Next, we
 * create a new version of com.sun.messaging.jmq.jmsserver.data.TransactionUID
 * class. When loading the old serialized TransactionUID object, we use this
 * class to locate the class definition of the old TransactionUID which has
 * been moved to com.sun.messaging.jmq.jmsserver.data.migration.
 */
public class MQObjectInputStream extends ObjectInputStream {

    public MQObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    /**
     * Overide the ObjectInputStream.resolveClass() to return the old class
     * definition for serialized object prior to 3.7 release.
     */
    protected Class resolveClass(ObjectStreamClass osc)
        throws IOException, ClassNotFoundException {

        Class clazz = null;
        String name = osc.getName();
        long serialVersion = osc.getSerialVersionUID();

        // For performance we check serial version ID before the class name
        if (serialVersion == 1518763750089861353L) {
            if (name.equals("com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement")) {
                clazz = Class.forName("com.sun.messaging.jmq.jmsserver.data.migration.TransactionAcknowledgement");
            }
        } else if (serialVersion == -6848527428749630176L) {
                if (name.equals("com.sun.messaging.jmq.jmsserver.data.TransactionState")) {
                clazz = Class.forName("com.sun.messaging.jmq.jmsserver.data.migration.TransactionState");
            }
        } else if (serialVersion == 4132677693277056907L) {
                if (name.equals("com.sun.messaging.jmq.jmsserver.data.TransactionState")) {
                clazz = Class.forName("com.sun.messaging.jmq.jmsserver.data.migration.finch.TransactionState");
            }
        } else if (serialVersion == 3158474602500727000L) {
            if (name.equals("com.sun.messaging.jmq.jmsserver.data.TransactionUID")) {
                clazz = Class.forName("com.sun.messaging.jmq.jmsserver.data.migration.TransactionUID");
            }
        } else if (serialVersion == 5231476734057401743L) {
            if (name.equals("com.sun.messaging.jmq.jmsserver.core.ConsumerUID")) {
                clazz = Class.forName("com.sun.messaging.jmq.jmsserver.core.migration.ConsumerUID");
            }
        }

        // Return the class definition of old serialized object
        if (clazz != null) {
            return clazz;
        }

        return super.resolveClass(osc);
    }
}
