/*
 * @(#)ServiceEntry.java	1.2 12/06/01
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.io;

import java.util.StringTokenizer;

/**
 * Encapsulates information about a service. For use with the cluster
 * discovery protocol.
 *
 * @version 12/06/01
 */
public class ServiceEntry {
    private String address = null;
    private String protocol = null;;
    private String type = null;;
    private String name = null;

    public final static String SPACE = " ";

    public ServiceEntry() {
    }

    /**
     * Set the transport address for this service.
     *
     * Service address syntax examples :
     * <pre>
     *     jms@host:port
     *     ssljms@host:port
     *     httpjms@http://www.foo.com/jmqservlet?ServerName=jpgserv
     * </pre>
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * Get the service address.
     */
    public String getAddress() {
        return this.address;
    }

    /**
     * Set the protocol.
     */
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /**
     * Get the protocol.
     */
    public String getProtocol() {
        return this.protocol;
    }

    /**
     * Set the service type.
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * Get the service type.
     */
    public String getType() {
        return this.type;
    }

    /**
     * Set the service name.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Get the service name.
     */
    public String getName() {
        return this.name;
    }

    public String toString() {
        return name + SPACE + protocol + SPACE +
            type + SPACE + address;
    }
}

/*
 * EOF
 */
