/*
 * @(#)ConnectionHandler.java	1.3 04/08/18
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import java.io.*;

/**
 *  The connection handler knows how to communicate with the broker uses the
 *  specified protocol.
 *
 *  The implementation of InputStream and OutputStream should be in the way
 *  that no protocol specific values are exposed to the API user.
 */
public interface ConnectionHandler {

    public InputStream
    getInputStream() throws IOException;

    public OutputStream
    getOutputStream() throws IOException;

    public int
    getLocalPort() throws IOException;

    public void
    close() throws IOException;

    public String getBrokerHostName();

    /**
     * Get broker address.
     *
     * @return [host,port] for TCP and SSL protocols.
     *         URL string for HTTP/HTTPS protocols.
     */
    public String getBrokerAddress();

}
