/*
 * @(#)TransactionAcknowledgement.java	1.12 11/30/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.*;
import java.io.*;

/**
 * Acknowledgement for transactions.
 */

public class TransactionAcknowledgement implements Externalizable
{
    transient private Logger logger = Globals.getLogger();

    SysMessageID sysid = null;
    ConsumerUID iid = null;

    static final int MSG_PENDING=0;

    // ok if a message is in MSG_COMPLETE it does not need to
    // be redelivered
    static final int MSG_COMPLETE=1;
    transient int state=MSG_PENDING;

    public void setMsgComplete() {
        state=MSG_COMPLETE;
    }
    public boolean getMsgComplete() {
        return state == MSG_COMPLETE;
    }

    // sid is the stored UID associated w/ the ack
    // at this point, we really just want the stored uid
    // BUT in the future we may want the original UID
    // Since we kept iid in the past, we still keep it
    // for support
    ConsumerUID sid = null;

    // default construct for uninitialized object
    public TransactionAcknowledgement() {
    }

    /**
     * Construct the acknowledgement with the specified sysid and iid.
     * @param sysid	message system id
     * @param iid	interest id
     */
    public TransactionAcknowledgement(SysMessageID sysid, ConsumerUID iid,
            ConsumerUID sid) {
        this.sysid = sysid;
        this.iid = iid;
        this.sid = sid;
    }

    /**
     * @return the interest id
     */
    public ConsumerUID getConsumerUID() {
        return iid;
    }

    /**
     * @return the stored interest id
     */
    public ConsumerUID getStoredConsumerUID() {
        return sid;
    }

    /**
     * @return the message system id
     */
    public SysMessageID getSysMessageID() {
	return sysid;
    }

    /**
     * Returns a hash code value for this object.
     * ?? just added the hashCode of sysid and iid together ??
     */
    public int hashCode() {
	return sysid.hashCode() + iid.hashCode();
    }

    // just compare the hashcode
    public boolean equals(Object o) {
	if ((o instanceof TransactionAcknowledgement) &&
	    (hashCode() == o.hashCode())) {
	    return true;
	} else {
	    return false;
	}
    }

    public String toString() {
	return "[" + sysid.toString() + "]" + iid.toString() + ":"
             + sid.toString();
    }

    // for serializing the object
    public void writeExternal(ObjectOutput out) throws IOException {
	sysid.writeID(out);
	out.writeObject(iid);
	out.writeObject(sid);
    }

    // for serializing the object
    public void readExternal(ObjectInput in)
	throws IOException, ClassNotFoundException {

	sysid = new SysMessageID();
	sysid.readID(in);
	iid = (ConsumerUID)in.readObject();
        try {
	    sid = (ConsumerUID)in.readObject();
        } catch (Exception ex) { // deal w/ missing field in 3.0.1
            logger.log(Logger.DEBUG,
                "TransactionAcknowledgement.readExternal(): old transaction format");
            sid = iid;
        }
    }
}


