/*
 * @(#)TransactionUID.java	1.3 11/30/05
 *
 * Copyright 2001 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data;

import java.io.*;
import com.sun.messaging.jmq.util.UID;


/**
 * Transaction Unique Identifier. A globally unique identifier for
 * a transaction. 
 */
public class TransactionUID extends com.sun.messaging.jmq.util.UID
    implements Externalizable {

    public TransactionUID() {
        // Allocates a new id
        super();
    }

    public TransactionUID(long id) {
        // Wraps an existing id
        super(id);
    }

    public String toString() {
        return super.toString();
    }

    public void readExternal(ObjectInput in)
        throws IOException, ClassNotFoundException {
        id = in.readLong();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(id);
    }
}
