/*
 * @(#)JesmfManager.java	1.2 11/18/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.management.agent;

import com.sun.messaging.jmq.jmsserver.core.Destination;

/**
 * Manager class for MQ/JESMF integration.
 *
 * The methods here are used by the JMX agent to control/initialize
 * the JESMF infrastructure and relevant objects. Some JESMF objects
 * map directly to or have data contained in some MQ MBeans. Because
 * of this, their lifecycle should be closely tied together - this is
 * the reason for having various register/unregister methods here.
 *
 * Some JESMF objects don't have corresponding MQ MBeans, which is why
 * we don't have register/unregister methods for them here e.g.
 * PersistenceStore and UserRepository.
 */
public interface JesmfManager {
    public void initialize(Agent agent);
    public void stop();
    public boolean isActive();

    public void registerPortmapper();
    public void unregisterPortmapper();
    public void portMapperPortUpdated(Integer oldPort, Integer newPort);

    public void registerService(String serviceName);
    public void unregisterService(String serviceName);
    public void serviceStateChanged(String svcName);
    public void serviceAttrUpdated(String svcName, 
		    String attrName, Object oldVal, Object newVal);

    public void registerDestination(Destination d);
    public void unregisterDestination(Destination d);
    public void destinationStateChanged(Destination d);
    public void destinationAttrUpdated(Destination d, int attr, 
		    Object oldVal, Object newVal);
}
