/*
 * @(#)ConsumerManagerMonitor.java	1.12 02/13/06
 *
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.management.mbeans;

import java.util.Iterator;
import java.util.HashSet;
import java.util.ArrayList;

import javax.management.ObjectName;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanException;
import javax.management.openmbean.CompositeData;

import com.sun.messaging.jms.management.server.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.management.util.ConsumerUtil;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.core.Consumer;

public class ConsumerManagerMonitor extends MQMBeanReadOnly {
    private static MBeanAttributeInfo[] attrs = {
	    new MBeanAttributeInfo(ConsumerAttributes.NUM_CONSUMERS,
					Integer.class.getName(),
					mbr.getString(mbr.I_CON_MGR_ATTR_NUM_CONSUMERS),
					true,
					false,
					false)
			};

    private static MBeanParameterInfo[] getConsumerInfoByIDSignature = {
		    new MBeanParameterInfo("consumerID", String.class.getName(),
			mbr.getString(mbr.I_CON_MGR_OP_PARAM_CON_ID_DESC))
			    };

    private static MBeanOperationInfo[] ops = {
	    new MBeanOperationInfo(ConsumerOperations.GET_CONSUMER_IDS,
		mbr.getString(mbr.I_CON_MGR_OP_GET_CONSUMER_IDS_DESC),
		    null , 
		    String[].class.getName(),
		    MBeanOperationInfo.INFO),

	    new MBeanOperationInfo(ConsumerOperations.GET_CONSUMER_INFO,
		mbr.getString(mbr.I_CON_MGR_OP_GET_CONSUMER_INFO_DESC),
		    null , 
		    CompositeData[].class.getName(),
		    MBeanOperationInfo.INFO),

	    new MBeanOperationInfo(ConsumerOperations.GET_CONSUMER_INFO_BY_ID,
		mbr.getString(mbr.I_CON_MGR_OP_GET_CONSUMER_INFO_BY_ID_DESC),
		    getConsumerInfoByIDSignature, 
		    CompositeData.class.getName(),
		    MBeanOperationInfo.INFO)
		};

    public ConsumerManagerMonitor()  {
	super();
    }

    public Integer getNumConsumers()  {
        return (new Integer(ConsumerUtil.getNumConsumersNoChildren()));
    }

    public String[] getConsumerIDs()  {
	return (ConsumerUtil.getConsumerIDs());
    }

    public CompositeData[] getConsumerInfo() throws MBeanException {
	CompositeData cds[] = null;

	try  {
	    cds = ConsumerUtil.getConsumerInfo();
	} catch(Exception e)  {
	    handleOperationException(ConsumerOperations.GET_CONSUMER_INFO, e);
	}

	return (cds);
    }

    public CompositeData getConsumerInfoByID(String consumerID) throws MBeanException  {
	CompositeData cd = null;

	try  {
	    cd = ConsumerUtil.getConsumerInfo(consumerID);
	} catch(Exception e)  {
	    handleOperationException(ConsumerOperations.GET_CONSUMER_INFO_BY_ID, e);
	}

	return (cd);
    }

    public String getMBeanName()  {
	return ("ConsumerManagerMonitor");
    }

    public String getMBeanDescription()  {
	return (mbr.getString(mbr.I_CON_MGR_MON_DESC));
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo()  {
	return (attrs);
    }

    public MBeanOperationInfo[] getMBeanOperationInfo()  {
	return (ops);
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo()  {
	return (null);
    }
}
