/*
 * @(#)ClusterBrokerInfoReply.java	1.2 08/05/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.multibroker;

import java.io.*;
import java.util.*;
import java.nio.*;
import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;

/**
 * BROKER_INFO_REPLY
 */

public class ClusterBrokerInfoReply 
{
    public static boolean DEBUG = false;

    private BrokerInfo brokerInfo = null;
    private int status = ProtocolGlobals.G_BROKER_INFO_OK;

    private GPacket pkt = null;

    private ClusterBrokerInfoReply(BrokerInfo bi, int status) {
        this.brokerInfo = bi;
        this.status = status;
    }

    private ClusterBrokerInfoReply(GPacket pkt) throws Exception {

        assert ( pkt.getType() == ProtocolGlobals.G_BROKER_INFO_REPLY );

        this.pkt = pkt;
        status = ((Integer)pkt.getProp("S")).intValue(); 

        ByteArrayInputStream bis = new ByteArrayInputStream(pkt.getPayload().array());
        ObjectInputStream ois = new ObjectInputStream(bis);
        brokerInfo = (BrokerInfo) ois.readObject();
 
    }

    /**
     */
    public static ClusterBrokerInfoReply newInstance(BrokerInfo bi, int status) {
        return new ClusterBrokerInfoReply(bi, status);
    }

    /**
     */
    public static ClusterBrokerInfoReply newInstance(GPacket pkt) throws Exception {
        return new ClusterBrokerInfoReply(pkt);
    }

    public GPacket getGPacket() throws Exception { 

        GPacket gp = GPacket.getInstance();
        gp.setType(ProtocolGlobals.G_BROKER_INFO_REPLY);
        gp.setBit(pkt.A_BIT, false);
        gp.putProp("S", new Integer(status));

        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(brokerInfo);
        oos.flush();
        oos.close();

        byte[] buf = bos.toByteArray();
        gp.setPayload(ByteBuffer.wrap(buf));
        return gp;
    }

    public int getStatus() {
        return status;
    }

    public BrokerInfo getBrokerInfo() {
        return brokerInfo;
    }

    public boolean isTakingover() {
        return (getStatus() == ProtocolGlobals.G_BROKER_INFO_TAKINGOVER);
    }

    public boolean sendAndClose() {
        return isTakingover();
    }
}
