/*
 * @(#)ClusterCallback.java	1.14 07/28/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;

/**
 * This interface defines a mechanism for receiving packets
 * from the broker cluster. Only the <code> MessageBus </code> class
 * implements this interface.
 */
public interface ClusterCallback {

    public int getHighestSupportedVersion();

    /**
     * Receive a unicast packet.
     * @param sender Address of the broker who sent this message.
     * @param pkt Packet.
     */
    public void receiveUnicast(BrokerAddress sender, GPacket pkt);

    /**
     * Receive a broadcast packet.
     * @param sender Address of the broker who sent this message.
     * @param pkt Packet.
     */
    public void receiveBroadcast(BrokerAddress sender, GPacket pkt);

    /**
     * Receive a unicast packet.
     * @param sender Address of the broker who sent this message.
     * @param destId Tells the this broker how this message
     * shoule be handled
     * @param pkt Packet data.
     */
    public void receiveUnicast(BrokerAddress sender, int destId, byte []pkt);

    /**
     * Receive a broadcast packet.
     * @param sender Address of the broker who sent this message.
     * @param destId Tells the this broker how this message
     * shoule be handled
     * @param pkt Packet data.
     */
    public void receiveBroadcast(BrokerAddress sender, int destId, byte []pkt);

    /**
     * Construct a BrokerInfo object that describes this broker.
     * This object is exchanged during initial handshake between
     * brokers.
     * @return BrokerInfo object describing the current state of the broker.
     */
    public BrokerInfo getBrokerInfo();

    /**
     */
    public ClusterBrokerInfoReply getBrokerInfoReply(BrokerInfo remote) throws Exception;

    public static final int ADD_BROKER_INFO_OK = 0;
    public static final int ADD_BROKER_INFO_RETRY = 1;
    public static final int ADD_BROKER_INFO_BAN = 2;

    /**
     * Add a new broker to the list of known brokers in this cluster.
     * This serves as a notification that a new broker has joined
     * the cluster so all the ongoing (unresolved) elections for
     * locking various resources must be repeated.
     *
     * @return false if the new broker is rejected due to some
     * state mismatch, otherwise true. If the return value is false,
     * the topology driver should forget all about the new broker
     * and let it retry the connection..
     */
    public int addBrokerInfo(BrokerInfo brokerInfo);

    /**
     * Remove a broker since it is no longer attached to this cluster.
     * This serves as a notification that a broker has left the cluster,
     * so all the interests local to that broker are no longer valid.
     */
    public void removeBrokerInfo(BrokerAddress broker);

    public void preTakeover(String broker, UID storeSession,  String brokerHost, UID brokerSession);

    public void postTakeover(String broker, UID storeSession, boolean aborted);
}

/*
 * EOF
 */
